/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbpjava.checker;

import gov.nasa.jpf.PropertyListenerAdapter;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.MethodInfo;
import gov.nasa.jpf.jvm.StackFrame;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.ThreadList;
import gov.nasa.jpf.jvm.bytecode.INVOKESTATIC;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import gov.nasa.jpf.jvm.bytecode.InvokeInstruction;
import gov.nasa.jpf.jvm.bytecode.ReturnInstruction;
import gov.nasa.jpf.search.Search;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.ow2.dsrg.fm.tbpjava.EnvGenerator;
import org.ow2.dsrg.fm.tbpjava.checker.EventItem;
import org.ow2.dsrg.fm.tbpjava.checker.EventParser;
import org.ow2.dsrg.fm.tbpjava.checker.JPFProgramStateMapping;
import org.ow2.dsrg.fm.tbpjava.checker.JPFSearch;
import org.ow2.dsrg.fm.tbpjava.checker.StatesMapper;
import org.ow2.dsrg.fm.tbpjava.checker.ThreadAutomatons;
import org.ow2.dsrg.fm.tbpjava.utils.Configuration;

public class ProtocolListener
extends PropertyListenerAdapter {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_INFO = false;
    private static final String METHOD_NAME_THREAD_RUN = "run";
    private static final String METHOD_NAME_CONSTRUCTOR = "<init>";
    private EventParser eventParser;
    private final StatesMapper varStateMap;
    private Map<String, String> mapFullName2ItfsName;
    private Stack<StackEntryStruct> stackEvents = new Stack();
    private PrintStream out = System.out;
    private int uniqueStates = 0;
    private int visitedStates = 0;
    private Map<String, String> provItfs2implClass;
    private Map<String, String> reqItfs2implClass;
    private Map<Integer, ThreadAutomatons.ThreadType> startedThreads = new HashMap<Integer, ThreadAutomatons.ThreadType>();
    private List<Integer> endedThreads = new ArrayList<Integer>();
    private boolean checkFailed = false;
    private boolean endStateOccured = false;
    private boolean errorReported = false;
    private String errorString = "";
    private final String environmentClassName;
    private final Configuration config;
    private final List<EventItem> eventList = new ArrayList<EventItem>();
    private JPFProgramStateMapping programStateMapper = null;

    public ProtocolListener(Configuration config, EventParser eventParser, StatesMapper varStateMap, EnvGenerator.EnvironmentDescription envDesc, Map<String, String> reqItfs2implClass, String environmentClassName, PrintStream out) {
        assert (environmentClassName != null);
        this.config = config;
        this.provItfs2implClass = ProtocolListener.generateProvItfs2implClass(envDesc);
        this.reqItfs2implClass = reqItfs2implClass;
        this.eventParser = eventParser;
        this.environmentClassName = environmentClassName;
        this.varStateMap = varStateMap;
        if (out != null) {
            this.out = out;
        }
        this.mapFullName2ItfsName = ProtocolListener.createFullNameMap(config, this.provItfs2implClass, reqItfs2implClass, out);
    }

    public void searchStarted(Search search) {
        this.stackEvents.clear();
        this.endedThreads.clear();
        this.startedThreads.clear();
        if (!(search instanceof JPFSearch)) {
            throw new RuntimeException("Invalid search used. Expected " + JPFSearch.class.getName() + " but used " + search.getClass().getName());
        }
        JPFSearch jpfSearch = (JPFSearch)search;
        jpfSearch.setStatesMapper(this.varStateMap);
        this.programStateMapper = jpfSearch.getJPFProgramStateMapping();
        this.eventParser.initializeEventParser();
        super.searchStarted(search);
    }

    public void searchFinished(Search search) {
        if (!this.checkFailed && !this.endStateOccured) {
            this.out.println("Warning: no end state occured - there is probably an infinite loop or a deadlock in the code");
        }
        if (this.checkFailed) {
            this.out.println("Interface calls event trace");
            this.printEventStack(true);
        }
        this.out.println("Unique states: " + this.uniqueStates);
        this.out.println("Visited states: " + this.visitedStates);
        this.out.println(this.programStateMapper.getUsageStatistics());
    }

    public void stateAdvanced(Search search) {
        if (search.isNewState()) {
            ++this.uniqueStates;
        }
        ++this.visitedStates;
        int jpfStateID = search.getVM().getSystemState().getId();
        if (this.eventList.size() > 0 || this.startedThreads.size() > 0 || this.endedThreads.size() > 0) {
            this.stackEvents.add(new StackEntryStruct(this.eventList, jpfStateID, this.startedThreads, this.endedThreads));
            this.checkFailed |= !this.eventParser.processEvents(this.startedThreads, this.eventList, this.endedThreads);
        } else {
            this.stackEvents.push(null);
        }
        this.programStateMapper.advancedEvents(this.eventList, jpfStateID);
        if (search.isEndState()) {
            this.endStateOccured = true;
        }
        this.startedThreads.clear();
        this.endedThreads.clear();
        this.eventList.clear();
    }

    public void stateBacktracked(Search search) {
        StackEntryStruct event = this.stackEvents.pop();
        if (event != null) {
            this.eventParser.undoEvents();
        }
        this.programStateMapper.undoEvents();
    }

    public void stateProcessed(Search search) {
        int currentJPFStateID = search.getVM().getStateId();
        this.programStateMapper.addMapping(currentJPFStateID);
    }

    public void instructionExecuted(JVM vm) {
        Instruction instr = vm.getLastInstruction();
        ThreadInfo ti = vm.getLastThreadInfo();
        if (instr instanceof InvokeInstruction) {
            InvokeInstruction invokeInstr = (InvokeInstruction)instr;
            MethodInfo mi = invokeInstr.getInvokedMethod();
            String className = ProtocolListener.getClassName(mi);
            String methodName = ProtocolListener.getMethodName(mi);
            String fullMethodName = className + "." + methodName;
            String ifaceName = this.mapFullName2ItfsName.get(fullMethodName);
            if (ifaceName != null) {
                EventItem event = new EventItem(ti.getIndex(), EventItem.EventTypes.EVENT_CALL, methodName, ifaceName, instr.getLineNumber());
                this.eventList.add(event);
                Instruction nextInst = vm.getNextInstruction();
                if (!ProtocolListener.isVerifyCall(nextInst)) {
                    ti.reschedule(true);
                }
            }
        } else if (instr instanceof ReturnInstruction) {
            MethodInfo mi = instr.getMethodInfo();
            String className = ProtocolListener.getClassName(mi);
            String methodName = ProtocolListener.getMethodName(mi);
            String fullMethodName = className + "." + methodName;
            String ifaceName = this.mapFullName2ItfsName.get(fullMethodName);
            if (ifaceName != null) {
                EventItem event = new EventItem(ti.getIndex(), EventItem.EventTypes.EVENT_RETURN, methodName, ifaceName, ti.getLine());
                this.eventList.add(event);
                Instruction nextInst = vm.getNextInstruction();
                if (!ProtocolListener.isVerifyCall(nextInst)) {
                    ti.reschedule(true);
                }
            }
        }
    }

    public void threadTerminated(JVM vm) {
        ThreadInfo ti = vm.getLastThreadInfo();
        this.endedThreads.add(ti.getIndex());
    }

    public void threadStarted(JVM vm) {
        ThreadInfo threadStarted = vm.getCurrentThread();
        this.startedThreads.put(vm.getLastThreadInfo().getIndex(), this.analyzeStackThreadCreation(threadStarted));
    }

    public void exceptionThrown(JVM vm) {
    }

    public void exceptionBailout(JVM vm) {
        ThreadInfo ti = vm.getLastThreadInfo();
        StackFrame topSF = ti.getTopFrame();
        MethodInfo mi = topSF.getMethodInfo();
        String className = ProtocolListener.getClassName(mi);
        String methodName = ProtocolListener.getMethodName(mi);
        String fullMethodName = className + "." + methodName;
        String ifaceName = this.mapFullName2ItfsName.get(fullMethodName);
        if (ifaceName != null) {
            EventItem event = new EventItem(ti.getIndex(), EventItem.EventTypes.EVENT_RETURN, methodName, ifaceName, ti.getLine());
            this.eventList.add(event);
            ti.reschedule(true);
        }
    }

    public void exceptionHandled(JVM vm) {
    }

    public boolean check(Search search, JVM vm) {
        if (this.errorReported) {
            return true;
        }
        if (this.checkFailed) {
            this.errorReported = true;
        }
        return !this.checkFailed;
    }

    public final String getErrorMessage() {
        return "Tested component is not compliant with the protocol\n" + this.errorString;
    }

    public final Map<String, String> getProvItfs2implClass() {
        return this.provItfs2implClass;
    }

    public final Map<String, String> getReqItfs2implClass() {
        return this.reqItfs2implClass;
    }

    public void printEventStack(boolean filterSubsequentProvidedCalls) {
        int maxThreadNum = 0;
        for (StackEntryStruct stackStepEntry : this.stackEvents) {
            List<EventItem> eventList;
            if (stackStepEntry == null || (eventList = stackStepEntry.getEvents()) == null) continue;
            for (EventItem event : eventList) {
                if (event.thread <= maxThreadNum) continue;
                maxThreadNum = event.thread;
            }
        }
        int[] providedCallDepth = new int[maxThreadNum + 1];
        this.out.println(EventItem.eventTraceHeader());
        this.out.println(EventItem.eventTraceSeparator());
        for (StackEntryStruct stackStepEntry : this.stackEvents) {
            int processedEvents;
            List<EventItem> eventList;
            if (stackStepEntry == null) continue;
            if (stackStepEntry.getStartedThreads() != null && !stackStepEntry.getStartedThreads().isEmpty()) {
                this.out.print("Started threads :");
                boolean first = true;
                for (Map.Entry<Integer, ThreadAutomatons.ThreadType> startedThread : stackStepEntry.getStartedThreads().entrySet()) {
                    if (first) {
                        first = false;
                    } else {
                        this.out.print(", ");
                    }
                    this.out.print(startedThread.getKey() + "(" + (Object)((Object)startedThread.getValue()) + ")");
                }
                this.out.println();
            }
            if ((eventList = stackStepEntry.getEvents()) == null) continue;
            int eventToPrint = eventList.size();
            if (((Object)eventList).equals(this.stackEvents.lastElement()) && (processedEvents = this.eventParser.getProcessEventIndexErrorEvent() + 1) != -1 && processedEvents >= 0 && processedEvents < eventList.size()) {
                eventToPrint = processedEvents;
            }
            for (int i = 0; i < eventToPrint; ++i) {
                EventItem event = eventList.get(i);
                boolean isProvided = this.getProvItfs2implClass().containsKey(event.interfaceName);
                if (isProvided) {
                    if (event.type == EventItem.EventTypes.EVENT_CALL) {
                        int n = event.thread;
                        providedCallDepth[n] = providedCallDepth[n] + 1;
                    } else if (event.type != EventItem.EventTypes.EVENT_RETURN) {
                        throw new RuntimeException("INTERNAL ERROR - Unknown EventTypes entry=" + (Object)((Object)event.type));
                    }
                    if (!filterSubsequentProvidedCalls || providedCallDepth[event.thread] <= 1) {
                        this.out.println(event.toStringEventTrace(this));
                    }
                    if (event.type == EventItem.EventTypes.EVENT_CALL) continue;
                    if (event.type == EventItem.EventTypes.EVENT_RETURN) {
                        int n = event.thread;
                        providedCallDepth[n] = providedCallDepth[n] - 1;
                        continue;
                    }
                    throw new RuntimeException("INTERNAL ERROR - Unknown EventTypes entry=" + (Object)((Object)event.type));
                }
                this.out.println(event.toStringEventTrace(this));
            }
            if (stackStepEntry.getEndedThreads() == null || stackStepEntry.getEndedThreads().isEmpty()) continue;
            this.out.print("Ended threads :");
            boolean first = true;
            for (Integer endedThread : stackStepEntry.getEndedThreads()) {
                if (first) {
                    first = false;
                } else {
                    this.out.print(", ");
                }
                this.out.print(endedThread);
            }
            this.out.println();
        }
    }

    private void DEBUG_printJVMThreadsWithStack(JVM jvm, PrintStream out) {
        ThreadInfo[] tis;
        out.println("Debuging JVM state - threads");
        ThreadList tl = jvm.getThreadList();
        for (ThreadInfo ti : tis = tl.getThreads()) {
            out.print("   Thread:" + ti + ", ThreadNum: " + ti.getIndex() + ", Status=" + ti.getStateName() + ", NewlyStartedThread=" + (jvm.getLastThreadInfo() == ti) + ", ThreadCalledStart=" + (jvm.getCurrentThread() == ti) + ", ThreadType=");
            try {
                ThreadAutomatons.ThreadType tt = this.getThreadType(ti.getIndex());
                out.println((Object)tt);
            }
            catch (RuntimeException e) {
                out.println("???");
            }
            for (StackFrame sf : ti.getStack()) {
                out.println("       Class:" + sf.getClassName() + ", Method: " + sf.getMethodName() + ", line=" + sf.getLine());
            }
        }
    }

    private static String getClassName(MethodInfo mi) {
        if (mi == null) {
            return "";
        }
        if (mi.getClassInfo() == null) {
            return "";
        }
        return mi.getClassInfo().getName();
    }

    private static String getMethodName(MethodInfo mi) {
        if (mi == null) {
            return "";
        }
        return mi.getName();
    }

    private static final boolean isVerifyCall(Instruction instr) {
        return instr instanceof INVOKESTATIC && ((INVOKESTATIC)instr).getInvokedMethod().getClassName().equals("gov.nasa.jpf.jvm.Verify");
    }

    private static Map<String, String> createFullNameMap(Configuration config, Map<String, String> provItfs2implClass, Map<String, String> reqItfs2implClass, PrintStream out) {
        assert (config != null);
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        HashMap<String, String> result = new HashMap<String, String>();
        ProtocolListener.createFullNameMap1(result, config.getComponentProvidedInterfaces(), provItfs2implClass, out, cl);
        ProtocolListener.createFullNameMap1(result, config.getComponentRequiredInterfaces(), reqItfs2implClass, out, cl);
        return result;
    }

    private static boolean createFullNameMap1(Map<String, String> result, Map<String, String> interfaces, Map<String, String> implClasses, PrintStream out, ClassLoader cl) {
        assert (result != null);
        assert (interfaces != null);
        assert (implClasses != null);
        assert (out != null);
        boolean error = false;
        for (Map.Entry<String, String> entry : interfaces.entrySet()) {
            String ifaceName = entry.getKey();
            String ifaceClassName = entry.getValue();
            Class<?> ifaceClass = null;
            try {
                ifaceClass = Thread.currentThread().getContextClassLoader().loadClass(ifaceClassName);
            }
            catch (ClassNotFoundException e) {
                out.println("Error - interface " + ifaceName + " definition (Class " + ifaceClassName + ") not found.");
                error = true;
            }
            String ifaceImplClassName = implClasses.get(ifaceName);
            if (ifaceImplClassName == null) {
                out.println("Error - not specified class implementing interface " + ifaceName);
                error = true;
            }
            Class<?> ifaceImplClass = null;
            try {
                ifaceImplClass = Thread.currentThread().getContextClassLoader().loadClass(ifaceImplClassName);
            }
            catch (ClassNotFoundException e) {
                out.println("Error - implementing class not found. " + ifaceImplClassName);
                error = true;
            }
            if (ifaceImplClass != null && ifaceClass != null && !ifaceClass.isAssignableFrom(ifaceImplClass)) {
                out.println("Error - class (" + ifaceImplClassName + ") not implement specified interface (" + ifaceClassName + ")");
                error = true;
            }
            if (error) continue;
            for (Method ifaceMethod : ifaceClass.getMethods()) {
                String ifaceMethodName = ifaceMethod.getName();
                String addedName = ifaceImplClassName + "." + ifaceMethodName;
                result.put(addedName, ifaceName);
            }
        }
        return error;
    }

    private ThreadAutomatons.ThreadType analyzeStackThreadCreation(ThreadInfo ti) {
        if (ti == null) {
            return ThreadAutomatons.ThreadType.NONE_EVENT_THREAD;
        }
        List sfs = ti.getStack();
        if (sfs.size() == 3 && this.isMethodCall((StackFrame)sfs.get(0), "main") && this.isMethodCall((StackFrame)sfs.get(1), "runEnvironment")) {
            return ThreadAutomatons.ThreadType.ENVIRONMENT_THREAD;
        }
        if (sfs.size() == 2 && this.isRunMethodCall((StackFrame)sfs.get(0)) && this.getThreadType(ti.getIndex()) == ThreadAutomatons.ThreadType.ENVIRONMENT_THREAD) {
            return ThreadAutomatons.ThreadType.ENVIRONMENT_THREAD;
        }
        if (sfs.size() >= 3 && this.isMethodCall((StackFrame)sfs.get(0), "main") && this.isMethodCall((StackFrame)sfs.get(1), METHOD_NAME_CONSTRUCTOR) && this.isMethodCall((StackFrame)sfs.get(2), this.config.getEnvValueSets(), METHOD_NAME_CONSTRUCTOR)) {
            return ThreadAutomatons.ThreadType.NONE_EVENT_THREAD;
        }
        int i = 0;
        for (i = 0; i < sfs.size(); ++i) {
            StackFrame sf = (StackFrame)sfs.get(i);
            String className = ProtocolListener.getClassName(sf.getMethodInfo());
            String methodName = ProtocolListener.getMethodName(sf.getMethodInfo());
            String fullMethodName = className + "." + methodName;
            String itfsName = this.mapFullName2ItfsName.get(fullMethodName);
            if (itfsName != null) {
                if (this.config.getComponentProvidedInterfaces().containsKey(itfsName)) {
                    return ThreadAutomatons.ThreadType.THREAD_SECTION;
                }
                if (this.config.getComponentRequiredInterfaces().containsKey(itfsName)) {
                    return ThreadAutomatons.ThreadType.NONE_EVENT_THREAD;
                }
            }
            if (!this.isConstructorCall(sf, this.config.getComponentImplementationClasses())) continue;
            return ThreadAutomatons.ThreadType.THREAD_SECTION;
        }
        return ThreadAutomatons.ThreadType.NONE_EVENT_THREAD;
    }

    private boolean isConstructorCall(StackFrame sf, List<String> componentImplementationClasses) {
        for (String compClass : componentImplementationClasses) {
            if (!this.isMethodCall(sf, compClass, METHOD_NAME_CONSTRUCTOR)) continue;
            return true;
        }
        return false;
    }

    private final ThreadAutomatons.ThreadType getThreadType(int threadNum) {
        ThreadAutomatons.ThreadType result = this.startedThreads.get(threadNum);
        if (result == null) {
            result = this.eventParser.getThreadType(threadNum);
        }
        if (result == null) {
            throw new RuntimeException("Internal error - Cann't determine thread type");
        }
        return result;
    }

    private final boolean isMethodCall(StackFrame sf, String methodName) {
        return this.isMethodCall(sf, this.environmentClassName, methodName);
    }

    private final boolean isMethodCall(StackFrame sf, String className, String methodName) {
        return sf != null && className.equals(sf.getClassName()) && methodName.equals(sf.getMethodName());
    }

    private final boolean isRunMethodCall(StackFrame sf) {
        return sf != null && sf.getClassName().startsWith(this.environmentClassName + "$") && METHOD_NAME_THREAD_RUN.equals(sf.getMethodName());
    }

    private static Map<String, String> generateProvItfs2implClass(EnvGenerator.EnvironmentDescription envDesc) {
        HashMap<String, String> provItfs2implClass = new HashMap<String, String>();
        block0: for (Map.Entry<String, String> provItfsEntry : envDesc.provItfs2envFieldName.entrySet()) {
            String fieldName = provItfsEntry.getValue();
            for (Map.Entry<String, String> compImpl2fieldEntry : envDesc.compImpl2envFieldName.entrySet()) {
                if (!compImpl2fieldEntry.getValue().equals(fieldName)) continue;
                provItfs2implClass.put(provItfsEntry.getKey(), compImpl2fieldEntry.getKey());
                continue block0;
            }
        }
        return provItfs2implClass;
    }

    private static class StackEntryStruct {
        private List<EventItem> events;
        private int jpfStateID;
        private List<Integer> endedThreads;
        private Map<Integer, ThreadAutomatons.ThreadType> startedThreads;

        public StackEntryStruct(List<EventItem> events, int jpfStateID, Map<Integer, ThreadAutomatons.ThreadType> startedThreads, List<Integer> endedThreads) {
            this.events = new ArrayList<EventItem>(events);
            this.endedThreads = new ArrayList<Integer>(endedThreads);
            this.startedThreads = new HashMap<Integer, ThreadAutomatons.ThreadType>(startedThreads);
            this.jpfStateID = jpfStateID;
        }

        public final List<EventItem> getEvents() {
            return this.events;
        }

        public final int getJPFStateID() {
            return this.jpfStateID;
        }

        public final List<Integer> getEndedThreads() {
            return this.endedThreads;
        }

        public final Map<Integer, ThreadAutomatons.ThreadType> getStartedThreads() {
            return this.startedThreads;
        }
    }
}

