/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbpjava;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.Error;
import gov.nasa.jpf.JPF;
import gov.nasa.jpf.JPFListener;
import gov.nasa.jpf.Property;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.MethodInfo;
import gov.nasa.jpf.jvm.Path;
import gov.nasa.jpf.jvm.Step;
import gov.nasa.jpf.jvm.Transition;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import gov.nasa.jpf.search.Search;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.ow2.dsrg.fm.tbpjava.EnvGenerator;
import org.ow2.dsrg.fm.tbpjava.checker.AutomatonToDot;
import org.ow2.dsrg.fm.tbpjava.checker.EventParser;
import org.ow2.dsrg.fm.tbpjava.checker.JPFSearch;
import org.ow2.dsrg.fm.tbpjava.checker.PropertyUncaughtExceptions;
import org.ow2.dsrg.fm.tbpjava.checker.ProtocolListener;
import org.ow2.dsrg.fm.tbpjava.checker.StatesMapper;
import org.ow2.dsrg.fm.tbpjava.envgen.CodeGenerator;
import org.ow2.dsrg.fm.tbpjava.envgen.StubGenerator;
import org.ow2.dsrg.fm.tbpjava.utils.CheckerResult;
import org.ow2.dsrg.fm.tbpjava.utils.ClassloaderDir;
import org.ow2.dsrg.fm.tbpjava.utils.Configuration;
import org.ow2.dsrg.fm.tbpjava.utils.DefaultJPFConfigurationGenerator;
import org.ow2.dsrg.fm.tbplib.EventTable;
import org.ow2.dsrg.fm.tbplib.EventTableImpl;
import org.ow2.dsrg.fm.tbplib.ltsa.Automaton;
import org.ow2.dsrg.fm.tbplib.ltsa.LTSAAutomaton;
import org.ow2.dsrg.fm.tbplib.ltsa.LTSAComponentSpecification;
import org.ow2.dsrg.fm.tbplib.ltsa.util.ComponentReactionEdgeFiter;
import org.ow2.dsrg.fm.tbplib.parsed.ParsedComponentSpecification;
import org.ow2.dsrg.fm.tbplib.resolved.ResolvedComponentSpecification;
import org.ow2.dsrg.fm.tbplib.resolved.util.Binding;

public class Checker {
    private static boolean JPF_WITH_TBP_CHECKER = true;
    public static final String ERROR_PREFIX = "ERROR - ";
    public static final String INTERNAL_ERROR_PREFIX = "INTERNAL ERROR - ";
    public static final String DEBUG_PREFIX = "DEBUG - ";
    private static boolean DEBUG = false;

    public static CheckerResult runTool(Configuration config, String classpathForJpfModelClasses, PrintStream out) {
        Checker.updateClassPath(config, out);
        TreeMap<String, String> reqItfs2implClass = new TreeMap<String, String>();
        EnvGenerator generator = new EnvGenerator(config, out);
        Map<String, EnvGenerator.EnvironmentDescription> genEnvirons = generator.generateEnvironments();
        if (genEnvirons == null) {
            return CheckerResult.creaResultErrorMessage("Error while generating environments. Check output to see more details.");
        }
        for (String reqItfsName : config.getComponentRequiredInterfaces().keySet()) {
            StubGenerator sb = new StubGenerator(config, reqItfsName, out);
            String generatedStubClassName = sb.generateStub();
            if (generatedStubClassName == null) {
                return CheckerResult.creaResultErrorMessage("Error while generating environments. Check output to see more details.");
            }
            reqItfs2implClass.put(reqItfsName, generatedStubClassName);
        }
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        if (compiler == null) {
            out.println("ERROR - Cannot found java compiler to compile generated files. (Do you have JDK installed?)");
            return CheckerResult.creaResultErrorMessage("Cannot found java compiler to compile generated files. (Do you have JDK installed?)");
        }
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
        ArrayList<String> javaFileNames = new ArrayList<String>(genEnvirons.size() + reqItfs2implClass.size());
        for (String classFullName : genEnvirons.keySet()) {
            if (DEBUG) {
                out.println("ClassFullName=" + classFullName);
            }
            if (classFullName == null) continue;
            javaFileNames.add(config.getEnvTargetDir() + File.separator + classFullName.replace('.', '/') + ".java");
        }
        for (String classFullName : reqItfs2implClass.values()) {
            javaFileNames.add(config.getEnvTargetDir() + File.separator + classFullName.replace('.', '/') + ".java");
        }
        Iterable<? extends JavaFileObject> javaFiles = fileManager.getJavaFileObjectsFromStrings(javaFileNames);
        ArrayList<String> options = new ArrayList<String>();
        options.add("-Xlint");
        options.add("-d");
        options.add(config.getEnvTargetDir());
        options.add("-sourcepath");
        options.add(config.getEnvTargetDir());
        options.add("-cp");
        options.add(System.getProperty("java.class.path"));
        StringWriter compilerOutput = new StringWriter();
        Boolean compileResult = compiler.getTask(compilerOutput, fileManager, null, options, null, javaFiles).call();
        if (!compileResult.booleanValue()) {
            out.println("ERROR - Failed the compile the environment classes");
            out.println("Compilation details");
            out.println(compilerOutput.getBuffer());
            out.println("ERROR - Failed the compile the environment classes");
            return CheckerResult.creaResultErrorMessage("Failed the compile the environment classes");
        }
        out.println("Generating automatons");
        EventTableImpl et = new EventTableImpl();
        ParsedComponentSpecification parsedCompoSpec = generator.getComponentSpecification();
        ResolvedComponentSpecification resolvedCompSpec = parsedCompoSpec.resolve((EventTable)et);
        LTSAComponentSpecification LTSACompSpec = resolvedCompSpec.makeLTSA((EventTable)et);
        Checker.DEBUG_generateDOTFilesForAutomatons(LTSACompSpec, (EventTable)et, config, "WithNULLs");
        ComponentReactionEdgeFiter automatonFilter = new ComponentReactionEdgeFiter();
        automatonFilter.processSpecification(LTSACompSpec);
        Checker.DEBUG_generateDOTFilesForAutomatons(LTSACompSpec, (EventTable)et, config, "WithoutNULLs");
        out.println("Running patched JPF to check specification compilance");
        for (String environClass : genEnvirons.keySet()) {
            JPF jpf;
            Search search;
            EnvGenerator.EnvironmentDescription envDesc = genEnvirons.get(environClass);
            StatesMapper varStatesMap = new StatesMapper(LTSACompSpec);
            EventParser eventParser = new EventParser(config, LTSACompSpec, varStatesMap, envDesc);
            ProtocolListener pl = new ProtocolListener(config, eventParser, varStatesMap, envDesc, reqItfs2implClass, environClass, System.out);
            String envTargetDir = config.getEnvTargetDir();
            envTargetDir = envTargetDir.substring(0, envTargetDir.length() - 1);
            ArrayList<String> jpfArgs = new ArrayList<String>(10);
            DefaultJPFConfigurationGenerator.addDefaultJPFConfig(jpfArgs);
            jpfArgs.add("+search.properties= ");
            if (JPF_WITH_TBP_CHECKER) {
                jpfArgs.add("+search.class=org.ow2.dsrg.fm.tbpjava.checker.JPFSearch");
            }
            jpfArgs.add("+classpath=" + envTargetDir + ":" + System.getProperty("java.class.path"));
            jpfArgs.add("+sourcepath=" + envTargetDir + "," + Checker.converClassPathIntoJPFpath(System.getProperty("java.source.path")));
            jpfArgs.add("+report.console.property_violation=error,snapshot");
            jpfArgs.add("+vm.store_steps=true");
            if (DEBUG) {
                jpfArgs.add("+report.console.property_violation=error,trace,error,snapshot");
                jpfArgs.add("+report.console.show_method=true");
                jpfArgs.add("+report.console.show_code=true");
            }
            jpfArgs.add("+search.properties=org.ow2.dsrg.fm.tbpjava.checker.PropertyUncaughtExceptions");
            jpfArgs.add(environClass);
            String[] jpfArgsArray = new String[]{};
            jpfArgsArray = jpfArgs.toArray(jpfArgsArray);
            Config jpfConfig = JPF.createConfig((String[])jpfArgsArray);
            if (DEBUG) {
                out.println("Used JPF Configuration");
                jpfConfig.printEntries();
            }
            if ((search = (jpf = new JPF(jpfConfig)).getSearch()) instanceof JPFSearch) {
                JPFSearch jpfSearch = (JPFSearch)search;
                List<Property> properties = jpfSearch.getJPFProperties();
                for (Property prop : properties) {
                    if (!(prop instanceof PropertyUncaughtExceptions)) continue;
                    PropertyUncaughtExceptions unExProp = (PropertyUncaughtExceptions)prop;
                    unExProp.initialize(config, environClass, out);
                }
            }
            if (JPF_WITH_TBP_CHECKER) {
                jpf.addListener((JPFListener)pl);
            }
            if (DEBUG) {
                out.println("Complile time settings");
                out.println("  Checker.JPF_WITH_TBP_CHECKER=" + JPF_WITH_TBP_CHECKER);
                out.println("  CodeGenerator ... " + CodeGenerator.getStaticConfiguration());
                out.println("  JPFSearch     ... " + JPFSearch.getStaticConfiguration());
            }
            jpf.run();
            if (!jpf.foundErrors()) continue;
            Error err = (Error)jpf.getSearchErrors().get(0);
            CheckerResult genericErrorReport = CheckerResult.creaResultErrorMessage("Properties violated. Check output to see more details.");
            if (err == null) {
                return genericErrorReport;
            }
            Property prop = err.getProperty();
            if (prop != null && prop instanceof PropertyUncaughtExceptions) {
                PropertyUncaughtExceptions propUE = (PropertyUncaughtExceptions)prop;
                return CheckerResult.createResultCounterExample("Component throws uncaught exception.\n", propUE.getStackTrace());
            }
            Path path = err.getPath();
            if (path == null) {
                return genericErrorReport;
            }
            Instruction lastInsn = Checker.getLastInstructionInPath(path, config);
            if (lastInsn == null) {
                return genericErrorReport;
            }
            MethodInfo mi = lastInsn.getMethodInfo();
            if (mi == null) {
                return genericErrorReport;
            }
            ClassInfo ci = mi.getClassInfo();
            if (ci == null) {
                return genericErrorReport;
            }
            StackTraceElement[] steArray = new StackTraceElement[]{new StackTraceElement(ci.getName(), mi.getName(), ci.getSourceFileName(), mi.getLineNumber(lastInsn))};
            return CheckerResult.createResultCounterExample("Counter example found.", steArray);
        }
        return CheckerResult.createResultNoError();
    }

    public static CheckerResult runFromEclipse(String componentName, String componentImpl, Map<String, String> provItfs, Map<String, String> reqItfs, File protocolFile, String valueSetsClassName, File tmpDir, Collection<File> pathsToJPFModelClasses, OutputStream out) {
        PrintStream pOut = new PrintStream(out);
        LinkedList<String> parameters = new LinkedList<String>();
        parameters.add("component.name=" + CodeGenerator.patchName(componentName));
        parameters.add("component.implclass=" + componentImpl);
        StringBuffer strBuf1 = new StringBuffer();
        boolean first1 = true;
        for (Map.Entry<String, String> me : provItfs.entrySet()) {
            if (first1) {
                first1 = false;
            } else {
                strBuf1.append(";");
            }
            strBuf1.append(me.getKey());
            strBuf1.append("-");
            strBuf1.append(me.getValue());
        }
        parameters.add("component.provitfs=" + strBuf1.toString());
        StringBuffer strBuf2 = new StringBuffer();
        boolean first2 = true;
        for (Map.Entry<String, String> me : reqItfs.entrySet()) {
            if (first2) {
                first2 = false;
            } else {
                strBuf2.append(";");
            }
            strBuf2.append(me.getKey());
            strBuf2.append("-");
            strBuf2.append(me.getValue());
        }
        parameters.add("component.reqitfs=" + strBuf2.toString());
        parameters.add("env.protocol=" + protocolFile.getAbsolutePath());
        parameters.add("env.targetdir=" + tmpDir.getAbsolutePath());
        parameters.add("env.valuesets=" + valueSetsClassName);
        parameters.add("env.reqitfs_setmethod=fields");
        Configuration config = new Configuration(parameters.toArray(new String[0]), null, pOut);
        if (config.isConfigurationError()) {
            pOut.println("ERROR - Configuration contais errors.");
            return null;
        }
        StringBuffer strBuf3 = new StringBuffer();
        boolean first3 = true;
        for (File f : pathsToJPFModelClasses) {
            if (first3) {
                first3 = false;
            } else {
                strBuf3.append(",");
            }
            strBuf3.append(f.getAbsolutePath());
        }
        String classpathForJPFModelClasses = strBuf3.toString();
        return Checker.runTool(config, classpathForJPFModelClasses, pOut);
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Invalid argments number");
            System.out.println("Checker usage");
            System.out.println("  Checker configurationFile classpathForJpfModelClasses Optional-ParametersOverwriteingConfigurationFileDefaules");
            return;
        }
        String configurationFile = args[0];
        String classpathForJpfModelClasses = args[1];
        String[] overwritingsParameters = new String[args.length - 2];
        for (int i = 2; i < args.length; ++i) {
            overwritingsParameters[i - 2] = args[i];
        }
        Configuration config = new Configuration(overwritingsParameters, configurationFile, System.out);
        if (config.isConfigurationError()) {
            System.out.println("Configuration contais errors.");
            return;
        }
        Checker.runTool(config, classpathForJpfModelClasses, System.out);
    }

    private static boolean updateClassPath(Configuration config, PrintStream out) {
        String classPath = System.getProperty("java.class.path");
        classPath = classPath + File.pathSeparator + config.getEnvTargetDir();
        if (DEBUG) {
            out.println("java.class.path=" + classPath);
        }
        System.setProperty("java.class.path", classPath);
        ClassloaderDir cl = new ClassloaderDir(config.getEnvTargetDir(), Thread.currentThread().getContextClassLoader());
        Thread.currentThread().setContextClassLoader(cl);
        return true;
    }

    private static void DEBUG_generateDOTFilesForAutomatons(LTSAComponentSpecification LTSACompSpec, EventTable et, Configuration config, String fileNamePrefix) {
        Map reactions = LTSACompSpec.getReactions();
        if (DEBUG) {
            System.out.println("Should be generated " + reactions.size() + " reaction .dot files");
        }
        for (Map.Entry entry : reactions.entrySet()) {
            Binding binding = (Binding)entry.getKey();
            LTSAAutomaton automaton = (LTSAAutomaton)entry.getValue();
            try {
                AutomatonToDot.toDot(automaton, new FileOutputStream(config.getEnvTargetDir() + fileNamePrefix + "reaction-" + binding.getFullname() + ".dot"));
            }
            catch (FileNotFoundException e) {
                System.out.println("WARNING - Generating .dot file for automaton " + binding.getFullname() + " failed.");
            }
        }
        Map threads = LTSACompSpec.getThreads();
        if (DEBUG) {
            System.out.println("Should be generated " + threads.size() + " threads .dot files");
        }
        for (Map.Entry entry : threads.entrySet()) {
            String name = (String)entry.getKey();
            LTSAAutomaton automaton = (LTSAAutomaton)entry.getValue();
            try {
                AutomatonToDot.toDot(automaton, new FileOutputStream(config.getEnvTargetDir() + fileNamePrefix + "thread-" + name + ".dot"));
            }
            catch (FileNotFoundException e) {
                System.out.println("WARNING - Generating .dot file for automaton " + name + " failed.");
            }
        }
        Map provision = LTSACompSpec.getProvisions();
        if (DEBUG) {
            System.out.println("Should be generated " + provision.size() + " provisions .dot files");
        }
        for (Map.Entry provisionEntry : provision.entrySet()) {
            try {
                AutomatonToDot.toDot((Automaton)provisionEntry.getValue(), et, new FileOutputStream(config.getEnvTargetDir() + "provision-" + (String)provisionEntry.getKey() + ".dot"));
            }
            catch (FileNotFoundException e) {
                System.out.println("WARNING - Generating .dot file for automaton " + (String)provisionEntry.getKey() + " failed.");
            }
        }
    }

    public static String converClassPathIntoJPFpath(String classPath) {
        if (classPath == null) {
            return ".";
        }
        String result = classPath.replaceAll(File.separator + File.pathSeparator, ",");
        if ((result = result.replaceAll(File.pathSeparator, ",")).endsWith(File.separator)) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public static Instruction getLastInstructionInPath(Path path, Configuration config) {
        Instruction result = null;
        for (int i = path.size() - 1; i > 0 && result == null; --i) {
            Transition tr = path.get(i);
            if (tr == null) continue;
            for (int j = tr.getStepCount() - 1; j > 0 && result == null; --j) {
                ClassInfo ci;
                MethodInfo mi;
                Instruction inst;
                Step st = tr.getStep(j);
                if (st == null || (inst = st.getInstruction()) == null || (mi = inst.getMethodInfo()) == null || (ci = mi.getClassInfo()) == null || !config.getComponentImplementationClasses().contains(ci.getName())) continue;
                result = inst;
            }
        }
        return result;
    }
}

