/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.oid;

import org.neodatis.odb.DatabaseId;
import org.neodatis.odb.ExternalOID;
import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.OID;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.impl.core.oid.DatabaseIdImpl;
import org.neodatis.odb.impl.core.oid.OdbClassOID;
import org.neodatis.tool.wrappers.OdbString;

public class ExternalClassOID
extends OdbClassOID
implements ExternalOID {
    private DatabaseId databaseId;

    public ExternalClassOID(OID oid, DatabaseId databaseId) {
        super(oid.getObjectId());
        this.databaseId = databaseId;
    }

    public DatabaseId getDatabaseId() {
        return this.databaseId;
    }

    public String oidToString() {
        StringBuffer buffer = new StringBuffer("ext-class-oid").append(":");
        buffer.append(this.databaseId.toString()).append(":").append(this.oid);
        return buffer.toString();
    }

    public static ExternalClassOID oidFromString(String oidString) {
        String[] tokens = OdbString.split(oidString, ":");
        if (tokens.length != 3 || !tokens[0].equals("ext-class-oid")) {
            throw new ODBRuntimeException(NeoDatisError.INVALID_OID_REPRESENTATION.addParameter(oidString));
        }
        long oid = Long.parseLong(tokens[2]);
        String databaseid = tokens[1];
        return new ExternalClassOID(new OdbClassOID(oid), DatabaseIdImpl.fromString(databaseid));
    }

    public int getType() {
        return 4;
    }
}

