/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.layers.layer3.engine;

import java.util.Map;
import org.neodatis.odb.OdbConfiguration;
import org.neodatis.tool.wrappers.OdbThread;
import org.neodatis.tool.wrappers.map.OdbHashMap;

public class FileMutex {
    private static FileMutex instance = new FileMutex();
    private Map<String, String> openFiles = new OdbHashMap<String, String>();

    private FileMutex() {
    }

    public static synchronized FileMutex getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseFile(String fileName) {
        Map<String, String> map = this.openFiles;
        synchronized (map) {
            this.openFiles.remove(fileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockFile(String fileName) {
        Map<String, String> map = this.openFiles;
        synchronized (map) {
            this.openFiles.put(fileName, fileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canOpenFile(String fileName) {
        Map<String, String> map = this.openFiles;
        synchronized (map) {
            boolean canOpen;
            boolean bl = canOpen = this.openFiles.get(fileName) == null;
            if (canOpen) {
                this.lockFile(fileName);
            }
            return canOpen;
        }
    }

    public boolean openFile(String fileName) {
        boolean canOpenfile = this.canOpenFile(fileName);
        if (!canOpenfile) {
            if (OdbConfiguration.retryIfFileIsLocked()) {
                int nbRetry;
                for (nbRetry = 0; !this.canOpenFile(fileName) && nbRetry < OdbConfiguration.getNumberOfRetryToOpenFile(); ++nbRetry) {
                    try {
                        OdbThread.sleep(OdbConfiguration.getRetryTimeout());
                        continue;
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                if (nbRetry < OdbConfiguration.getNumberOfRetryToOpenFile()) {
                    return true;
                }
            }
            return false;
        }
        return true;
    }
}

