/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.layers.layer2.instance;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.OdbConfiguration;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer2.instance.IClassPool;
import org.neodatis.tool.wrappers.map.OdbHashMap;

public class ODBClassPool
implements IClassPool {
    private static Map<String, Class> classMap;
    private static Map<String, Constructor> construtorsMap;
    private static Map<String, Class> nativeClasses;

    public void reset() {
        classMap.clear();
        construtorsMap.clear();
    }

    public synchronized Class getClass(String className) {
        Class clazz = classMap.get(className);
        if (clazz == null) {
            block3: {
                try {
                    clazz = OdbConfiguration.getClassLoader().loadClass(className);
                }
                catch (Exception e) {
                    clazz = nativeClasses.get(className);
                    if (clazz != null) break block3;
                    throw new ODBRuntimeException(NeoDatisError.CLASS_POOL_CREATE_CLASS.addParameter(className), (Throwable)e);
                }
            }
            classMap.put(className, clazz);
        }
        return clazz;
    }

    public Constructor getConstructor(String className) {
        return construtorsMap.get(className);
    }

    public void addConstructor(String className, Constructor constructor) {
        construtorsMap.put(className, constructor);
    }

    static {
        Class[] classes;
        classMap = new OdbHashMap<String, Class>();
        construtorsMap = new OdbHashMap<String, Constructor>();
        nativeClasses = new HashMap<String, Class>();
        for (Class clazz : classes = new Class[]{Void.TYPE, Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Float.TYPE, Double.TYPE, Long.TYPE}) {
            nativeClasses.put(clazz.getName(), clazz);
        }
    }
}

