/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.layers.layer1.introspector;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.neodatis.btree.IBTree;
import org.neodatis.btree.IBTreeNode;
import org.neodatis.btree.IBTreeNodeOneValuePerKey;
import org.neodatis.btree.IKeyAndValue;
import org.neodatis.btree.impl.KeyAndValue;
import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.OID;
import org.neodatis.odb.OdbConfiguration;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer1.introspector.IClassIntrospector;
import org.neodatis.odb.core.layers.layer2.instance.FullInstantiationHelper;
import org.neodatis.odb.core.layers.layer2.instance.IClassPool;
import org.neodatis.odb.core.layers.layer2.instance.InstantiationHelper;
import org.neodatis.odb.core.layers.layer2.instance.ParameterHelper;
import org.neodatis.odb.core.layers.layer2.meta.ClassAttributeInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfoIndex;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfoList;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ODBType;
import org.neodatis.odb.core.query.SimpleCompareKey;
import org.neodatis.odb.impl.core.btree.ODBBTreeMultiple;
import org.neodatis.odb.impl.core.btree.ODBBTreeNodeMultiple;
import org.neodatis.odb.impl.core.btree.ODBBTreeNodeSingle;
import org.neodatis.odb.impl.core.btree.ODBBTreeSingle;
import org.neodatis.odb.impl.core.oid.OdbClassOID;
import org.neodatis.odb.impl.core.oid.OdbObjectOID;
import org.neodatis.tool.DLogger;
import org.neodatis.tool.DisplayUtility;
import org.neodatis.tool.wrappers.OdbClassUtil;
import org.neodatis.tool.wrappers.list.IOdbList;
import org.neodatis.tool.wrappers.list.OdbArrayList;
import org.neodatis.tool.wrappers.map.OdbHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractClassIntrospector
implements IClassIntrospector {
    private static final String LOG_ID = "ClassIntrospector";
    private static Map<String, IOdbList<Field>> fields = new OdbHashMap<String, IOdbList<Field>>();
    private static Map<String, Field> directFieldByClassAndFieldName = new OdbHashMap<String, Field>();
    private static Map<String, Class> systemClasses = new OdbHashMap<String, Class>();
    private static Map<String, FullInstantiationHelper> fullInstantiationHelpers = new OdbHashMap<String, FullInstantiationHelper>();
    private static Map<String, InstantiationHelper> instantiationHelpers = new OdbHashMap<String, InstantiationHelper>();
    private static Map<String, ParameterHelper> parameterHelpers = new OdbHashMap<String, ParameterHelper>();
    private static Map<String, Map<String, Boolean>> attributeBehavior = new OdbHashMap<String, Map<String, Boolean>>();
    private IClassPool classPool;

    @Override
    public void reset() {
        fields.clear();
        directFieldByClassAndFieldName.clear();
        fullInstantiationHelpers.clear();
        instantiationHelpers.clear();
        parameterHelpers.clear();
    }

    @Override
    public void init2() {
        this.classPool = OdbConfiguration.getCoreProvider().getClassPool();
    }

    @Override
    public void addInstanciationHelper(Class clazz, InstantiationHelper helper) {
        this.addInstantiationHelper(clazz.getName(), helper);
    }

    @Override
    public void addParameterHelper(Class clazz, ParameterHelper helper) {
        this.addParameterHelper(clazz.getName(), helper);
    }

    @Override
    public void addFullInstanciationHelper(Class clazz, FullInstantiationHelper helper) {
        this.addFullInstantiationHelper(clazz.getName(), helper);
    }

    @Override
    public void addInstantiationHelper(String clazz, InstantiationHelper helper) {
        instantiationHelpers.put(clazz, helper);
    }

    @Override
    public void addParameterHelper(String clazz, ParameterHelper helper) {
        parameterHelpers.put(clazz, helper);
    }

    @Override
    public void addFullInstantiationHelper(String clazz, FullInstantiationHelper helper) {
        fullInstantiationHelpers.put(clazz, helper);
    }

    @Override
    public void removeInstantiationHelper(Class clazz) {
        this.removeInstantiationHelper(clazz.getName());
    }

    @Override
    public void removeInstantiationHelper(String canonicalName) {
        instantiationHelpers.remove(canonicalName);
    }

    @Override
    public void removeParameterHelper(Class clazz) {
        this.removeParameterHelper(clazz.getName());
    }

    @Override
    public void removeParameterHelper(String canonicalName) {
        parameterHelpers.remove(canonicalName);
    }

    @Override
    public void removeFullInstantiationHelper(Class clazz) {
        this.removeFullInstantiationHelper(clazz.getName());
    }

    @Override
    public void removeFullInstantiationHelper(String canonicalName) {
        fullInstantiationHelpers.remove(canonicalName);
    }

    @Override
    public ClassInfoList introspect(Class clazz, boolean recursive) {
        return this.internalIntrospect(clazz, recursive, null);
    }

    @Override
    public Map<String, ClassInfo> instrospect(IOdbList<ClassInfo> classInfos) {
        ClassInfo persistedCI2 = null;
        ClassInfo currentCI = null;
        OdbHashMap<String, ClassInfo> cis = new OdbHashMap<String, ClassInfo>();
        for (ClassInfo persistedCI2 : classInfos) {
            currentCI = this.getClassInfo(persistedCI2.getFullClassName(), persistedCI2);
            cis.put(currentCI.getFullClassName(), currentCI);
        }
        return cis;
    }

    private ClassInfoList internalIntrospect(Class clazz, boolean recursive, ClassInfoList classInfoList) {
        ClassInfo existingCi;
        if (classInfoList != null && (existingCi = classInfoList.getClassInfoWithName(clazz.getName())) != null) {
            return classInfoList;
        }
        ClassInfo classInfo = new ClassInfo(clazz.getName());
        classInfo.setClassCategory(this.getClassCategory(clazz.getName()));
        if (classInfoList == null) {
            classInfoList = new ClassInfoList(classInfo);
        } else {
            classInfoList.addClassInfo(classInfo);
        }
        IOdbList<Field> fields = this.getAllFields(clazz.getName());
        OdbArrayList<ClassAttributeInfo> attributes = new OdbArrayList<ClassAttributeInfo>(fields.size());
        ClassInfo ci = null;
        for (int i = 0; i < fields.size(); ++i) {
            Field field = fields.get(i);
            if (!ODBType.getFromClass(field.getType()).isNative() || OdbClassUtil.isEnum(field.getType())) {
                if (recursive) {
                    classInfoList = this.internalIntrospect(field.getType(), recursive, classInfoList);
                    ci = classInfoList.getClassInfoWithName(field.getType().getName());
                } else {
                    ci = new ClassInfo(field.getType().getName());
                }
            } else {
                ci = null;
            }
            attributes.add(new ClassAttributeInfo(i + 1, field.getName(), field.getType(), field.getType().getName(), ci));
        }
        classInfo.setAttributes(attributes);
        classInfo.setMaxAttributeId(fields.size());
        return classInfoList;
    }

    @Override
    public ClassInfo getClassInfo(String fullClassName, ClassInfo existingClassInfo) {
        ClassInfo classInfo = new ClassInfo(fullClassName);
        classInfo.setClassCategory(this.getClassCategory(fullClassName));
        IOdbList<Field> fields = this.getAllFields(fullClassName);
        OdbArrayList<ClassAttributeInfo> attributes = new OdbArrayList<ClassAttributeInfo>(fields.size());
        int attributeId = -1;
        int maxAttributeId = existingClassInfo.getMaxAttributeId();
        ClassInfo ci = null;
        for (int i = 0; i < fields.size(); ++i) {
            Field field = fields.get(i);
            attributeId = existingClassInfo.getAttributeId(field.getName());
            if (attributeId == -1) {
                attributeId = ++maxAttributeId;
            }
            ci = !ODBType.getFromClass(field.getType()).isNative() ? new ClassInfo(field.getType().getName()) : null;
            attributes.add(new ClassAttributeInfo(attributeId, field.getName(), field.getType(), field.getType().getName(), ci));
        }
        classInfo.setAttributes(attributes);
        classInfo.setMaxAttributeId(maxAttributeId);
        return classInfo;
    }

    @Override
    public List<Class> getSuperClasses(String fullClassName, boolean includingThis) {
        ArrayList<Class> result = new ArrayList<Class>(10);
        Class clazz = this.classPool.getClass(fullClassName);
        if (clazz.isInterface()) {
            // empty if block
        }
        if (includingThis) {
            result.add(clazz);
        }
        for (Class superClass = clazz.getSuperclass(); superClass != null && superClass != Object.class; superClass = superClass.getSuperclass()) {
            result.add(superClass);
        }
        return result;
    }

    @Override
    public Field getField(Class clazz, String fieldName) {
        String className = clazz.getName();
        String key = new StringBuffer(className).append(".").append(fieldName).toString();
        Field field = directFieldByClassAndFieldName.get(key);
        if (field != null) {
            return field;
        }
        IOdbList<Field> result = fields.get(className);
        for (Field f : result) {
            if (!f.getName().equals(fieldName)) continue;
            directFieldByClassAndFieldName.put(key, f);
            f.setAccessible(true);
            return f;
        }
        throw new ODBRuntimeException(NeoDatisError.REFLECTION_ERROR_WHILE_GETTING_FIELD.addParameter(fieldName).addParameter(clazz.getName()));
    }

    @Override
    public synchronized IOdbList<Field> getAllFields(String fullClassName) {
        IOdbList<Field> result = fields.get(fullClassName);
        if (result != null) {
            return result;
        }
        OdbHashMap<String, String> attributesNames = new OdbHashMap<String, String>();
        result = new OdbArrayList<Field>(50);
        Field[] superClassfields = null;
        List<Class> classes = this.getSuperClasses(fullClassName, true);
        for (int i = 0; i < classes.size(); ++i) {
            Class clazz1 = classes.get(i);
            superClassfields = clazz1.getDeclaredFields();
            for (int j = 0; j < superClassfields.length; ++j) {
                if (attributesNames.get(superClassfields[j].getName()) != null) continue;
                superClassfields[j].setAccessible(true);
                result.add(superClassfields[j]);
                attributesNames.put(superClassfields[j].getName(), superClassfields[j].getName());
            }
        }
        result = this.removeUnnecessaryFields(fullClassName, result);
        fields.put(fullClassName, result);
        attributesNames.clear();
        attributesNames = null;
        return result;
    }

    @Override
    public IOdbList<Field> removeUnnecessaryFields(String className, IOdbList<Field> fields) {
        OdbArrayList<Field> fieldsToRemove = new OdbArrayList<Field>(fields.size());
        Map<String, Boolean> behaviors = null;
        Boolean forceBehavior = null;
        for (int i = 0; i < fields.size(); ++i) {
            Field field = fields.get(i);
            behaviors = attributeBehavior.get(field.getDeclaringClass().getName());
            forceBehavior = behaviors == null ? null : behaviors.get(field.getName());
            if (!(!Modifier.isTransient(field.getModifiers()) && !Modifier.isStatic(field.getModifiers()) || forceBehavior != null && forceBehavior.booleanValue())) {
                fieldsToRemove.add(field);
            }
            if (forceBehavior != null && !forceBehavior.booleanValue()) {
                fieldsToRemove.add(field);
            }
            if (!field.getName().startsWith("this$")) continue;
            fieldsToRemove.add(field);
        }
        fields.removeAll(fieldsToRemove);
        return fields;
    }

    @Override
    public ClassInfoList introspect(String fullClassName, boolean recursive) {
        return this.introspect(this.classPool.getClass(fullClassName), true);
    }

    @Override
    public Constructor getConstructorOf(String fullClassName) {
        Class clazz = this.classPool.getClass(fullClassName);
        try {
            Constructor constructor = clazz.getConstructor(new Class[0]);
            return constructor;
        }
        catch (NoSuchMethodException e) {
            if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
                DLogger.debug(clazz + " does not have default constructor! using a 'with parameter' constructor will null values");
            }
            Constructor<?>[] constructors = clazz.getConstructors();
            int numberOfParameters = 1000;
            int bestConstructorIndex = 0;
            for (int i = 0; i < constructors.length; ++i) {
                if (constructors[i].getParameterTypes().length >= numberOfParameters) continue;
                bestConstructorIndex = i;
            }
            Constructor<?> constructor = constructors[bestConstructorIndex];
            return constructor;
        }
    }

    @Override
    public Object newFullInstanceOf(Class clazz, NonNativeObjectInfo nnoi) {
        Object o;
        String className = clazz.getName();
        FullInstantiationHelper helper = fullInstantiationHelpers.get(className);
        if (helper != null && (o = helper.instantiate(nnoi)) != null) {
            return o;
        }
        return null;
    }

    @Override
    public Object newInstanceOf(Class clazz) {
        Object o;
        String className = clazz.getName();
        InstantiationHelper helper = instantiationHelpers.get(className);
        if (helper != null && (o = helper.instantiate()) != null) {
            return o;
        }
        try {
            Constructor constructor = null;
            constructor = this.classPool.getConstructor(className);
            if (constructor == null) {
                constructor = clazz.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                this.classPool.addConstructor(className, constructor);
            }
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            return this.manageNoDefaultConstructor(clazz);
        }
    }

    private Object manageNoDefaultConstructor(Class clazz) {
        Object[] parameters;
        String className = clazz.getName();
        boolean ok = this.tryToCreateAnEmptyConstructor(clazz);
        if (ok) {
            Constructor createdConstructor = this.classPool.getConstructor(className);
            try {
                return createdConstructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new ODBRuntimeException(NeoDatisError.INSTANCIATION_ERROR.addParameter(className), (Throwable)e);
            }
        }
        if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
            DLogger.debug(clazz + " does not have default constructor! using a 'with parameter' constructor will null values");
        }
        Constructor<?>[] constructors = clazz.getDeclaredConstructors();
        if (clazz.isInterface()) {
            return null;
        }
        if (constructors.length == 0) {
            throw new ODBRuntimeException(NeoDatisError.CLASS_WITHOUT_CONSTRUCTOR.addParameter(clazz.getName()));
        }
        int numberOfParameters = 1000;
        int bestConstructorIndex = 0;
        for (int i = 0; i < constructors.length; ++i) {
            if (constructors[i].getParameterTypes().length >= numberOfParameters) continue;
            bestConstructorIndex = i;
        }
        Constructor<?> constructor = constructors[bestConstructorIndex];
        ParameterHelper paramHelper = parameterHelpers.get(className);
        if (paramHelper != null) {
            parameters = paramHelper.parameters();
            if (parameters.length != constructor.getParameterTypes().length) {
                throw new ODBRuntimeException(NeoDatisError.PARAM_HELPER_WRONG_NO_OF_PARAMS.addParameter(className).addParameter(constructor.toString()));
            }
        } else {
            parameters = new Object[constructor.getParameterTypes().length];
            for (int i = 0; i < parameters.length; ++i) {
                parameters[i] = constructor.getParameterTypes()[i] == Integer.TYPE ? (Number)new Integer(0) : (Number)(constructor.getParameterTypes()[i] == Long.TYPE ? (Number)new Long(0L) : (Number)(constructor.getParameterTypes()[i] == Short.TYPE ? (Number)new Short("0") : (Number)(constructor.getParameterTypes()[i] == Byte.TYPE ? (Number)new Byte("0") : (Number)(constructor.getParameterTypes()[i] == Float.TYPE ? (Number)new Float("0") : (Number)(constructor.getParameterTypes()[i] == Double.TYPE ? new Double("0") : null)))));
            }
        }
        Object object = null;
        constructor.setAccessible(true);
        try {
            object = constructor.newInstance(parameters);
        }
        catch (Throwable e2) {
            throw new ODBRuntimeException(NeoDatisError.NO_NULLABLE_CONSTRUCTOR.addParameter("[" + DisplayUtility.objectArrayToString(constructor.getParameterTypes()) + "]").addParameter(clazz.getName()), e2);
        }
        return object;
    }

    protected abstract boolean tryToCreateAnEmptyConstructor(Class var1);

    @Override
    public boolean isSystemClass(String fullClassName) {
        return systemClasses.containsKey(fullClassName);
    }

    @Override
    public byte getClassCategory(String fullClassName) {
        if (systemClasses.isEmpty()) {
            this.fillSystemClasses();
        }
        if (systemClasses.get(fullClassName) != null) {
            return 1;
        }
        return 2;
    }

    private void fillSystemClasses() {
        systemClasses.put(ClassInfoIndex.class.getName(), ClassInfoIndex.class);
        systemClasses.put(OID.class.getName(), OID.class);
        systemClasses.put(OdbObjectOID.class.getName(), OdbObjectOID.class);
        systemClasses.put(OdbClassOID.class.getName(), OdbClassOID.class);
        systemClasses.put(ODBBTreeNodeSingle.class.getName(), ODBBTreeNodeSingle.class);
        systemClasses.put(ODBBTreeNodeMultiple.class.getName(), ODBBTreeNodeMultiple.class);
        systemClasses.put(ODBBTreeMultiple.class.getName(), ODBBTreeMultiple.class);
        systemClasses.put(ODBBTreeSingle.class.getName(), ODBBTreeSingle.class);
        systemClasses.put(ODBBTreeNodeMultiple.class.getName(), ODBBTreeNodeMultiple.class);
        systemClasses.put(IBTree.class.getName(), IBTree.class);
        systemClasses.put(IBTreeNodeOneValuePerKey.class.getName(), IBTreeNodeOneValuePerKey.class);
        systemClasses.put(IKeyAndValue.class.getName(), IKeyAndValue.class);
        systemClasses.put(KeyAndValue.class.getName(), KeyAndValue.class);
        systemClasses.put(SimpleCompareKey.class.getName(), SimpleCompareKey.class);
        systemClasses.put(Comparable.class.getName(), Comparable.class);
        systemClasses.put(IBTreeNode.class.getName(), IBTreeNode.class);
        systemClasses.put(Object.class.getName(), Object.class);
    }

    protected void addConstructor(String className, Constructor constructor) {
        this.classPool.addConstructor(className, constructor);
    }

    @Override
    public void persistFieldOfClass(String className, String fieldName, boolean yesNo) {
        Map<String, Boolean> fields = attributeBehavior.get(className);
        if (fields == null) {
            fields = new OdbHashMap<String, Boolean>();
            attributeBehavior.put(className, fields);
        }
        fields.put(fieldName, new Boolean(yesNo));
    }
}

