/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reflection.java.generics;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.reflection.java.generics.ApproximatingTypeEnvironment;
import org.hibernate.reflection.java.generics.CompoundTypeEnvironment;
import org.hibernate.reflection.java.generics.IdentityTypeEnvironment;
import org.hibernate.reflection.java.generics.SimpleTypeEnvironment;
import org.hibernate.reflection.java.generics.TypeEnvironment;
import org.hibernate.reflection.java.generics.TypeSwitch;

public class TypeEnvironmentFactory {
    private final Map<Type, TypeEnvironment> typeToEnvironment = new HashMap<Type, TypeEnvironment>();

    public TypeEnvironment getEnvironment(Class context) {
        return this.doGetEnvironment(context);
    }

    public TypeEnvironment getEnvironment(ParameterizedType context) {
        return this.doGetEnvironment(context);
    }

    public TypeEnvironment toApproximatingEnvironment(TypeEnvironment context) {
        return new CompoundTypeEnvironment(new ApproximatingTypeEnvironment(), context);
    }

    private TypeEnvironment doGetEnvironment(Type context) {
        if (context == null) {
            return IdentityTypeEnvironment.INSTANCE;
        }
        TypeEnvironment result = this.typeToEnvironment.get(context);
        if (result == null) {
            result = this.createEnvironment(context);
            this.typeToEnvironment.put(context, result);
        }
        return result;
    }

    private TypeEnvironment createEnvironment(Type context) {
        return (TypeEnvironment)new TypeSwitch<TypeEnvironment>(){

            @Override
            public TypeEnvironment caseClass(Class classType) {
                return new CompoundTypeEnvironment(TypeEnvironmentFactory.this.createSuperTypeEnvironment(classType), TypeEnvironmentFactory.this.getEnvironment(classType.getSuperclass()));
            }

            @Override
            public TypeEnvironment caseParameterizedType(ParameterizedType parameterizedType) {
                return TypeEnvironmentFactory.this.createEnvironment(parameterizedType);
            }

            @Override
            public TypeEnvironment defaultCase(Type t) {
                throw new IllegalArgumentException("Invalid type for generating environment: " + t);
            }
        }.doSwitch(context);
    }

    private TypeEnvironment createSuperTypeEnvironment(Class clazz) {
        Class superclass = clazz.getSuperclass();
        if (superclass == null) {
            return IdentityTypeEnvironment.INSTANCE;
        }
        Type[] formalArgs = superclass.getTypeParameters();
        Type genericSuperclass = clazz.getGenericSuperclass();
        if (genericSuperclass instanceof Class) {
            return IdentityTypeEnvironment.INSTANCE;
        }
        if (genericSuperclass instanceof ParameterizedType) {
            Type[] actualArgs = ((ParameterizedType)genericSuperclass).getActualTypeArguments();
            return new SimpleTypeEnvironment(formalArgs, actualArgs);
        }
        throw new AssertionError((Object)"Should be unreachable");
    }

    private TypeEnvironment createEnvironment(ParameterizedType t) {
        Type[] tactuals = t.getActualTypeArguments();
        Type rawType = t.getRawType();
        if (rawType instanceof Class) {
            Type[] tparms = ((Class)rawType).getTypeParameters();
            return new SimpleTypeEnvironment(tparms, tactuals);
        }
        return IdentityTypeEnvironment.INSTANCE;
    }
}

