/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantFloat;
import org.apache.bcel.classfile.ConstantInteger;
import org.apache.bcel.classfile.ConstantLong;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.ElementValue;
import org.apache.bcel.classfile.SimpleElementValue;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.ElementValueGen;

public class SimpleElementValueGen
extends ElementValueGen {
    private int idx;

    protected SimpleElementValueGen(int n, int n2, ConstantPoolGen constantPoolGen) {
        super(n, constantPoolGen);
        this.idx = n2;
    }

    public SimpleElementValueGen(int n, ConstantPoolGen constantPoolGen, int n2) {
        super(n, constantPoolGen);
        this.idx = constantPoolGen.addInteger(n2);
    }

    public SimpleElementValueGen(int n, ConstantPoolGen constantPoolGen, long l) {
        super(n, constantPoolGen);
        this.idx = constantPoolGen.addLong(l);
    }

    public SimpleElementValueGen(int n, ConstantPoolGen constantPoolGen, double d) {
        super(n, constantPoolGen);
        this.idx = constantPoolGen.addDouble(d);
    }

    public SimpleElementValueGen(int n, ConstantPoolGen constantPoolGen, float f) {
        super(n, constantPoolGen);
        this.idx = constantPoolGen.addFloat(f);
    }

    public SimpleElementValueGen(int n, ConstantPoolGen constantPoolGen, short s) {
        super(n, constantPoolGen);
        this.idx = constantPoolGen.addInteger(s);
    }

    public SimpleElementValueGen(int n, ConstantPoolGen constantPoolGen, byte by) {
        super(n, constantPoolGen);
        this.idx = constantPoolGen.addInteger(by);
    }

    public SimpleElementValueGen(int n, ConstantPoolGen constantPoolGen, char c) {
        super(n, constantPoolGen);
        this.idx = constantPoolGen.addInteger(c);
    }

    public SimpleElementValueGen(int n, ConstantPoolGen constantPoolGen, boolean bl) {
        super(n, constantPoolGen);
        this.idx = bl ? constantPoolGen.addInteger(1) : constantPoolGen.addInteger(0);
    }

    public SimpleElementValueGen(int n, ConstantPoolGen constantPoolGen, String string) {
        super(n, constantPoolGen);
        this.idx = constantPoolGen.addUtf8(string);
    }

    public SimpleElementValueGen(SimpleElementValue simpleElementValue, ConstantPoolGen constantPoolGen, boolean bl) {
        super(simpleElementValue.getElementValueType(), constantPoolGen);
        if (!bl) {
            this.idx = simpleElementValue.getIndex();
        } else {
            switch (simpleElementValue.getElementValueType()) {
                case 115: {
                    this.idx = constantPoolGen.addUtf8(simpleElementValue.getValueString());
                    break;
                }
                case 73: {
                    this.idx = constantPoolGen.addInteger(simpleElementValue.getValueInt());
                    break;
                }
                case 66: {
                    this.idx = constantPoolGen.addInteger(simpleElementValue.getValueByte());
                    break;
                }
                case 67: {
                    this.idx = constantPoolGen.addInteger(simpleElementValue.getValueChar());
                    break;
                }
                case 74: {
                    this.idx = constantPoolGen.addLong(simpleElementValue.getValueLong());
                    break;
                }
                case 70: {
                    this.idx = constantPoolGen.addFloat(simpleElementValue.getValueFloat());
                    break;
                }
                case 68: {
                    this.idx = constantPoolGen.addDouble(simpleElementValue.getValueDouble());
                    break;
                }
                case 90: {
                    if (simpleElementValue.getValueBoolean()) {
                        this.idx = constantPoolGen.addInteger(1);
                        break;
                    }
                    this.idx = constantPoolGen.addInteger(0);
                    break;
                }
                case 83: {
                    this.idx = constantPoolGen.addInteger(simpleElementValue.getValueShort());
                    break;
                }
                default: {
                    throw new RuntimeException("SimpleElementValueGen class does not know how to copy this type " + this.type);
                }
            }
        }
    }

    public ElementValue getElementValue() {
        return new SimpleElementValue(this.type, this.idx, this.cpGen.getConstantPool());
    }

    public int getIndex() {
        return this.idx;
    }

    public String getValueString() {
        if (this.type != 115) {
            throw new RuntimeException("Dont call getValueString() on a non STRING ElementValue");
        }
        ConstantUtf8 constantUtf8 = (ConstantUtf8)this.cpGen.getConstant(this.idx);
        return constantUtf8.getBytes();
    }

    public int getValueInt() {
        if (this.type != 73) {
            throw new RuntimeException("Dont call getValueString() on a non STRING ElementValue");
        }
        ConstantInteger constantInteger = (ConstantInteger)this.cpGen.getConstant(this.idx);
        return constantInteger.getBytes();
    }

    public String stringifyValue() {
        switch (this.type) {
            case 73: {
                ConstantInteger constantInteger = (ConstantInteger)this.cpGen.getConstant(this.idx);
                return Integer.toString(constantInteger.getBytes());
            }
            case 74: {
                ConstantLong constantLong = (ConstantLong)this.cpGen.getConstant(this.idx);
                return Long.toString(constantLong.getBytes());
            }
            case 68: {
                ConstantDouble constantDouble = (ConstantDouble)this.cpGen.getConstant(this.idx);
                return Double.toString(constantDouble.getBytes());
            }
            case 70: {
                ConstantFloat constantFloat = (ConstantFloat)this.cpGen.getConstant(this.idx);
                return Float.toString(constantFloat.getBytes());
            }
            case 83: {
                ConstantInteger constantInteger = (ConstantInteger)this.cpGen.getConstant(this.idx);
                return Integer.toString(constantInteger.getBytes());
            }
            case 66: {
                ConstantInteger constantInteger = (ConstantInteger)this.cpGen.getConstant(this.idx);
                return Integer.toString(constantInteger.getBytes());
            }
            case 67: {
                ConstantInteger constantInteger = (ConstantInteger)this.cpGen.getConstant(this.idx);
                return Integer.toString(constantInteger.getBytes());
            }
            case 90: {
                ConstantInteger constantInteger = (ConstantInteger)this.cpGen.getConstant(this.idx);
                if (constantInteger.getBytes() == 0) {
                    return "false";
                }
                if (constantInteger.getBytes() != 0) {
                    return "true";
                }
            }
            case 115: {
                ConstantUtf8 constantUtf8 = (ConstantUtf8)this.cpGen.getConstant(this.idx);
                return constantUtf8.getBytes();
            }
        }
        throw new RuntimeException("SimpleElementValueGen class does not know how to stringify type " + this.type);
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.type);
        switch (this.type) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                dataOutputStream.writeShort(this.idx);
                break;
            }
            default: {
                throw new RuntimeException("SimpleElementValueGen doesnt know how to write out type " + this.type);
            }
        }
    }
}

