/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.ElementValue;
import org.apache.bcel.classfile.ElementValuePair;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.ElementValueGen;

public class ElementValuePairGen {
    private int nameIdx;
    private ElementValueGen value;
    private ConstantPoolGen cpool;

    public ElementValuePairGen(ElementValuePair elementValuePair, ConstantPoolGen constantPoolGen, boolean bl) {
        this.cpool = constantPoolGen;
        this.nameIdx = bl ? constantPoolGen.addUtf8(elementValuePair.getNameString()) : elementValuePair.getNameIndex();
        this.value = ElementValueGen.copy(elementValuePair.getValue(), constantPoolGen, bl);
    }

    public ElementValuePair getElementNameValuePair() {
        ElementValue elementValue = this.value.getElementValue();
        return new ElementValuePair(this.nameIdx, elementValue, this.cpool.getConstantPool());
    }

    protected ElementValuePairGen(int n, ElementValueGen elementValueGen, ConstantPoolGen constantPoolGen) {
        this.nameIdx = n;
        this.value = elementValueGen;
        this.cpool = constantPoolGen;
    }

    public ElementValuePairGen(String string, ElementValueGen elementValueGen, ConstantPoolGen constantPoolGen) {
        this.nameIdx = constantPoolGen.addUtf8(string);
        this.value = elementValueGen;
        this.cpool = constantPoolGen;
    }

    protected void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.nameIdx);
        this.value.dump(dataOutputStream);
    }

    public int getNameIndex() {
        return this.nameIdx;
    }

    public final String getNameString() {
        return ((ConstantUtf8)this.cpool.getConstant(this.nameIdx)).getBytes();
    }

    public final ElementValueGen getValue() {
        return this.value;
    }

    public String toString() {
        return "ElementValuePair:[" + this.getNameString() + "=" + this.value.stringifyValue() + "]";
    }
}

