/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ElementValue;

public class ArrayElementValue
extends ElementValue {
    private ElementValue[] evalues;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        for (int i = 0; i < this.evalues.length; ++i) {
            stringBuffer.append(this.evalues[i].toString());
            if (i + 1 >= this.evalues.length) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public ArrayElementValue(int n, ElementValue[] elementValueArray, ConstantPool constantPool) {
        super(n, constantPool);
        if (n != 91) {
            throw new RuntimeException("Only element values of type array can be built with this ctor");
        }
        this.evalues = elementValueArray;
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.type);
        dataOutputStream.writeShort(this.evalues.length);
        for (int i = 0; i < this.evalues.length; ++i) {
            this.evalues[i].dump(dataOutputStream);
        }
    }

    public String stringifyValue() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (int i = 0; i < this.evalues.length; ++i) {
            stringBuffer.append(this.evalues[i].stringifyValue());
            if (i + 1 >= this.evalues.length) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public ElementValue[] getElementValuesArray() {
        return this.evalues;
    }

    public int getElementValuesArraySize() {
        return this.evalues.length;
    }
}

