/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.rmi;

import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jndi.JndiTemplate;
import org.springframework.remoting.rmi.RmiBasedExporter;

public class JndiRmiServiceExporter
extends RmiBasedExporter
implements InitializingBean,
DisposableBean {
    private JndiTemplate jndiTemplate = new JndiTemplate();
    private String jndiName;
    private Remote exportedObject;

    public void setJndiTemplate(JndiTemplate jndiTemplate) {
        this.jndiTemplate = jndiTemplate != null ? jndiTemplate : new JndiTemplate();
    }

    public void setJndiEnvironment(Properties jndiEnvironment) {
        this.jndiTemplate = new JndiTemplate(jndiEnvironment);
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public void afterPropertiesSet() throws NamingException, RemoteException {
        this.prepare();
    }

    public void prepare() throws NamingException, RemoteException {
        if (this.jndiName == null) {
            throw new IllegalArgumentException("jndiName is required");
        }
        this.exportedObject = this.getObjectToExport();
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Binding RMI service to JNDI location [" + this.jndiName + "]"));
        }
        PortableRemoteObject.exportObject((Remote)this.exportedObject);
        this.jndiTemplate.rebind(this.jndiName, this.exportedObject);
    }

    public void destroy() throws NamingException, NoSuchObjectException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Unbinding RMI service from JNDI location [" + this.jndiName + "]"));
        }
        this.jndiTemplate.unbind(this.jndiName);
        PortableRemoteObject.unexportObject((Remote)this.exportedObject);
    }
}

