/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.xml;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.xml.BeansDtdResolver;
import org.springframework.beans.factory.xml.PluggableSchemaResolver;
import org.springframework.util.Assert;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DelegatingEntityResolver
implements EntityResolver {
    public static final String DTD_SUFFIX = ".dtd";
    public static final String XSD_SUFFIX = ".xsd";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final EntityResolver dtdResolver;
    private final EntityResolver schemaResolver;

    public DelegatingEntityResolver(ClassLoader classLoader) {
        this.dtdResolver = new BeansDtdResolver();
        this.schemaResolver = new PluggableSchemaResolver(classLoader);
    }

    public DelegatingEntityResolver(EntityResolver dtdResolver, EntityResolver schemaResolver) {
        Assert.notNull(dtdResolver);
        Assert.notNull(schemaResolver);
        this.dtdResolver = dtdResolver;
        this.schemaResolver = schemaResolver;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        if (systemId != null) {
            if (systemId.endsWith(DTD_SUFFIX)) {
                return this.resolveEntity(publicId, systemId, this.dtdResolver, "DTD");
            }
            if (systemId.endsWith(XSD_SUFFIX)) {
                return this.resolveEntity(publicId, systemId, this.schemaResolver, "XML Schema");
            }
        }
        return null;
    }

    private InputSource resolveEntity(String publicId, String systemId, EntityResolver resolver, String type) throws SAXException, IOException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Attempting to resolve " + type + " [" + systemId + "] using [" + resolver.getClass().getName() + "]"));
        }
        return resolver.resolveEntity(publicId, systemId);
    }
}

