/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.net.URI;
import javax.jms.Destination;
import javax.jms.MessageConsumer;
import org.apache.activemq.JmsMultipleBrokersTestSupport;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.util.MessageIdList;

public class ThreeBrokerQueueNetworkTest
extends JmsMultipleBrokersTestSupport {
    protected static final int MESSAGE_COUNT = 100;

    public void test_AB_BC_BrokerNetwork() throws Exception {
        this.bridgeBrokers("BrokerA", "BrokerB");
        this.bridgeBrokers("BrokerB", "BrokerC");
        this.startAllBrokers();
        ActiveMQDestination dest = this.createDestination("TEST.FOO", false);
        MessageConsumer clientC = this.createConsumer("BrokerC", (Destination)dest);
        this.sendMessages("BrokerA", (Destination)dest, 100);
        Thread.sleep(1000L);
        MessageIdList msgsC = this.getConsumerMessages("BrokerC", clientC);
        ThreeBrokerQueueNetworkTest.assertEquals((int)0, (int)msgsC.getMessageCount());
    }

    public void test_BA_BC_BrokerNetwork() throws Exception {
        this.bridgeBrokers("BrokerB", "BrokerA");
        this.bridgeBrokers("BrokerB", "BrokerC");
        this.startAllBrokers();
        ActiveMQDestination dest = this.createDestination("TEST.FOO", false);
        MessageConsumer clientA = this.createConsumer("BrokerA", (Destination)dest);
        MessageConsumer clientC = this.createConsumer("BrokerC", (Destination)dest);
        Thread.sleep(2000L);
        this.sendMessages("BrokerB", (Destination)dest, 100);
        Thread.sleep(1000L);
        MessageIdList msgsA = this.getConsumerMessages("BrokerA", clientA);
        MessageIdList msgsC = this.getConsumerMessages("BrokerC", clientC);
        ThreeBrokerQueueNetworkTest.assertEquals((int)100, (int)(msgsA.getMessageCount() + msgsC.getMessageCount()));
    }

    public void test_AB_CB_BrokerNetwork() throws Exception {
        this.bridgeBrokers("BrokerA", "BrokerB");
        this.bridgeBrokers("BrokerC", "BrokerB");
        this.startAllBrokers();
        ActiveMQDestination dest = this.createDestination("TEST.FOO", false);
        MessageConsumer clientB = this.createConsumer("BrokerB", (Destination)dest);
        this.sendMessages("BrokerA", (Destination)dest, 100);
        this.sendMessages("BrokerC", (Destination)dest, 100);
        MessageIdList msgsB = this.getConsumerMessages("BrokerB", clientB);
        msgsB.waitForMessagesToArrive(200);
        ThreeBrokerQueueNetworkTest.assertEquals((int)200, (int)msgsB.getMessageCount());
    }

    public void testAllConnectedBrokerNetwork() throws Exception {
        this.bridgeBrokers("BrokerA", "BrokerB");
        this.bridgeBrokers("BrokerB", "BrokerA");
        this.bridgeBrokers("BrokerB", "BrokerC");
        this.bridgeBrokers("BrokerC", "BrokerB");
        this.bridgeBrokers("BrokerA", "BrokerC");
        this.bridgeBrokers("BrokerC", "BrokerA");
        this.startAllBrokers();
        ActiveMQDestination dest = this.createDestination("TEST.FOO", false);
        MessageConsumer clientA = this.createConsumer("BrokerA", (Destination)dest);
        MessageConsumer clientB = this.createConsumer("BrokerB", (Destination)dest);
        MessageConsumer clientC = this.createConsumer("BrokerC", (Destination)dest);
        this.sendMessages("BrokerA", (Destination)dest, 100);
        this.sendMessages("BrokerB", (Destination)dest, 100);
        this.sendMessages("BrokerC", (Destination)dest, 100);
        Thread.sleep(1000L);
        MessageIdList msgsA = this.getConsumerMessages("BrokerA", clientA);
        MessageIdList msgsB = this.getConsumerMessages("BrokerB", clientB);
        MessageIdList msgsC = this.getConsumerMessages("BrokerC", clientC);
        ThreeBrokerQueueNetworkTest.assertEquals((int)300, (int)(msgsA.getMessageCount() + msgsB.getMessageCount() + msgsC.getMessageCount()));
    }

    public void testAllConnectedUsingMulticast() throws Exception {
        this.bridgeAllBrokers();
        this.startAllBrokers();
        ActiveMQDestination dest = this.createDestination("TEST.FOO", false);
        MessageConsumer clientA = this.createConsumer("BrokerA", (Destination)dest);
        MessageConsumer clientB = this.createConsumer("BrokerB", (Destination)dest);
        MessageConsumer clientC = this.createConsumer("BrokerC", (Destination)dest);
        this.sendMessages("BrokerA", (Destination)dest, 100);
        this.sendMessages("BrokerB", (Destination)dest, 100);
        this.sendMessages("BrokerC", (Destination)dest, 100);
        Thread.sleep(1000L);
        MessageIdList msgsA = this.getConsumerMessages("BrokerA", clientA);
        MessageIdList msgsB = this.getConsumerMessages("BrokerB", clientB);
        MessageIdList msgsC = this.getConsumerMessages("BrokerC", clientC);
        ThreeBrokerQueueNetworkTest.assertEquals((int)300, (int)(msgsA.getMessageCount() + msgsB.getMessageCount() + msgsC.getMessageCount()));
    }

    public void setUp() throws Exception {
        super.setAutoFail(true);
        super.setUp();
        this.createBroker(new URI("broker:(tcp://localhost:61616)/BrokerA?persistent=false&useJmx=false"));
        this.createBroker(new URI("broker:(tcp://localhost:61617)/BrokerB?persistent=false&useJmx=false"));
        this.createBroker(new URI("broker:(tcp://localhost:61618)/BrokerC?persistent=false&useJmx=false"));
    }
}

