/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.tcp;

import java.io.IOException;
import java.net.URI;
import javax.net.ssl.SSLServerSocketFactory;
import junit.framework.TestCase;
import org.apache.activemq.transport.tcp.SslTransportServer;
import org.apache.activemq.transport.tcp.StubSSLServerSocket;
import org.apache.activemq.transport.tcp.StubSSLSocketFactory;

public class SslTransportServerTest
extends TestCase {
    private SslTransportServer sslTransportServer = null;
    private StubSSLServerSocket sslServerSocket = null;

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    private void createAndBindTransportServer(boolean wantClientAuth, boolean needClientAuth, String options) throws IOException {
        this.sslServerSocket = new StubSSLServerSocket();
        StubSSLSocketFactory socketFactory = new StubSSLSocketFactory(this.sslServerSocket);
        try {
            this.sslTransportServer = new SslTransportServer(null, new URI("ssl://localhost:61616?" + options), (SSLServerSocketFactory)socketFactory);
        }
        catch (Exception e) {
            SslTransportServerTest.fail((String)"Unable to create SslTransportServer.");
        }
        this.sslTransportServer.setWantClientAuth(wantClientAuth);
        this.sslTransportServer.setNeedClientAuth(needClientAuth);
        this.sslTransportServer.bind();
    }

    public void testWantAndNeedClientAuthSetters() throws IOException {
        for (int i = 0; i < 4; ++i) {
            boolean wantClientAuth = (i & 1) == 1;
            boolean needClientAuth = (i & 2) == 1;
            int expectedWantStatus = wantClientAuth ? 1 : 0;
            int expectedNeedStatus = needClientAuth ? 1 : 0;
            this.createAndBindTransportServer(wantClientAuth, needClientAuth, "");
            SslTransportServerTest.assertEquals((String)"Created ServerSocket did not have correct wantClientAuth status.", (int)this.sslServerSocket.getWantClientAuthStatus(), (int)expectedWantStatus);
            SslTransportServerTest.assertEquals((String)"Created ServerSocket did not have correct needClientAuth status.", (int)this.sslServerSocket.getNeedClientAuthStatus(), (int)expectedNeedStatus);
        }
    }

    public void testWantAndNeedAuthReflection() throws IOException {
        for (int i = 0; i < 4; ++i) {
            boolean wantClientAuth = (i & 1) == 1;
            boolean needClientAuth = (i & 2) == 1;
            int expectedWantStatus = wantClientAuth ? 1 : 0;
            int expectedNeedStatus = needClientAuth ? 1 : 0;
            String options = "wantClientAuth=" + (wantClientAuth ? "true" : "false") + "&needClientAuth=" + (needClientAuth ? "true" : "false");
            this.createAndBindTransportServer(wantClientAuth, needClientAuth, options);
            SslTransportServerTest.assertEquals((String)"Created ServerSocket did not have correct wantClientAuth status.", (int)this.sslServerSocket.getWantClientAuthStatus(), (int)expectedWantStatus);
            SslTransportServerTest.assertEquals((String)"Created ServerSocket did not have correct needClientAuth status.", (int)this.sslServerSocket.getNeedClientAuthStatus(), (int)expectedNeedStatus);
        }
    }
}

