/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.discovery;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.activemq.broker.StubConnection;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.SessionInfo;
import org.apache.activemq.network.NetworkTestSupport;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFactory;
import org.apache.activemq.transport.failover.FailoverTransport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DiscoveryTransportBrokerTest
extends NetworkTestSupport {
    private static final Log log = LogFactory.getLog((Class)DiscoveryTransportBrokerTest.class);

    public void setUp() throws Exception {
        super.setAutoFail(true);
        super.setUp();
    }

    public void testPublisherFailsOver() throws Exception {
        TransportConnector serverA;
        StubConnection connectionB;
        StubConnection connectionA;
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        int deliveryMode = 1;
        StubConnection connection1 = this.createConnection();
        ConnectionInfo connectionInfo1 = this.createConnectionInfo();
        SessionInfo sessionInfo1 = this.createSessionInfo(connectionInfo1);
        ConsumerInfo consumerInfo1 = this.createConsumerInfo(sessionInfo1, (ActiveMQDestination)destination);
        connection1.send((Command)connectionInfo1);
        connection1.send((Command)sessionInfo1);
        connection1.request((Command)consumerInfo1);
        StubConnection connection2 = this.createRemoteConnection();
        ConnectionInfo connectionInfo2 = this.createConnectionInfo();
        SessionInfo sessionInfo2 = this.createSessionInfo(connectionInfo2);
        ConsumerInfo consumerInfo2 = this.createConsumerInfo(sessionInfo2, (ActiveMQDestination)destination);
        connection2.send((Command)connectionInfo2);
        connection2.send((Command)sessionInfo2);
        connection2.request((Command)consumerInfo2);
        StubConnection connection3 = this.createFailoverConnection();
        ConnectionInfo connectionInfo3 = this.createConnectionInfo();
        SessionInfo sessionInfo3 = this.createSessionInfo(connectionInfo3);
        ProducerInfo producerInfo3 = this.createProducerInfo(sessionInfo3);
        connection3.send((Command)connectionInfo3);
        connection3.send((Command)sessionInfo3);
        connection3.send((Command)producerInfo3);
        connection3.request((Command)this.createMessage(producerInfo3, (ActiveMQDestination)destination, deliveryMode));
        FailoverTransport ft = (FailoverTransport)connection3.getTransport().narrow(FailoverTransport.class);
        if (this.connector.getServer().getConnectURI().equals(ft.getConnectedTransportURI())) {
            connectionA = connection1;
            connectionB = connection2;
            serverA = this.connector;
        } else {
            connectionA = connection2;
            connectionB = connection1;
            serverA = this.remoteConnector;
        }
        DiscoveryTransportBrokerTest.assertNotNull((Object)this.receiveMessage(connectionA));
        this.assertNoMessagesLeft(connectionB);
        log.info((Object)"Disconnecting active server");
        serverA.stop();
        log.info((Object)"Sending request that should failover");
        connection3.request((Command)this.createMessage(producerInfo3, (ActiveMQDestination)destination, deliveryMode));
        DiscoveryTransportBrokerTest.assertNotNull((Object)this.receiveMessage(connectionB));
        this.assertNoMessagesLeft(connectionA);
    }

    protected String getLocalURI() {
        return "tcp://localhost:0?wireFormat.tcpNoDelayEnabled=true";
    }

    protected String getRemoteURI() {
        return "tcp://localhost:0?wireFormat.tcpNoDelayEnabled=true";
    }

    protected TransportConnector createConnector() throws Exception, IOException, URISyntaxException {
        TransportConnector x = super.createConnector();
        x.setDiscoveryUri(new URI(this.getDiscoveryUri()));
        return x;
    }

    protected String getDiscoveryUri() {
        return "multicast://default";
    }

    protected TransportConnector createRemoteConnector() throws Exception, IOException, URISyntaxException {
        TransportConnector x = super.createRemoteConnector();
        x.setDiscoveryUri(new URI(this.getDiscoveryUri()));
        return x;
    }

    protected StubConnection createFailoverConnection() throws Exception {
        URI failoverURI = new URI("discovery:" + this.getDiscoveryUri());
        Transport transport = TransportFactory.connect((URI)failoverURI);
        StubConnection connection = new StubConnection(transport);
        this.connections.add(connection);
        return connection;
    }

    public static Test suite() {
        return DiscoveryTransportBrokerTest.suite(DiscoveryTransportBrokerTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)DiscoveryTransportBrokerTest.suite());
    }
}

