/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.util.ServiceStopper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TopicClusterTest
extends TestCase
implements MessageListener {
    protected static final Log log = LogFactory.getLog((Class)TopicClusterTest.class);
    protected Destination destination;
    protected boolean topic = true;
    protected AtomicInteger receivedMessageCount = new AtomicInteger(0);
    protected static int MESSAGE_COUNT = 50;
    protected static int NUMBER_IN_CLUSTER = 3;
    protected int deliveryMode = 1;
    protected MessageProducer[] producers;
    protected Connection[] connections;
    protected List services = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUp() throws Exception {
        this.connections = new Connection[NUMBER_IN_CLUSTER];
        this.producers = new MessageProducer[NUMBER_IN_CLUSTER];
        Destination destination = this.createDestination();
        int portStart = 50000;
        String root = System.getProperty("activemq.store.dir");
        if (root == null) {
            root = "target/store";
        }
        try {
            for (int i = 0; i < NUMBER_IN_CLUSTER; ++i) {
                System.setProperty("activemq.store.dir", root + "_broker_" + i);
                this.connections[i] = this.createConnection("broker-" + i);
                this.connections[i].setClientID("ClusterTest" + i);
                this.connections[i].start();
                Session session = this.connections[i].createSession(false, 1);
                this.producers[i] = session.createProducer(destination);
                this.producers[i].setDeliveryMode(this.deliveryMode);
                MessageConsumer consumer = this.createMessageConsumer(session, destination);
                consumer.setMessageListener((MessageListener)this);
            }
            log.info((Object)"Sleeping to ensure cluster is fully connected");
            Thread.sleep(5000L);
        }
        finally {
            System.setProperty("activemq.store.dir", root);
        }
    }

    protected void tearDown() throws Exception {
        if (this.connections != null) {
            for (int i = 0; i < this.connections.length; ++i) {
                this.connections[i].close();
            }
        }
        ServiceStopper stopper = new ServiceStopper();
        stopper.stopServices(this.services);
    }

    protected MessageConsumer createMessageConsumer(Session session, Destination destination) throws JMSException {
        return session.createConsumer(destination);
    }

    protected ActiveMQConnectionFactory createGenericClusterFactory(String brokerName) throws Exception {
        BrokerService container = new BrokerService();
        container.setBrokerName(brokerName);
        String url = "tcp://localhost:0";
        TransportConnector connector = container.addConnector(url);
        connector.setDiscoveryUri(new URI("multicast://default"));
        container.addNetworkConnector("multicast://default");
        container.start();
        this.services.add(container);
        return new ActiveMQConnectionFactory("vm://" + brokerName);
    }

    protected int expectedReceiveCount() {
        return MESSAGE_COUNT * NUMBER_IN_CLUSTER * NUMBER_IN_CLUSTER;
    }

    protected Connection createConnection(String name) throws Exception {
        return this.createGenericClusterFactory(name).createConnection();
    }

    protected Destination createDestination() {
        return this.createDestination(((Object)((Object)this)).getClass().getName());
    }

    protected Destination createDestination(String name) {
        if (this.topic) {
            return new ActiveMQTopic(name);
        }
        return new ActiveMQQueue(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message msg) {
        this.receivedMessageCount.incrementAndGet();
        AtomicInteger atomicInteger = this.receivedMessageCount;
        synchronized (atomicInteger) {
            if (this.receivedMessageCount.get() >= this.expectedReceiveCount()) {
                this.receivedMessageCount.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSendReceive() throws Exception {
        for (int i = 0; i < MESSAGE_COUNT; ++i) {
            ActiveMQTextMessage textMessage = new ActiveMQTextMessage();
            textMessage.setText("MSG-NO:" + i);
            for (int x = 0; x < this.producers.length; ++x) {
                this.producers[x].send((Message)textMessage);
            }
        }
        AtomicInteger atomicInteger = this.receivedMessageCount;
        synchronized (atomicInteger) {
            if (this.receivedMessageCount.get() < this.expectedReceiveCount()) {
                this.receivedMessageCount.wait(20000L);
            }
        }
        Thread.sleep(2000L);
        System.err.println("GOT: " + this.receivedMessageCount.get());
        TopicClusterTest.assertEquals((String)"Expected message count not correct", (int)this.expectedReceiveCount(), (int)this.receivedMessageCount.get());
    }
}

