/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.test.message;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import org.apache.activemq.test.JmsTopicSendReceiveWithTwoConnectionsAndEmbeddedBrokerTest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NestedMapMessageTest
extends JmsTopicSendReceiveWithTwoConnectionsAndEmbeddedBrokerTest {
    private static final Log log = LogFactory.getLog((Class)NestedMapMessageTest.class);

    protected void assertMessageValid(int index, Message message) throws JMSException {
        NestedMapMessageTest.assertTrue((String)("Should be a MapMessage: " + message), (boolean)(message instanceof MapMessage));
        MapMessage mapMessage = (MapMessage)message;
        Object value = mapMessage.getObject("textField");
        NestedMapMessageTest.assertEquals((String)"textField", (Object)this.data[index], (Object)value);
        Map map = (Map)mapMessage.getObject("mapField");
        NestedMapMessageTest.assertNotNull((Object)map);
        NestedMapMessageTest.assertEquals((String)"mapField.a", (Object)"foo", map.get("a"));
        NestedMapMessageTest.assertEquals((String)"mapField.b", (Object)new Integer(23), map.get("b"));
        NestedMapMessageTest.assertEquals((String)"mapField.c", (Object)new Long(45L), map.get("c"));
        value = map.get("d");
        NestedMapMessageTest.assertTrue((String)"mapField.d should be a Map", (boolean)(value instanceof Map));
        map = (Map)value;
        NestedMapMessageTest.assertEquals((String)"mapField.d.x", (Object)"abc", map.get("x"));
        value = map.get("y");
        NestedMapMessageTest.assertTrue((String)"mapField.d.y is a List", (boolean)(value instanceof List));
        List list = (List)value;
        log.debug((Object)("mapField.d.y: " + list));
        NestedMapMessageTest.assertEquals((String)"listField.size", (int)3, (int)list.size());
        log.debug((Object)("Found map: " + map));
        list = (List)mapMessage.getObject("listField");
        log.debug((Object)("listField: " + list));
        NestedMapMessageTest.assertEquals((String)"listField.size", (int)3, (int)list.size());
        NestedMapMessageTest.assertEquals((String)"listField[0]", (Object)"a", list.get(0));
        NestedMapMessageTest.assertEquals((String)"listField[1]", (Object)"b", list.get(1));
        NestedMapMessageTest.assertEquals((String)"listField[2]", (Object)"c", list.get(2));
    }

    protected Message createMessage(int index) throws JMSException {
        MapMessage answer = this.session.createMapMessage();
        answer.setString("textField", this.data[index]);
        HashMap<String, Object> grandChildMap = new HashMap<String, Object>();
        grandChildMap.put("x", "abc");
        grandChildMap.put("y", Arrays.asList("a", "b", "c"));
        HashMap<String, Object> nestedMap = new HashMap<String, Object>();
        nestedMap.put("a", "foo");
        nestedMap.put("b", new Integer(23));
        nestedMap.put("c", new Long(45L));
        nestedMap.put("d", grandChildMap);
        answer.setObject("mapField", nestedMap);
        answer.setObject("listField", Arrays.asList("a", "b", "c"));
        return answer;
    }
}

