/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.spring;

import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.spring.SpringConsumer;
import org.apache.activemq.spring.SpringProducer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringTest
extends TestCase {
    private static final Log log = LogFactory.getLog((Class)SpringTest.class);
    protected AbstractApplicationContext context;
    protected SpringConsumer consumer;
    protected SpringProducer producer;

    public void testSenderWithSpringXmlEmbeddedPooledBrokerConfiguredViaXml() throws Exception {
        String config = "spring-embedded-pooled.xml";
        Thread.currentThread().setContextClassLoader(SpringTest.class.getClassLoader());
        ClassPathXmlApplicationContext context1 = new ClassPathXmlApplicationContext(config);
        BrokerService bs1 = (BrokerService)context1.getBean("broker1");
        SpringTest.assertNotNull((Object)bs1);
        BrokerService bs2 = (BrokerService)context1.getBean("broker2");
        SpringTest.assertNotNull((Object)bs1);
        SpringTest.assertEquals((Object)bs1, (Object)bs2);
        ClassPathXmlApplicationContext context2 = new ClassPathXmlApplicationContext(config);
        BrokerService bs3 = (BrokerService)context2.getBean("broker1");
        SpringTest.assertNotNull((Object)bs3);
        BrokerService bs4 = (BrokerService)context2.getBean("broker2");
        SpringTest.assertNotNull((Object)bs4);
        SpringTest.assertEquals((Object)bs1, (Object)bs3);
        SpringTest.assertEquals((Object)bs1, (Object)bs4);
        SpringTest.assertTrue((boolean)bs1.isStarted());
        context2.close();
        SpringTest.assertTrue((boolean)bs1.isStarted());
        context1.close();
        SpringTest.assertFalse((boolean)bs1.isStarted());
    }

    public void testSenderWithSpringXml() throws Exception {
        String config = "spring.xml";
        this.assertSenderConfig(config);
    }

    public void testSenderWithSpringXmlAndQueue() throws Exception {
        String config = "spring-queue.xml";
        this.assertSenderConfig(config);
    }

    public void testSenderWithSpringXmlUsingJNDI() throws Exception {
        String config = "spring-jndi.xml";
        this.assertSenderConfig(config);
    }

    public void testSenderWithSpringXmlEmbeddedBrokerConfiguredViaXml() throws Exception {
        String config = "spring-embedded.xml";
        this.assertSenderConfig(config);
    }

    public void XtestSenderWithSpringXmlUsingSpring2NamespacesWithEmbeddedBrokerConfiguredViaXml() throws Exception {
        String config = "spring-embedded-xbean.xml";
        this.assertSenderConfig(config);
    }

    protected void assertSenderConfig(String config) throws Exception {
        Thread.currentThread().setContextClassLoader(SpringTest.class.getClassLoader());
        this.context = new ClassPathXmlApplicationContext(config);
        this.consumer = (SpringConsumer)((Object)this.context.getBean("consumer"));
        SpringTest.assertTrue((String)"Found a valid consumer", (this.consumer != null ? 1 : 0) != 0);
        this.consumer.start();
        Thread.sleep(1000L);
        this.consumer.flushMessages();
        this.producer = (SpringProducer)this.context.getBean("producer");
        SpringTest.assertTrue((String)"Found a valid producer", (this.producer != null ? 1 : 0) != 0);
        this.producer.start();
        this.consumer.waitForMessagesToArrive(this.producer.getMessageCount());
        List messages = this.consumer.flushMessages();
        log.info((Object)"Consumer has received messages....");
        Iterator iter = messages.iterator();
        while (iter.hasNext()) {
            Object message = iter.next();
            log.info((Object)("Received: " + message));
        }
        SpringTest.assertEquals((String)"Message count", (int)this.producer.getMessageCount(), (int)messages.size());
    }

    protected void tearDown() throws Exception {
        if (this.consumer != null) {
            this.consumer.stop();
        }
        if (this.producer != null) {
            this.producer.stop();
        }
        if (this.context != null) {
            this.context.destroy();
        }
    }
}

