/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.security;

import java.util.ArrayList;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.jaas.GroupPrincipal;
import org.apache.activemq.security.AuthorizationEntry;
import org.apache.activemq.security.AuthorizationMap;
import org.apache.activemq.security.DefaultAuthorizationMap;

public class AuthorizationMapTest
extends TestCase {
    static final GroupPrincipal guests = new GroupPrincipal("guests");
    static final GroupPrincipal users = new GroupPrincipal("users");
    static final GroupPrincipal admins = new GroupPrincipal("admins");

    public void testAuthorizationMap() {
        AuthorizationMap map = this.createAuthorizationMap();
        Set readACLs = map.getReadACLs((ActiveMQDestination)new ActiveMQQueue("USERS.FOO.BAR"));
        AuthorizationMapTest.assertEquals((String)("set size: " + readACLs), (int)2, (int)readACLs.size());
        AuthorizationMapTest.assertTrue((String)"Contains users group", (boolean)readACLs.contains(admins));
        AuthorizationMapTest.assertTrue((String)"Contains users group", (boolean)readACLs.contains(users));
    }

    protected AuthorizationMap createAuthorizationMap() {
        DefaultAuthorizationMap answer = new DefaultAuthorizationMap();
        ArrayList<AuthorizationEntry> entries = new ArrayList<AuthorizationEntry>();
        AuthorizationEntry entry = new AuthorizationEntry();
        entry.setQueue(">");
        entry.setRead("admins");
        entries.add(entry);
        entry = new AuthorizationEntry();
        entry.setQueue("USERS.>");
        entry.setRead("users");
        entries.add(entry);
        answer.setAuthorizationEntries(entries);
        return answer;
    }
}

