/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.proxy;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.BrokerTestSupport;
import org.apache.activemq.broker.StubConnection;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.memory.UsageManager;
import org.apache.activemq.proxy.ProxyConnector;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFactory;

public class ProxyTestSupport
extends BrokerTestSupport {
    protected ArrayList connections = new ArrayList();
    protected TransportConnector connector;
    protected PersistenceAdapter remotePersistenceAdapter;
    protected BrokerService remoteBroker;
    protected UsageManager remoteMemoryManager;
    protected TransportConnector remoteConnector;
    private ProxyConnector proxyConnector;
    private ProxyConnector remoteProxyConnector;

    protected BrokerService createBroker() throws Exception {
        BrokerService service = new BrokerService();
        service.setBrokerName("broker1");
        service.setPersistent(false);
        this.connector = service.addConnector(this.getLocalURI());
        this.proxyConnector = new ProxyConnector();
        this.proxyConnector.setName("proxy");
        this.proxyConnector.setBind(new URI(this.getLocalProxyURI()));
        this.proxyConnector.setRemote(new URI("fanout:static://" + this.getRemoteURI()));
        service.addProxyConnector(this.proxyConnector);
        return service;
    }

    protected BrokerService createRemoteBroker() throws Exception {
        BrokerService service = new BrokerService();
        service.setBrokerName("broker2");
        service.setPersistent(false);
        this.remoteConnector = service.addConnector(this.getRemoteURI());
        this.remoteProxyConnector = new ProxyConnector();
        this.remoteProxyConnector.setName("remoteProxy");
        this.remoteProxyConnector.setBind(new URI(this.getRemoteProxyURI()));
        this.remoteProxyConnector.setRemote(new URI("fanout:static://" + this.getLocalURI()));
        service.addProxyConnector(this.remoteProxyConnector);
        return service;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.remoteBroker = this.createRemoteBroker();
        this.remoteBroker.start();
    }

    protected void tearDown() throws Exception {
        Iterator iter = this.connections.iterator();
        while (iter.hasNext()) {
            StubConnection connection = (StubConnection)iter.next();
            connection.stop();
            iter.remove();
        }
        this.remoteBroker.stop();
        super.tearDown();
    }

    protected String getRemoteURI() {
        return "tcp://localhost:7001";
    }

    protected String getLocalURI() {
        return "tcp://localhost:6001";
    }

    protected String getRemoteProxyURI() {
        return "tcp://localhost:7002";
    }

    protected String getLocalProxyURI() {
        return "tcp://localhost:6002";
    }

    protected StubConnection createConnection() throws Exception {
        Transport transport = TransportFactory.connect((URI)this.connector.getServer().getConnectURI());
        StubConnection connection = new StubConnection(transport);
        this.connections.add(connection);
        return connection;
    }

    protected StubConnection createRemoteConnection() throws Exception {
        Transport transport = TransportFactory.connect((URI)this.remoteConnector.getServer().getConnectURI());
        StubConnection connection = new StubConnection(transport);
        this.connections.add(connection);
        return connection;
    }

    protected StubConnection createProxyConnection() throws Exception {
        Transport transport = TransportFactory.connect((URI)this.proxyConnector.getServer().getConnectURI());
        StubConnection connection = new StubConnection(transport);
        this.connections.add(connection);
        return connection;
    }

    protected StubConnection createRemoteProxyConnection() throws Exception {
        Transport transport = TransportFactory.connect((URI)this.remoteProxyConnector.getServer().getConnectURI());
        StubConnection connection = new StubConnection(transport);
        this.connections.add(connection);
        return connection;
    }
}

