/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.management;

import org.apache.activemq.management.StatisticImpl;
import org.apache.activemq.management.StatisticTestSupport;
import org.apache.activemq.management.TimeStatisticImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TimeStatisticTest
extends StatisticTestSupport {
    private static final Log log = LogFactory.getLog((Class)TimeStatisticTest.class);

    public void testStatistic() throws Exception {
        TimeStatisticImpl stat = new TimeStatisticImpl("myTimer", "millis", "myDescription");
        this.assertStatistic((StatisticImpl)stat, "myTimer", "millis", "myDescription");
        TimeStatisticTest.assertEquals((long)0L, (long)stat.getCount());
        stat.addTime(100L);
        TimeStatisticTest.assertEquals((long)1L, (long)stat.getCount());
        TimeStatisticTest.assertEquals((long)100L, (long)stat.getMinTime());
        TimeStatisticTest.assertEquals((long)100L, (long)stat.getMaxTime());
        stat.addTime(403L);
        TimeStatisticTest.assertEquals((long)2L, (long)stat.getCount());
        TimeStatisticTest.assertEquals((long)100L, (long)stat.getMinTime());
        TimeStatisticTest.assertEquals((long)403L, (long)stat.getMaxTime());
        stat.addTime(50L);
        TimeStatisticTest.assertEquals((long)3L, (long)stat.getCount());
        TimeStatisticTest.assertEquals((long)50L, (long)stat.getMinTime());
        TimeStatisticTest.assertEquals((long)403L, (long)stat.getMaxTime());
        TimeStatisticTest.assertEquals((long)553L, (long)stat.getTotalTime());
        Thread.sleep(500L);
        stat.addTime(10L);
        this.assertLastTimeNotStartTime((StatisticImpl)stat);
        log.info((Object)("Stat is: " + stat));
        stat.reset();
        TimeStatisticTest.assertEquals((long)0L, (long)stat.getCount());
        TimeStatisticTest.assertEquals((long)0L, (long)stat.getMinTime());
        TimeStatisticTest.assertEquals((long)0L, (long)stat.getMaxTime());
        TimeStatisticTest.assertEquals((long)0L, (long)stat.getTotalTime());
        stat.addTime(100L);
        TimeStatisticTest.assertEquals((long)1L, (long)stat.getCount());
        TimeStatisticTest.assertEquals((long)100L, (long)stat.getMinTime());
        TimeStatisticTest.assertEquals((long)100L, (long)stat.getMaxTime());
        TimeStatisticTest.assertEquals((long)100L, (long)stat.getTotalTime());
    }
}

