/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.demo;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleQueueSender {
    private static final Log log = LogFactory.getLog((Class)SimpleQueueSender.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String queueName = null;
        InitialContext jndiContext = null;
        QueueConnectionFactory queueConnectionFactory = null;
        QueueConnection queueConnection = null;
        QueueSession queueSession = null;
        Queue queue = null;
        QueueSender queueSender = null;
        TextMessage message = null;
        if (args.length < 1 || args.length > 2) {
            log.info((Object)"Usage: java SimpleQueueSender <queue-name> [<number-of-messages>]");
            System.exit(1);
        }
        queueName = args[0];
        log.info((Object)("Queue name is " + queueName));
        int NUM_MSGS = args.length == 2 ? new Integer(args[1]) : 1;
        try {
            jndiContext = new InitialContext();
        }
        catch (NamingException e) {
            log.info((Object)("Could not create JNDI API context: " + e.toString()));
            System.exit(1);
        }
        try {
            queueConnectionFactory = (QueueConnectionFactory)jndiContext.lookup("QueueConnectionFactory");
            queue = (Queue)jndiContext.lookup(queueName);
        }
        catch (NamingException e) {
            log.info((Object)("JNDI API lookup failed: " + e));
            System.exit(1);
        }
        try {
            queueConnection = queueConnectionFactory.createQueueConnection();
            queueSession = queueConnection.createQueueSession(false, 1);
            queueSender = queueSession.createSender(queue);
            message = queueSession.createTextMessage();
            for (int i = 0; i < NUM_MSGS; ++i) {
                message.setText("This is message " + (i + 1));
                log.info((Object)("Sending message: " + message.getText()));
                queueSender.send((Message)message);
            }
            queueSender.send(queueSession.createMessage());
        }
        catch (JMSException e) {
            log.info((Object)("Exception occurred: " + e.toString()));
        }
        finally {
            if (queueConnection != null) {
                try {
                    queueConnection.close();
                }
                catch (JMSException e) {}
            }
        }
    }
}

