/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.demo;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleConsumer {
    private static final Log log = LogFactory.getLog((Class)SimpleConsumer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String destinationName = null;
        InitialContext jndiContext = null;
        ConnectionFactory connectionFactory = null;
        Connection connection = null;
        Session session = null;
        Destination destination = null;
        MessageConsumer consumer = null;
        if (args.length != 1) {
            log.info((Object)"Usage: java SimpleConsumer <destination-name>");
            System.exit(1);
        }
        destinationName = args[0];
        log.info((Object)("Destination name is " + destinationName));
        try {
            jndiContext = new InitialContext();
        }
        catch (NamingException e) {
            log.info((Object)("Could not create JNDI API context: " + e.toString()));
            System.exit(1);
        }
        try {
            connectionFactory = (ConnectionFactory)jndiContext.lookup("ConnectionFactory");
            destination = (Destination)jndiContext.lookup(destinationName);
        }
        catch (NamingException e) {
            log.info((Object)("JNDI API lookup failed: " + e.toString()));
            System.exit(1);
        }
        try {
            connection = connectionFactory.createConnection();
            session = connection.createSession(false, 1);
            consumer = session.createConsumer(destination);
            connection.start();
            while (true) {
                Message m;
                if ((m = consumer.receive(1L)) == null) {
                    continue;
                }
                if (m instanceof TextMessage) {
                    TextMessage message = (TextMessage)m;
                    log.info((Object)("Reading message: " + message.getText()));
                    continue;
                }
                break;
            }
        }
        catch (JMSException e) {
            log.info((Object)("Exception occurred: " + (Object)((Object)e)));
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (JMSException e) {}
            }
        }
    }
}

