/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.command;

import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.apache.activemq.command.ActiveMQStreamMessage;

public class ActiveMQStreamMessageTest
extends TestCase {
    public static void main(String[] args) {
        TestRunner.run((Class)ActiveMQStreamMessageTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public ActiveMQStreamMessageTest(String arg0) {
        super(arg0);
    }

    public void testGetDataStructureType() {
        ActiveMQStreamMessage msg = new ActiveMQStreamMessage();
        ActiveMQStreamMessageTest.assertEquals((byte)msg.getDataStructureType(), (byte)27);
    }

    public void testReadBoolean() {
        ActiveMQStreamMessage msg = new ActiveMQStreamMessage();
        try {
            msg.writeBoolean(true);
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((boolean)msg.readBoolean());
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((boolean)msg.readString().equals("true"));
            msg.reset();
            try {
                msg.readByte();
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException mfe) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readShort();
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException mfe) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readInt();
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException mfe) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readLong();
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException mfe) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readFloat();
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException mfe) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readDouble();
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException mfe) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readChar();
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException mfe) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readBytes(new byte[1]);
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException mfe) {}
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            ActiveMQStreamMessageTest.assertTrue((boolean)false);
        }
    }

    public void testreadByte() {
        ActiveMQStreamMessage msg = new ActiveMQStreamMessage();
        try {
            byte test = 4;
            msg.writeByte(test);
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((msg.readByte() == test ? 1 : 0) != 0);
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((msg.readShort() == test ? 1 : 0) != 0);
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((msg.readInt() == test ? 1 : 0) != 0);
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((msg.readLong() == (long)test ? 1 : 0) != 0);
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((boolean)msg.readString().equals(new Byte(test).toString()));
            msg.reset();
            try {
                msg.readBoolean();
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException mfe) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readFloat();
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException mfe) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readDouble();
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException mfe) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readChar();
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException mfe) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readBytes(new byte[1]);
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {}
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            ActiveMQStreamMessageTest.assertTrue((boolean)false);
        }
    }

    public void testReadShort() {
        ActiveMQStreamMessage msg = new ActiveMQStreamMessage();
        try {
            short test = 4;
            msg.writeShort(test);
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((msg.readShort() == test ? 1 : 0) != 0);
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((msg.readInt() == test ? 1 : 0) != 0);
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((msg.readLong() == (long)test ? 1 : 0) != 0);
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((boolean)msg.readString().equals(new Short(test).toString()));
            msg.reset();
            try {
                msg.readBoolean();
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException mfe) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readByte();
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException mfe) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readFloat();
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException mfe) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readDouble();
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException mfe) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readChar();
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException mfe) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readBytes(new byte[1]);
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {}
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            ActiveMQStreamMessageTest.assertTrue((boolean)false);
        }
    }

    public void testReadChar() {
        ActiveMQStreamMessage msg = new ActiveMQStreamMessage();
        try {
            char test = 'z';
            msg.writeChar(test);
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((msg.readChar() == test ? 1 : 0) != 0);
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((boolean)msg.readString().equals(new Character(test).toString()));
            msg.reset();
            try {
                msg.readBoolean();
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException mfe) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readByte();
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException mfe) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readShort();
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException mfe) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readInt();
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException mfe) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readLong();
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException mfe) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readFloat();
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException mfe) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readDouble();
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException mfe) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readBytes(new byte[1]);
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {}
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            ActiveMQStreamMessageTest.assertTrue((boolean)false);
        }
    }

    public void testReadInt() {
        ActiveMQStreamMessage msg = new ActiveMQStreamMessage();
        try {
            int test = 4;
            msg.writeInt(test);
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((msg.readInt() == test ? 1 : 0) != 0);
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((msg.readLong() == (long)test ? 1 : 0) != 0);
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((boolean)msg.readString().equals(new Integer(test).toString()));
            msg.reset();
            try {
                msg.readBoolean();
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException mfe) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readByte();
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException mfe) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readShort();
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException mfe) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readFloat();
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException mfe) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readDouble();
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException mfe) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readChar();
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException mfe) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readBytes(new byte[1]);
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {}
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            ActiveMQStreamMessageTest.assertTrue((boolean)false);
        }
    }

    public void testReadLong() {
        ActiveMQStreamMessage msg = new ActiveMQStreamMessage();
        try {
            long test = 4L;
            msg.writeLong(test);
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((msg.readLong() == test ? 1 : 0) != 0);
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((boolean)msg.readString().equals(new Long(test).toString()));
            msg.reset();
            try {
                msg.readBoolean();
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException mfe) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readByte();
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException mfe) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readShort();
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException mfe) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readInt();
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException mfe) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readFloat();
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException mfe) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readDouble();
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException mfe) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readChar();
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException mfe) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readBytes(new byte[1]);
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException mfe) {}
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            ActiveMQStreamMessageTest.assertTrue((boolean)false);
        }
    }

    public void testReadFloat() {
        ActiveMQStreamMessage msg = new ActiveMQStreamMessage();
        try {
            float test = 4.4f;
            msg.writeFloat(test);
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((msg.readFloat() == test ? 1 : 0) != 0);
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((msg.readDouble() == (double)test ? 1 : 0) != 0);
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((boolean)msg.readString().equals(new Float(test).toString()));
            msg.reset();
            try {
                msg.readBoolean();
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException mfe) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readByte();
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException mfe) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readShort();
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException mfe) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readInt();
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException mfe) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readLong();
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException mfe) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readChar();
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException mfe) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readBytes(new byte[1]);
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {}
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            ActiveMQStreamMessageTest.assertTrue((boolean)false);
        }
    }

    public void testReadDouble() {
        ActiveMQStreamMessage msg = new ActiveMQStreamMessage();
        try {
            double test = 4.4;
            msg.writeDouble(test);
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((msg.readDouble() == test ? 1 : 0) != 0);
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((boolean)msg.readString().equals(new Double(test).toString()));
            msg.reset();
            try {
                msg.readBoolean();
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException mfe) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readByte();
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException mfe) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readShort();
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException mfe) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readInt();
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException mfe) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readLong();
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException mfe) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readFloat();
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException mfe) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readChar();
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException mfe) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readBytes(new byte[1]);
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException mfe) {}
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            ActiveMQStreamMessageTest.assertTrue((boolean)false);
        }
    }

    public void testReadString() {
        ActiveMQStreamMessage msg = new ActiveMQStreamMessage();
        try {
            byte testByte = 2;
            msg.writeString(new Byte(testByte).toString());
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((msg.readByte() == testByte ? 1 : 0) != 0);
            msg.clearBody();
            short testShort = 3;
            msg.writeString(new Short(testShort).toString());
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((msg.readShort() == testShort ? 1 : 0) != 0);
            msg.clearBody();
            int testInt = 4;
            msg.writeString(new Integer(testInt).toString());
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((msg.readInt() == testInt ? 1 : 0) != 0);
            msg.clearBody();
            long testLong = 6L;
            msg.writeString(new Long(testLong).toString());
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((msg.readLong() == testLong ? 1 : 0) != 0);
            msg.clearBody();
            float testFloat = 6.6f;
            msg.writeString(new Float(testFloat).toString());
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((msg.readFloat() == testFloat ? 1 : 0) != 0);
            msg.clearBody();
            double testDouble = 7.7;
            msg.writeString(new Double(testDouble).toString());
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((msg.readDouble() == testDouble ? 1 : 0) != 0);
            msg.clearBody();
            msg.writeString("true");
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((boolean)msg.readBoolean());
            msg.clearBody();
            msg.writeString("a");
            msg.reset();
            try {
                msg.readChar();
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException e) {
                // empty catch block
            }
            msg.clearBody();
            msg.writeString("777");
            msg.reset();
            try {
                msg.readBytes(new byte[3]);
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException e) {}
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            ActiveMQStreamMessageTest.assertTrue((boolean)false);
        }
    }

    public void testReadBigString() {
        ActiveMQStreamMessage msg = new ActiveMQStreamMessage();
        try {
            StringBuffer bigSB = new StringBuffer(0x100000);
            for (int i = 0; i < 0x100000; ++i) {
                bigSB.append(97 + i % 26);
            }
            String bigString = bigSB.toString();
            msg.writeString(bigString);
            msg.reset();
            ActiveMQStreamMessageTest.assertEquals((String)bigString, (String)msg.readString());
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            ActiveMQStreamMessageTest.assertTrue((boolean)false);
        }
    }

    public void testReadBytes() {
        ActiveMQStreamMessage msg = new ActiveMQStreamMessage();
        try {
            byte[] test = new byte[50];
            for (int i = 0; i < test.length; ++i) {
                test[i] = (byte)i;
            }
            msg.writeBytes(test);
            msg.reset();
            byte[] valid = new byte[test.length];
            msg.readBytes(valid);
            for (int i = 0; i < valid.length; ++i) {
                ActiveMQStreamMessageTest.assertTrue((valid[i] == test[i] ? 1 : 0) != 0);
            }
            msg.reset();
            try {
                msg.readByte();
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException mfe) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readShort();
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException mfe) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readInt();
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException mfe) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readLong();
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException mfe) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readFloat();
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException mfe) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readChar();
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException mfe) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readString();
                ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException mfe) {}
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            ActiveMQStreamMessageTest.assertTrue((boolean)false);
        }
    }

    public void testReadObject() {
        ActiveMQStreamMessage msg = new ActiveMQStreamMessage();
        try {
            byte testByte = 2;
            msg.writeByte(testByte);
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue(((Byte)msg.readObject() == testByte ? 1 : 0) != 0);
            msg.clearBody();
            short testShort = 3;
            msg.writeShort(testShort);
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue(((Short)msg.readObject() == testShort ? 1 : 0) != 0);
            msg.clearBody();
            int testInt = 4;
            msg.writeInt(testInt);
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue(((Integer)msg.readObject() == testInt ? 1 : 0) != 0);
            msg.clearBody();
            long testLong = 6L;
            msg.writeLong(testLong);
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue(((Long)msg.readObject() == testLong ? 1 : 0) != 0);
            msg.clearBody();
            float testFloat = 6.6f;
            msg.writeFloat(testFloat);
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((((Float)msg.readObject()).floatValue() == testFloat ? 1 : 0) != 0);
            msg.clearBody();
            double testDouble = 7.7;
            msg.writeDouble(testDouble);
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue(((Double)msg.readObject() == testDouble ? 1 : 0) != 0);
            msg.clearBody();
            char testChar = 'z';
            msg.writeChar(testChar);
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((((Character)msg.readObject()).charValue() == testChar ? 1 : 0) != 0);
            msg.clearBody();
            byte[] data = new byte[50];
            for (int i = 0; i < data.length; ++i) {
                data[i] = (byte)i;
            }
            msg.writeBytes(data);
            msg.reset();
            byte[] valid = (byte[])msg.readObject();
            ActiveMQStreamMessageTest.assertTrue((valid.length == data.length ? 1 : 0) != 0);
            for (int i = 0; i < valid.length; ++i) {
                ActiveMQStreamMessageTest.assertTrue((valid[i] == data[i] ? 1 : 0) != 0);
            }
            msg.clearBody();
            msg.writeBoolean(true);
            msg.reset();
            ActiveMQStreamMessageTest.assertTrue((boolean)((Boolean)msg.readObject()));
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            ActiveMQStreamMessageTest.assertTrue((boolean)false);
        }
    }

    public void testClearBody() throws JMSException {
        ActiveMQStreamMessage streamMessage = new ActiveMQStreamMessage();
        try {
            streamMessage.writeObject((Object)new Serializable(){
                private static final long serialVersionUID = -5181896809607968727L;
            });
            streamMessage.clearBody();
            ActiveMQStreamMessageTest.assertFalse((boolean)streamMessage.isReadOnlyBody());
            streamMessage.writeObject((Object)new Serializable(){
                private static final long serialVersionUID = 5074177640797561141L;
            });
            streamMessage.readObject();
            ActiveMQStreamMessageTest.fail((String)"should throw exception");
        }
        catch (MessageNotReadableException mnwe) {
        }
        catch (MessageNotWriteableException mnwe) {
            ActiveMQStreamMessageTest.fail((String)"should be writeable");
        }
    }

    public void testReset() throws JMSException {
        ActiveMQStreamMessage streamMessage = new ActiveMQStreamMessage();
        try {
            streamMessage.writeDouble(24.5);
            streamMessage.writeLong(311L);
        }
        catch (MessageNotWriteableException mnwe) {
            ActiveMQStreamMessageTest.fail((String)"should be writeable");
        }
        streamMessage.reset();
        try {
            ActiveMQStreamMessageTest.assertTrue((boolean)streamMessage.isReadOnlyBody());
            ActiveMQStreamMessageTest.assertEquals((double)streamMessage.readDouble(), (double)24.5, (double)0.0);
            ActiveMQStreamMessageTest.assertEquals((long)streamMessage.readLong(), (long)311L);
        }
        catch (MessageNotReadableException mnre) {
            ActiveMQStreamMessageTest.fail((String)"should be readable");
        }
        try {
            streamMessage.writeInt(33);
            ActiveMQStreamMessageTest.fail((String)"should throw exception");
        }
        catch (MessageNotWriteableException messageNotWriteableException) {
            // empty catch block
        }
    }

    public void testReadOnlyBody() throws JMSException {
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        try {
            message.writeBoolean(true);
            message.writeByte((byte)1);
            message.writeBytes(new byte[1]);
            message.writeBytes(new byte[3], 0, 2);
            message.writeChar('a');
            message.writeDouble(1.5);
            message.writeFloat(1.5f);
            message.writeInt(1);
            message.writeLong(1L);
            message.writeObject((Object)"stringobj");
            message.writeShort((short)1);
            message.writeString("string");
        }
        catch (MessageNotWriteableException mnwe) {
            ActiveMQStreamMessageTest.fail((String)"Should be writeable");
        }
        message.reset();
        try {
            message.readBoolean();
            message.readByte();
            ActiveMQStreamMessageTest.assertEquals((int)1, (int)message.readBytes(new byte[10]));
            ActiveMQStreamMessageTest.assertEquals((int)-1, (int)message.readBytes(new byte[10]));
            ActiveMQStreamMessageTest.assertEquals((int)2, (int)message.readBytes(new byte[10]));
            ActiveMQStreamMessageTest.assertEquals((int)-1, (int)message.readBytes(new byte[10]));
            message.readChar();
            message.readDouble();
            message.readFloat();
            message.readInt();
            message.readLong();
            message.readString();
            message.readShort();
            message.readString();
        }
        catch (MessageNotReadableException mnwe) {
            ActiveMQStreamMessageTest.fail((String)"Should be readable");
        }
        try {
            message.writeBoolean(true);
            ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageNotWriteableException mnwe) {
            // empty catch block
        }
        try {
            message.writeByte((byte)1);
            ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageNotWriteableException mnwe) {
            // empty catch block
        }
        try {
            message.writeBytes(new byte[1]);
            ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageNotWriteableException mnwe) {
            // empty catch block
        }
        try {
            message.writeBytes(new byte[3], 0, 2);
            ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageNotWriteableException mnwe) {
            // empty catch block
        }
        try {
            message.writeChar('a');
            ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageNotWriteableException mnwe) {
            // empty catch block
        }
        try {
            message.writeDouble(1.5);
            ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageNotWriteableException mnwe) {
            // empty catch block
        }
        try {
            message.writeFloat(1.5f);
            ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageNotWriteableException mnwe) {
            // empty catch block
        }
        try {
            message.writeInt(1);
            ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageNotWriteableException mnwe) {
            // empty catch block
        }
        try {
            message.writeLong(1L);
            ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageNotWriteableException mnwe) {
            // empty catch block
        }
        try {
            message.writeObject((Object)"stringobj");
            ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageNotWriteableException mnwe) {
            // empty catch block
        }
        try {
            message.writeShort((short)1);
            ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageNotWriteableException mnwe) {
            // empty catch block
        }
        try {
            message.writeString("string");
            ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageNotWriteableException messageNotWriteableException) {
            // empty catch block
        }
    }

    public void testWriteOnlyBody() throws JMSException {
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        message.clearBody();
        try {
            message.writeBoolean(true);
            message.writeByte((byte)1);
            message.writeBytes(new byte[1]);
            message.writeBytes(new byte[3], 0, 2);
            message.writeChar('a');
            message.writeDouble(1.5);
            message.writeFloat(1.5f);
            message.writeInt(1);
            message.writeLong(1L);
            message.writeObject((Object)"stringobj");
            message.writeShort((short)1);
            message.writeString("string");
        }
        catch (MessageNotWriteableException mnwe) {
            ActiveMQStreamMessageTest.fail((String)"Should be writeable");
        }
        try {
            message.readBoolean();
            ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageNotReadableException mnwe) {
            // empty catch block
        }
        try {
            message.readByte();
            ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageNotReadableException e) {
            // empty catch block
        }
        try {
            message.readBytes(new byte[1]);
            ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageNotReadableException e) {
            // empty catch block
        }
        try {
            message.readBytes(new byte[2]);
            ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageNotReadableException e) {
            // empty catch block
        }
        try {
            message.readChar();
            ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageNotReadableException e) {
            // empty catch block
        }
        try {
            message.readDouble();
            ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageNotReadableException e) {
            // empty catch block
        }
        try {
            message.readFloat();
            ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageNotReadableException e) {
            // empty catch block
        }
        try {
            message.readInt();
            ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageNotReadableException e) {
            // empty catch block
        }
        try {
            message.readLong();
            ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageNotReadableException e) {
            // empty catch block
        }
        try {
            message.readString();
            ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageNotReadableException e) {
            // empty catch block
        }
        try {
            message.readShort();
            ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageNotReadableException e) {
            // empty catch block
        }
        try {
            message.readString();
            ActiveMQStreamMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageNotReadableException messageNotReadableException) {
            // empty catch block
        }
    }
}

