/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.cursors;

import edu.emory.mathcs.backport.java.util.concurrent.CountDownLatch;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.util.ArrayList;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.policy.PendingDurableSubscriberMessageStoragePolicy;
import org.apache.activemq.broker.region.policy.StorePendingDurableSubscriberMessageStoragePolicy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CursorDurableTest
extends TestCase {
    protected static final Log log = LogFactory.getLog((Class)CursorDurableTest.class);
    protected static final int MESSAGE_COUNT = 100;
    protected static final int PREFETCH_SIZE = 5;
    protected BrokerService broker;
    protected String bindAddress = "tcp://localhost:60706";
    protected int topicCount = 0;

    public void testSendFirstThenConsume() throws Exception {
        ActiveMQConnectionFactory factory = this.createConnectionFactory();
        Connection consumerConnection = this.getConsumerConnection((ConnectionFactory)factory);
        MessageConsumer consumer = this.getConsumer(consumerConnection);
        consumerConnection.close();
        Connection producerConnection = factory.createConnection();
        producerConnection.start();
        Session session = producerConnection.createSession(false, 1);
        MessageProducer producer = session.createProducer((Destination)this.getTopic(session));
        ArrayList<TextMessage> senderList = new ArrayList<TextMessage>();
        for (int i = 0; i < 100; ++i) {
            TextMessage msg = session.createTextMessage("test" + i);
            senderList.add(msg);
            producer.send((Message)msg);
        }
        producerConnection.close();
        consumerConnection = this.getConsumerConnection((ConnectionFactory)factory);
        consumer = this.getConsumer(consumerConnection);
        ArrayList<Message> consumerList = new ArrayList<Message>();
        for (int i = 0; i < 100; ++i) {
            Message msg = consumer.receive();
            consumerList.add(msg);
        }
        CursorDurableTest.assertEquals(senderList, consumerList);
        consumerConnection.close();
    }

    public void testSendWhilstConsume() throws Exception {
        ActiveMQConnectionFactory factory = this.createConnectionFactory();
        Connection consumerConnection = this.getConsumerConnection((ConnectionFactory)factory);
        MessageConsumer consumer = this.getConsumer(consumerConnection);
        consumerConnection.close();
        Connection producerConnection = factory.createConnection();
        producerConnection.start();
        Session session = producerConnection.createSession(false, 1);
        MessageProducer producer = session.createProducer((Destination)this.getTopic(session));
        ArrayList<TextMessage> senderList = new ArrayList<TextMessage>();
        for (int i = 0; i < 10; ++i) {
            TextMessage msg = session.createTextMessage("test" + i);
            senderList.add(msg);
            producer.send((Message)msg);
        }
        consumerConnection = this.getConsumerConnection((ConnectionFactory)factory);
        consumer = this.getConsumer(consumerConnection);
        final ArrayList consumerList = new ArrayList();
        final CountDownLatch latch = new CountDownLatch(1);
        consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message msg) {
                try {
                    Thread.sleep(50L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                consumerList.add(msg);
                if (consumerList.size() == 100) {
                    latch.countDown();
                }
            }
        });
        for (int i = 10; i < 100; ++i) {
            TextMessage msg = session.createTextMessage("test" + i);
            senderList.add(msg);
            producer.send((Message)msg);
        }
        latch.await(300000L, TimeUnit.MILLISECONDS);
        CursorDurableTest.assertEquals((String)"Still dipatching - count down latch not sprung", (long)latch.getCount(), (long)0L);
        CursorDurableTest.assertEquals((String)("cosumerList - expected: 100 but was: " + consumerList.size()), (int)consumerList.size(), (int)senderList.size());
        CursorDurableTest.assertEquals(senderList, consumerList);
        producerConnection.close();
        consumerConnection.close();
    }

    protected Topic getTopic(Session session) throws JMSException {
        String topicName = ((Object)((Object)this)).getClass().getName();
        return session.createTopic(topicName);
    }

    protected Connection getConsumerConnection(ConnectionFactory fac) throws JMSException {
        Connection connection = fac.createConnection();
        connection.setClientID("testConsumer");
        connection.start();
        return connection;
    }

    protected MessageConsumer getConsumer(Connection connection) throws Exception {
        Session consumerSession = connection.createSession(false, 1);
        Topic topic = this.getTopic(consumerSession);
        TopicSubscriber consumer = consumerSession.createDurableSubscriber(topic, "testConsumer");
        return consumer;
    }

    protected void setUp() throws Exception {
        if (this.broker == null) {
            this.broker = this.createBroker();
        }
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.broker != null) {
            this.broker.stop();
        }
    }

    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory(this.bindAddress);
        Properties props = new Properties();
        props.setProperty("prefetchPolicy.durableTopicPrefetch", "5");
        props.setProperty("prefetchPolicy.optimizeDurableTopicPrefetch", "5");
        cf.setProperties(props);
        return cf;
    }

    protected BrokerService createBroker() throws Exception {
        BrokerService answer = new BrokerService();
        this.configureBroker(answer);
        answer.setDeleteAllMessagesOnStartup(true);
        answer.setPendingDurableSubscriberPolicy((PendingDurableSubscriberMessageStoragePolicy)new StorePendingDurableSubscriberMessageStoragePolicy());
        answer.start();
        return answer;
    }

    protected void configureBroker(BrokerService answer) throws Exception {
        answer.addConnector(this.bindAddress);
        answer.setDeleteAllMessagesOnStartup(true);
    }
}

