/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.advisory;

import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.activemq.advisory.AdvisorySupport;
import org.apache.activemq.broker.BrokerTestSupport;
import org.apache.activemq.broker.StubConnection;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.RemoveInfo;
import org.apache.activemq.command.SessionInfo;

public class AdvisoryBrokerTest
extends BrokerTestSupport {
    public void testConnectionAdvisories() throws Exception {
        ActiveMQTopic destination = AdvisorySupport.getConnectionAdvisoryTopic();
        StubConnection connection1 = this.createConnection();
        ConnectionInfo connectionInfo1 = this.createConnectionInfo();
        SessionInfo sessionInfo1 = this.createSessionInfo(connectionInfo1);
        ConsumerInfo consumerInfo1 = this.createConsumerInfo(sessionInfo1, (ActiveMQDestination)destination);
        consumerInfo1.setPrefetchSize(100);
        connection1.send((Command)connectionInfo1);
        connection1.send((Command)sessionInfo1);
        connection1.send((Command)consumerInfo1);
        Message m1 = this.receiveMessage(connection1);
        AdvisoryBrokerTest.assertNotNull((Object)m1);
        AdvisoryBrokerTest.assertNotNull((Object)m1.getDataStructure());
        AdvisoryBrokerTest.assertEquals((Object)((ConnectionInfo)m1.getDataStructure()).getConnectionId(), (Object)connectionInfo1.getConnectionId());
        StubConnection connection2 = this.createConnection();
        ConnectionInfo connectionInfo2 = this.createConnectionInfo();
        connection2.send((Command)connectionInfo2);
        m1 = this.receiveMessage(connection1);
        AdvisoryBrokerTest.assertNotNull((Object)m1);
        AdvisoryBrokerTest.assertNotNull((Object)m1.getDataStructure());
        AdvisoryBrokerTest.assertEquals((Object)((ConnectionInfo)m1.getDataStructure()).getConnectionId(), (Object)connectionInfo2.getConnectionId());
        connection2.send((Command)this.closeConnectionInfo(connectionInfo2));
        connection2.stop();
        m1 = this.receiveMessage(connection1);
        AdvisoryBrokerTest.assertNotNull((Object)m1);
        AdvisoryBrokerTest.assertNotNull((Object)m1.getDataStructure());
        RemoveInfo r = (RemoveInfo)m1.getDataStructure();
        AdvisoryBrokerTest.assertEquals((Object)r.getObjectId(), (Object)connectionInfo2.getConnectionId());
        this.assertNoMessagesLeft(connection1);
    }

    public void testConsumerAdvisories() throws Exception {
        ActiveMQQueue queue = new ActiveMQQueue("test");
        ActiveMQTopic destination = AdvisorySupport.getConsumerAdvisoryTopic((ActiveMQDestination)queue);
        StubConnection connection1 = this.createConnection();
        ConnectionInfo connectionInfo1 = this.createConnectionInfo();
        SessionInfo sessionInfo1 = this.createSessionInfo(connectionInfo1);
        ConsumerInfo consumerInfo1 = this.createConsumerInfo(sessionInfo1, (ActiveMQDestination)destination);
        consumerInfo1.setPrefetchSize(100);
        connection1.send((Command)connectionInfo1);
        connection1.send((Command)sessionInfo1);
        connection1.send((Command)consumerInfo1);
        this.assertNoMessagesLeft(connection1);
        StubConnection connection2 = this.createConnection();
        ConnectionInfo connectionInfo2 = this.createConnectionInfo();
        SessionInfo sessionInfo2 = this.createSessionInfo(connectionInfo2);
        ConsumerInfo consumerInfo2 = this.createConsumerInfo(sessionInfo2, (ActiveMQDestination)queue);
        consumerInfo1.setPrefetchSize(100);
        connection2.send((Command)connectionInfo2);
        connection2.send((Command)sessionInfo2);
        connection2.send((Command)consumerInfo2);
        Message m1 = this.receiveMessage(connection1);
        AdvisoryBrokerTest.assertNotNull((Object)m1);
        AdvisoryBrokerTest.assertNotNull((Object)m1.getDataStructure());
        AdvisoryBrokerTest.assertEquals((Object)((ConsumerInfo)m1.getDataStructure()).getConsumerId(), (Object)consumerInfo2.getConsumerId());
        connection2.send((Command)this.closeConnectionInfo(connectionInfo2));
        connection2.stop();
        m1 = this.receiveMessage(connection1);
        AdvisoryBrokerTest.assertNotNull((Object)m1);
        AdvisoryBrokerTest.assertNotNull((Object)m1.getDataStructure());
        RemoveInfo r = (RemoveInfo)m1.getDataStructure();
        AdvisoryBrokerTest.assertEquals((Object)r.getObjectId(), (Object)consumerInfo2.getConsumerId());
        this.assertNoMessagesLeft(connection2);
    }

    public void testConsumerAdvisoriesReplayed() throws Exception {
        ActiveMQQueue queue = new ActiveMQQueue("test");
        ActiveMQTopic destination = AdvisorySupport.getConsumerAdvisoryTopic((ActiveMQDestination)queue);
        StubConnection connection1 = this.createConnection();
        ConnectionInfo connectionInfo1 = this.createConnectionInfo();
        SessionInfo sessionInfo1 = this.createSessionInfo(connectionInfo1);
        connection1.send((Command)connectionInfo1);
        connection1.send((Command)sessionInfo1);
        StubConnection connection2 = this.createConnection();
        ConnectionInfo connectionInfo2 = this.createConnectionInfo();
        SessionInfo sessionInfo2 = this.createSessionInfo(connectionInfo2);
        ConsumerInfo consumerInfo2 = this.createConsumerInfo(sessionInfo2, (ActiveMQDestination)queue);
        consumerInfo2.setPrefetchSize(100);
        connection2.send((Command)connectionInfo2);
        connection2.send((Command)sessionInfo2);
        connection2.send((Command)consumerInfo2);
        ConsumerInfo consumerInfo1 = this.createConsumerInfo(sessionInfo1, (ActiveMQDestination)destination);
        consumerInfo1.setPrefetchSize(100);
        connection1.send((Command)consumerInfo1);
        Message m1 = this.receiveMessage(connection1);
        AdvisoryBrokerTest.assertNotNull((Object)m1);
        AdvisoryBrokerTest.assertNotNull((Object)m1.getDataStructure());
        AdvisoryBrokerTest.assertEquals((Object)((ConsumerInfo)m1.getDataStructure()).getConsumerId(), (Object)consumerInfo2.getConsumerId());
        connection2.send((Command)this.closeConnectionInfo(connectionInfo2));
        connection2.stop();
        m1 = this.receiveMessage(connection1);
        AdvisoryBrokerTest.assertNotNull((Object)m1);
        AdvisoryBrokerTest.assertNotNull((Object)m1.getDataStructure());
        RemoveInfo r = (RemoveInfo)m1.getDataStructure();
        AdvisoryBrokerTest.assertEquals((Object)r.getObjectId(), (Object)consumerInfo2.getConsumerId());
        this.assertNoMessagesLeft(connection2);
    }

    public void testProducerAdvisories() throws Exception {
        ActiveMQQueue queue = new ActiveMQQueue("test");
        ActiveMQTopic destination = AdvisorySupport.getProducerAdvisoryTopic((ActiveMQDestination)queue);
        StubConnection connection1 = this.createConnection();
        ConnectionInfo connectionInfo1 = this.createConnectionInfo();
        SessionInfo sessionInfo1 = this.createSessionInfo(connectionInfo1);
        ConsumerInfo consumerInfo1 = this.createConsumerInfo(sessionInfo1, (ActiveMQDestination)destination);
        consumerInfo1.setPrefetchSize(100);
        connection1.send((Command)connectionInfo1);
        connection1.send((Command)sessionInfo1);
        connection1.send((Command)consumerInfo1);
        this.assertNoMessagesLeft(connection1);
        StubConnection connection2 = this.createConnection();
        ConnectionInfo connectionInfo2 = this.createConnectionInfo();
        SessionInfo sessionInfo2 = this.createSessionInfo(connectionInfo2);
        ProducerInfo producerInfo2 = this.createProducerInfo(sessionInfo2);
        producerInfo2.setDestination((ActiveMQDestination)queue);
        connection2.send((Command)connectionInfo2);
        connection2.send((Command)sessionInfo2);
        connection2.send((Command)producerInfo2);
        Message m1 = this.receiveMessage(connection1);
        AdvisoryBrokerTest.assertNotNull((Object)m1);
        AdvisoryBrokerTest.assertNotNull((Object)m1.getDataStructure());
        AdvisoryBrokerTest.assertEquals((Object)((ProducerInfo)m1.getDataStructure()).getProducerId(), (Object)producerInfo2.getProducerId());
        connection2.send((Command)this.closeConnectionInfo(connectionInfo2));
        connection2.stop();
        m1 = this.receiveMessage(connection1);
        AdvisoryBrokerTest.assertNotNull((Object)m1);
        AdvisoryBrokerTest.assertNotNull((Object)m1.getDataStructure());
        RemoveInfo r = (RemoveInfo)m1.getDataStructure();
        AdvisoryBrokerTest.assertEquals((Object)r.getObjectId(), (Object)producerInfo2.getProducerId());
        this.assertNoMessagesLeft(connection2);
    }

    public void testProducerAdvisoriesReplayed() throws Exception {
        ActiveMQQueue queue = new ActiveMQQueue("test");
        ActiveMQTopic destination = AdvisorySupport.getProducerAdvisoryTopic((ActiveMQDestination)queue);
        StubConnection connection1 = this.createConnection();
        ConnectionInfo connectionInfo1 = this.createConnectionInfo();
        SessionInfo sessionInfo1 = this.createSessionInfo(connectionInfo1);
        connection1.send((Command)connectionInfo1);
        connection1.send((Command)sessionInfo1);
        StubConnection connection2 = this.createConnection();
        ConnectionInfo connectionInfo2 = this.createConnectionInfo();
        SessionInfo sessionInfo2 = this.createSessionInfo(connectionInfo2);
        ProducerInfo producerInfo2 = this.createProducerInfo(sessionInfo2);
        producerInfo2.setDestination((ActiveMQDestination)queue);
        connection2.send((Command)connectionInfo2);
        connection2.send((Command)sessionInfo2);
        connection2.send((Command)producerInfo2);
        ConsumerInfo consumerInfo1 = this.createConsumerInfo(sessionInfo1, (ActiveMQDestination)destination);
        consumerInfo1.setPrefetchSize(100);
        connection1.send((Command)consumerInfo1);
        Message m1 = this.receiveMessage(connection1);
        AdvisoryBrokerTest.assertNotNull((Object)m1);
        AdvisoryBrokerTest.assertNotNull((Object)m1.getDataStructure());
        AdvisoryBrokerTest.assertEquals((Object)((ProducerInfo)m1.getDataStructure()).getProducerId(), (Object)producerInfo2.getProducerId());
        connection2.send((Command)this.closeConnectionInfo(connectionInfo2));
        connection2.stop();
        m1 = this.receiveMessage(connection1);
        AdvisoryBrokerTest.assertNotNull((Object)m1);
        AdvisoryBrokerTest.assertNotNull((Object)m1.getDataStructure());
        RemoveInfo r = (RemoveInfo)m1.getDataStructure();
        AdvisoryBrokerTest.assertEquals((Object)r.getObjectId(), (Object)producerInfo2.getProducerId());
        this.assertNoMessagesLeft(connection2);
    }

    public void testProducerAdvisoriesReplayedOnlyTargetNewConsumer() throws Exception {
        ActiveMQQueue queue = new ActiveMQQueue("test");
        ActiveMQTopic destination = AdvisorySupport.getProducerAdvisoryTopic((ActiveMQDestination)queue);
        StubConnection connection1 = this.createConnection();
        ConnectionInfo connectionInfo1 = this.createConnectionInfo();
        SessionInfo sessionInfo1 = this.createSessionInfo(connectionInfo1);
        connection1.send((Command)connectionInfo1);
        connection1.send((Command)sessionInfo1);
        ConsumerInfo consumerInfo1 = this.createConsumerInfo(sessionInfo1, (ActiveMQDestination)destination);
        consumerInfo1.setPrefetchSize(100);
        connection1.send((Command)consumerInfo1);
        StubConnection connection2 = this.createConnection();
        ConnectionInfo connectionInfo2 = this.createConnectionInfo();
        SessionInfo sessionInfo2 = this.createSessionInfo(connectionInfo2);
        ProducerInfo producerInfo2 = this.createProducerInfo(sessionInfo2);
        producerInfo2.setDestination((ActiveMQDestination)queue);
        connection2.send((Command)connectionInfo2);
        connection2.send((Command)sessionInfo2);
        connection2.send((Command)producerInfo2);
        Message m1 = this.receiveMessage(connection1);
        AdvisoryBrokerTest.assertNotNull((Object)m1);
        AdvisoryBrokerTest.assertNotNull((Object)m1.getDataStructure());
        AdvisoryBrokerTest.assertEquals((Object)((ProducerInfo)m1.getDataStructure()).getProducerId(), (Object)producerInfo2.getProducerId());
        ConsumerInfo consumerInfo2 = this.createConsumerInfo(sessionInfo2, (ActiveMQDestination)destination);
        consumerInfo2.setPrefetchSize(100);
        connection2.send((Command)consumerInfo2);
        m1 = this.receiveMessage(connection2);
        AdvisoryBrokerTest.assertNotNull((Object)m1);
        AdvisoryBrokerTest.assertNotNull((Object)m1.getDataStructure());
        AdvisoryBrokerTest.assertEquals((Object)((ProducerInfo)m1.getDataStructure()).getProducerId(), (Object)producerInfo2.getProducerId());
        this.assertNoMessagesLeft(connection1);
    }

    public static Test suite() {
        return AdvisoryBrokerTest.suite(AdvisoryBrokerTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)AdvisoryBrokerTest.suite());
    }
}

