/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker;

import org.apache.activemq.broker.QueueSubscriptionTest;

public class TopicSubscriptionTest
extends QueueSubscriptionTest {
    protected void setUp() throws Exception {
        super.setUp();
        this.durable = true;
        this.topic = true;
    }

    public void testManyProducersManyConsumers() throws Exception {
        this.consumerCount = 20;
        this.producerCount = 20;
        this.messageCount = 500;
        this.messageSize = 1;
        this.prefetchCount = 10;
        this.doMultipleClientsTest();
        this.assertTotalMessagesReceived(this.messageCount * this.producerCount * this.consumerCount);
    }

    public void testOneProducerTwoConsumersLargeMessagesOnePrefetch() throws Exception {
        this.consumerCount = 2;
        this.producerCount = 1;
        this.messageCount = 10;
        this.messageSize = 0x100000;
        this.prefetchCount = 1;
        this.doMultipleClientsTest();
        this.assertTotalMessagesReceived(this.messageCount * this.consumerCount * this.producerCount);
    }

    public void testOneProducerTwoConsumersSmallMessagesOnePrefetch() throws Exception {
        this.consumerCount = 2;
        this.producerCount = 1;
        this.prefetchCount = 1;
        this.messageSize = 1024;
        this.messageCount = 1000;
        this.doMultipleClientsTest();
        this.assertTotalMessagesReceived(this.messageCount * this.consumerCount * this.producerCount);
    }

    public void testOneProducerTwoConsumersSmallMessagesLargePrefetch() throws Exception {
        this.consumerCount = 2;
        this.producerCount = 1;
        this.messageCount = 1000;
        this.messageSize = 1024;
        this.prefetchCount = this.messageCount * 2;
        this.doMultipleClientsTest();
        this.assertTotalMessagesReceived(this.messageCount * this.consumerCount * this.producerCount);
    }

    public void testOneProducerTwoConsumersLargeMessagesLargePrefetch() throws Exception {
        this.consumerCount = 2;
        this.producerCount = 1;
        this.messageCount = 10;
        this.messageSize = 0x100000;
        this.prefetchCount = this.messageCount * 2;
        this.doMultipleClientsTest();
        this.assertTotalMessagesReceived(this.messageCount * this.consumerCount * this.producerCount);
    }

    public void testOneProducerManyConsumersFewMessages() throws Exception {
        this.consumerCount = 50;
        this.producerCount = 1;
        this.messageCount = 10;
        this.messageSize = 1;
        this.prefetchCount = 10;
        this.doMultipleClientsTest();
        this.assertTotalMessagesReceived(this.messageCount * this.consumerCount * this.producerCount);
    }

    public void testOneProducerManyConsumersManyMessages() throws Exception {
        this.consumerCount = 50;
        this.producerCount = 1;
        this.messageCount = 100;
        this.messageSize = 1;
        this.prefetchCount = 10;
        this.doMultipleClientsTest();
        this.assertTotalMessagesReceived(this.messageCount * this.consumerCount * this.producerCount);
    }

    public void testManyProducersOneConsumer() throws Exception {
        this.consumerCount = 1;
        this.producerCount = 20;
        this.messageCount = 100;
        this.messageSize = 1;
        this.prefetchCount = 10;
        this.doMultipleClientsTest();
        this.assertTotalMessagesReceived(this.messageCount * this.producerCount * this.consumerCount);
    }
}

