/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker;

import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.apache.activemq.spring.SpringConsumer;
import org.apache.activemq.spring.SpringProducer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringTest
extends TestCase {
    private static final Log log = LogFactory.getLog((Class)SpringTest.class);
    protected AbstractApplicationContext context;
    protected SpringConsumer consumer;
    protected SpringProducer producer;

    public void testSenderWithSpringXml() throws Exception {
        this.assertSenderConfig("org/apache/activemq/broker/spring.xml");
    }

    protected void assertSenderConfig(String config) throws Exception {
        this.context = new ClassPathXmlApplicationContext(config);
        this.consumer = (SpringConsumer)((Object)this.context.getBean("consumer"));
        SpringTest.assertTrue((String)"Found a valid consumer", (this.consumer != null ? 1 : 0) != 0);
        this.consumer.start();
        this.producer = (SpringProducer)this.context.getBean("producer");
        SpringTest.assertTrue((String)"Found a valid producer", (this.producer != null ? 1 : 0) != 0);
        this.consumer.flushMessages();
        this.producer.start();
        this.consumer.waitForMessagesToArrive(this.producer.getMessageCount());
        List messages = this.consumer.flushMessages();
        log.info((Object)"Consumer has received messages....");
        Iterator iter = messages.iterator();
        while (iter.hasNext()) {
            Object message = iter.next();
            log.info((Object)("Received: " + message));
        }
        SpringTest.assertEquals((String)"Message count", (int)this.producer.getMessageCount(), (int)messages.size());
    }

    protected void tearDown() throws Exception {
        if (this.consumer != null) {
            this.consumer.stop();
        }
        if (this.producer != null) {
            this.producer.stop();
        }
        if (this.context != null) {
            this.context.destroy();
        }
    }
}

