/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerPlugin;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.util.UDPTraceBrokerPlugin;
import org.apache.activemq.broker.view.ConnectionDotFilePlugin;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.demo.DefaultQueueSender;

public class Main {
    public static void main(String[] args) {
        String brokerURI = "broker:(tcp://localhost:61616,stomp://localhost:61613)?persistent=false&useJmx=true";
        if (args.length > 0) {
            brokerURI = args[0];
        }
        try {
            BrokerService broker = new BrokerService();
            broker.setPersistent(false);
            broker.setUseJmx(true);
            broker.setPlugins(new BrokerPlugin[]{new ConnectionDotFilePlugin(), new UDPTraceBrokerPlugin()});
            broker.addConnector("tcp://localhost:61616");
            broker.addConnector("stomp://localhost:61613");
            broker.start();
            Connection connection = new ActiveMQConnectionFactory().createConnection();
            connection.start();
            Session session = connection.createSession(false, 1);
            MessageConsumer consumer1 = session.createConsumer((Destination)new ActiveMQQueue("Orders.IBM"));
            MessageConsumer consumer2 = session.createConsumer((Destination)new ActiveMQQueue("Orders.MSFT"), "price > 100");
            Session session2 = connection.createSession(false, 1);
            MessageConsumer consumer3 = session2.createConsumer((Destination)new ActiveMQQueue("Orders.MSFT"), "price > 200");
            DefaultQueueSender.main(new String[]{"Prices.Equity.IBM"});
            DefaultQueueSender.main(new String[]{"Prices.Equity.MSFT"});
        }
        catch (Exception e) {
            System.out.println("Failed: " + e);
            e.printStackTrace();
        }
    }
}

