/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQPrefetchPolicy;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.test.JmsResourceProvider;
import org.apache.activemq.test.TestSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class JmsTransactionTestSupport
extends TestSupport
implements MessageListener {
    private static final Log log = LogFactory.getLog((Class)JmsTransactionTestSupport.class);
    protected ConnectionFactory connectionFactory;
    protected Connection connection;
    protected Session session;
    protected MessageConsumer consumer;
    protected MessageProducer producer;
    protected JmsResourceProvider resourceProvider;
    protected Destination destination;
    private final int messageCount = 5;
    private final String messageText = "message";
    private List unackMessages = new ArrayList(5);
    private List ackMessages = new ArrayList(5);
    private boolean resendPhase = false;
    protected int batchCount = 10;
    protected int batchSize = 20;
    protected BrokerService broker;

    public JmsTransactionTestSupport() {
    }

    public JmsTransactionTestSupport(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.broker = this.createBroker();
        this.broker.start();
        this.resourceProvider = this.getJmsResourceProvider();
        this.topic = this.resourceProvider.isTopic();
        this.resourceProvider.setTransacted(true);
        this.connectionFactory = this.resourceProvider.createConnectionFactory();
        this.reconnect();
    }

    protected BrokerService createBroker() throws Exception, URISyntaxException {
        return BrokerFactory.createBroker((URI)new URI("broker://()/localhost?persistent=false"));
    }

    protected void tearDown() throws Exception {
        log.info((Object)"Closing down connection");
        this.session.close();
        this.session = null;
        this.connection.close();
        this.connection = null;
        this.broker.stop();
        this.broker = null;
        log.info((Object)"Connection closed.");
    }

    protected abstract JmsResourceProvider getJmsResourceProvider();

    public void testSendReceiveTransactedBatches() throws Exception {
        TextMessage message = this.session.createTextMessage("Batch Message");
        for (int j = 0; j < this.batchCount; ++j) {
            int i;
            log.info((Object)("Producing bacth " + j + " of " + this.batchSize + " messages"));
            for (i = 0; i < this.batchSize; ++i) {
                this.producer.send((Message)message);
            }
            this.session.commit();
            log.info((Object)("Consuming bacth " + j + " of " + this.batchSize + " messages"));
            for (i = 0; i < this.batchSize; ++i) {
                message = (TextMessage)this.consumer.receive(5000L);
                JmsTransactionTestSupport.assertNotNull((String)("Received only " + i + " messages in batch " + j), (Object)message);
                JmsTransactionTestSupport.assertEquals((String)"Batch Message", (String)message.getText());
            }
            this.session.commit();
        }
    }

    public void testSendRollback() throws Exception {
        Message[] outbound = new Message[]{this.session.createTextMessage("First Message"), this.session.createTextMessage("Second Message")};
        this.producer.send(outbound[0]);
        this.session.commit();
        this.producer.send((Message)this.session.createTextMessage("I'm going to get rolled back."));
        this.session.rollback();
        this.producer.send(outbound[1]);
        this.session.commit();
        ArrayList<Message> messages = new ArrayList<Message>();
        log.info((Object)"About to consume message 1");
        Message message = this.consumer.receive(1000L);
        messages.add(message);
        log.info((Object)("Received: " + message));
        log.info((Object)"About to consume message 2");
        message = this.consumer.receive(4000L);
        messages.add(message);
        log.info((Object)("Received: " + message));
        this.session.commit();
        Message[] inbound = new Message[messages.size()];
        messages.toArray(inbound);
        this.assertTextMessagesEqual("Rollback did not work.", outbound, inbound);
    }

    public void testSendSessionClose() throws Exception {
        Message[] outbound = new Message[]{this.session.createTextMessage("First Message"), this.session.createTextMessage("Second Message")};
        this.producer.send(outbound[0]);
        this.session.commit();
        this.producer.send((Message)this.session.createTextMessage("I'm going to get rolled back."));
        this.consumer.close();
        this.reconnectSession();
        this.producer.send(outbound[1]);
        this.session.commit();
        ArrayList<Message> messages = new ArrayList<Message>();
        log.info((Object)"About to consume message 1");
        Message message = this.consumer.receive(1000L);
        messages.add(message);
        log.info((Object)("Received: " + message));
        log.info((Object)"About to consume message 2");
        message = this.consumer.receive(4000L);
        messages.add(message);
        log.info((Object)("Received: " + message));
        this.session.commit();
        Message[] inbound = new Message[messages.size()];
        messages.toArray(inbound);
        this.assertTextMessagesEqual("Rollback did not work.", outbound, inbound);
    }

    public void testSendSessionAndConnectionClose() throws Exception {
        Message[] outbound = new Message[]{this.session.createTextMessage("First Message"), this.session.createTextMessage("Second Message")};
        this.producer.send(outbound[0]);
        this.session.commit();
        this.producer.send((Message)this.session.createTextMessage("I'm going to get rolled back."));
        this.consumer.close();
        this.session.close();
        this.reconnect();
        this.producer.send(outbound[1]);
        this.session.commit();
        ArrayList<Message> messages = new ArrayList<Message>();
        log.info((Object)"About to consume message 1");
        Message message = this.consumer.receive(1000L);
        messages.add(message);
        log.info((Object)("Received: " + message));
        log.info((Object)"About to consume message 2");
        message = this.consumer.receive(4000L);
        messages.add(message);
        log.info((Object)("Received: " + message));
        this.session.commit();
        Message[] inbound = new Message[messages.size()];
        messages.toArray(inbound);
        this.assertTextMessagesEqual("Rollback did not work.", outbound, inbound);
    }

    public void testReceiveRollback() throws Exception {
        Message[] outbound = new Message[]{this.session.createTextMessage("First Message"), this.session.createTextMessage("Second Message")};
        while (this.consumer.receive(1000L) != null) {
        }
        this.session.commit();
        this.producer.send(outbound[0]);
        this.producer.send(outbound[1]);
        this.session.commit();
        log.info((Object)("Sent 0: " + outbound[0]));
        log.info((Object)("Sent 1: " + outbound[1]));
        ArrayList<Message> messages = new ArrayList<Message>();
        Message message = this.consumer.receive(1000L);
        messages.add(message);
        this.assertEquals(outbound[0], message);
        this.session.commit();
        message = this.consumer.receive(1000L);
        JmsTransactionTestSupport.assertNotNull((Object)message);
        this.assertEquals(outbound[1], message);
        this.session.rollback();
        message = this.consumer.receive(5000L);
        JmsTransactionTestSupport.assertNotNull((String)"Should have re-received the message again!", (Object)message);
        messages.add(message);
        this.session.commit();
        Message[] inbound = new Message[messages.size()];
        messages.toArray(inbound);
        this.assertTextMessagesEqual("Rollback did not work", outbound, inbound);
    }

    public void testReceiveTwoThenRollback() throws Exception {
        Message[] outbound = new Message[]{this.session.createTextMessage("First Message"), this.session.createTextMessage("Second Message")};
        while (this.consumer.receive(1000L) != null) {
        }
        this.session.commit();
        this.producer.send(outbound[0]);
        this.producer.send(outbound[1]);
        this.session.commit();
        log.info((Object)("Sent 0: " + outbound[0]));
        log.info((Object)("Sent 1: " + outbound[1]));
        ArrayList<Message> messages = new ArrayList<Message>();
        Message message = this.consumer.receive(1000L);
        this.assertEquals(outbound[0], message);
        message = this.consumer.receive(1000L);
        JmsTransactionTestSupport.assertNotNull((Object)message);
        this.assertEquals(outbound[1], message);
        this.session.rollback();
        message = this.consumer.receive(5000L);
        JmsTransactionTestSupport.assertNotNull((String)"Should have re-received the first message again!", (Object)message);
        messages.add(message);
        this.assertEquals(outbound[0], message);
        message = this.consumer.receive(5000L);
        JmsTransactionTestSupport.assertNotNull((String)"Should have re-received the second message again!", (Object)message);
        messages.add(message);
        this.assertEquals(outbound[1], message);
        JmsTransactionTestSupport.assertNull((Object)this.consumer.receiveNoWait());
        this.session.commit();
        Message[] inbound = new Message[messages.size()];
        messages.toArray(inbound);
        this.assertTextMessagesEqual("Rollback did not work", outbound, inbound);
    }

    public void testSendReceiveWithPrefetchOne() throws Exception {
        int i;
        this.setPrefetchToOne();
        Message[] outbound = new Message[]{this.session.createTextMessage("First Message"), this.session.createTextMessage("Second Message"), this.session.createTextMessage("Third Message"), this.session.createTextMessage("Fourth Message")};
        for (i = 0; i < outbound.length; ++i) {
            this.producer.send(outbound[i]);
        }
        this.session.commit();
        for (i = 0; i < outbound.length; ++i) {
            log.info((Object)"About to consume message 1");
            Message message = this.consumer.receive(1000L);
            JmsTransactionTestSupport.assertNotNull((Object)message);
            log.info((Object)("Received: " + message));
        }
        this.session.commit();
    }

    public void testReceiveTwoThenRollbackManyTimes() throws Exception {
        for (int i = 0; i < 5; ++i) {
            this.testReceiveTwoThenRollback();
        }
    }

    public void testSendRollbackWithPrefetchOfOne() throws Exception {
        this.setPrefetchToOne();
        this.testSendRollback();
    }

    public void testReceiveRollbackWithPrefetchOfOne() throws Exception {
        this.setPrefetchToOne();
        this.testReceiveRollback();
    }

    public void testCloseConsumerBeforeCommit() throws Exception {
        TextMessage[] outbound = new TextMessage[]{this.session.createTextMessage("First Message"), this.session.createTextMessage("Second Message")};
        while (this.consumer.receiveNoWait() != null) {
        }
        this.session.commit();
        this.producer.send((Message)outbound[0]);
        this.producer.send((Message)outbound[1]);
        this.session.commit();
        log.info((Object)("Sent 0: " + outbound[0]));
        log.info((Object)("Sent 1: " + outbound[1]));
        TextMessage message = (TextMessage)this.consumer.receive(1000L);
        JmsTransactionTestSupport.assertEquals((String)outbound[0].getText(), (String)message.getText());
        this.consumer.close();
        this.session.commit();
        this.consumer = this.resourceProvider.createConsumer(this.session, this.destination);
        log.info((Object)("Created consumer: " + this.consumer));
        message = (TextMessage)this.consumer.receive(1000L);
        JmsTransactionTestSupport.assertEquals((String)outbound[1].getText(), (String)message.getText());
        this.session.commit();
    }

    public void testChangeMutableObjectInObjectMessageThenRollback() throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        list.add("First");
        ObjectMessage outbound = this.session.createObjectMessage(list);
        outbound.setStringProperty("foo", "abc");
        this.producer.send((Message)outbound);
        this.session.commit();
        log.info((Object)"About to consume message 1");
        Message message = this.consumer.receive(5000L);
        List body = this.assertReceivedObjectMessageWithListBody(message);
        try {
            message.setStringProperty("foo", "def");
            JmsTransactionTestSupport.fail((String)"Cannot change properties of the object!");
        }
        catch (JMSException e) {
            log.info((Object)("Caught expected exception: " + (Object)((Object)e)), (Throwable)e);
        }
        body.clear();
        body.add("This should never be seen!");
        this.session.rollback();
        message = this.consumer.receive(5000L);
        List secondBody = this.assertReceivedObjectMessageWithListBody(message);
        JmsTransactionTestSupport.assertNotSame((String)"Second call should return a different body", (Object)secondBody, (Object)body);
        this.session.commit();
    }

    protected List assertReceivedObjectMessageWithListBody(Message message) throws JMSException {
        JmsTransactionTestSupport.assertNotNull((String)"Should have received a message!", (Object)message);
        JmsTransactionTestSupport.assertEquals((String)"foo header", (String)"abc", (String)message.getStringProperty("foo"));
        JmsTransactionTestSupport.assertTrue((String)("Should be an object message but was: " + message), (boolean)(message instanceof ObjectMessage));
        ObjectMessage objectMessage = (ObjectMessage)message;
        List body = (List)((Object)objectMessage.getObject());
        log.info((Object)("Received body: " + body));
        JmsTransactionTestSupport.assertEquals((String)"Size of list should be 1", (int)1, (int)body.size());
        JmsTransactionTestSupport.assertEquals((String)"element 0 of list", (Object)"First", body.get(0));
        return body;
    }

    protected void reconnect() throws JMSException {
        if (this.connection != null) {
            this.connection.close();
        }
        this.session = null;
        this.connection = this.resourceProvider.createConnection(this.connectionFactory);
        this.reconnectSession();
        this.connection.start();
    }

    protected void reconnectSession() throws JMSException {
        if (this.session != null) {
            this.session.close();
        }
        this.session = this.resourceProvider.createSession(this.connection);
        this.destination = this.resourceProvider.createDestination(this.session, this.getSubject());
        this.producer = this.resourceProvider.createProducer(this.session, this.destination);
        this.consumer = this.resourceProvider.createConsumer(this.session, this.destination);
    }

    protected void setPrefetchToOne() {
        ActiveMQPrefetchPolicy prefetchPolicy = ((ActiveMQConnection)this.connection).getPrefetchPolicy();
        prefetchPolicy.setQueuePrefetch(1);
        prefetchPolicy.setTopicPrefetch(1);
        prefetchPolicy.setDurableTopicPrefetch(1);
        prefetchPolicy.setOptimizeDurableTopicPrefetch(1);
    }

    public void testMessageListener() throws Exception {
        for (int i = 0; i < 5; ++i) {
            this.producer.send((Message)this.session.createTextMessage("message" + i));
        }
        this.session.commit();
        this.consumer.setMessageListener((MessageListener)this);
        this.waitReceiveUnack();
        JmsTransactionTestSupport.assertEquals((int)this.unackMessages.size(), (int)5);
        this.waitReceiveAck();
        JmsTransactionTestSupport.assertEquals((int)this.ackMessages.size(), (int)5);
        this.consumer.setMessageListener(null);
        JmsTransactionTestSupport.assertNull((Object)this.consumer.receive(500L));
        this.reconnect();
    }

    public void onMessage(Message message) {
        if (!this.resendPhase) {
            this.unackMessages.add(message);
            if (this.unackMessages.size() == 5) {
                try {
                    this.session.rollback();
                    this.resendPhase = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            this.ackMessages.add(message);
            if (this.ackMessages.size() == 5) {
                try {
                    this.session.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void waitReceiveUnack() throws Exception {
        for (int i = 0; i < 100 && !this.resendPhase; ++i) {
            Thread.sleep(100L);
        }
        JmsTransactionTestSupport.assertTrue((boolean)this.resendPhase);
    }

    private void waitReceiveAck() throws Exception {
        for (int i = 0; i < 100 && this.ackMessages.size() < 5; ++i) {
            Thread.sleep(100L);
        }
        JmsTransactionTestSupport.assertFalse((this.ackMessages.size() < 5 ? 1 : 0) != 0);
    }
}

