/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.activemq.TestSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JmsTopicSelectorTest
extends TestSupport {
    private static final Log log = LogFactory.getLog((Class)JmsTopicSelectorTest.class);
    protected Connection connection;
    protected Session session;
    protected MessageConsumer consumer;
    protected MessageProducer producer;
    protected Destination consumerDestination;
    protected Destination producerDestination;
    protected boolean topic = true;
    protected boolean durable = false;
    protected int deliveryMode = 2;

    public JmsTopicSelectorTest() {
    }

    public JmsTopicSelectorTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.connectionFactory = this.createConnectionFactory();
        this.connection = this.createConnection();
        if (this.durable) {
            this.connection.setClientID(((Object)((Object)this)).getClass().getName());
        }
        log.info((Object)("Created connection: " + this.connection));
        this.session = this.connection.createSession(false, 1);
        log.info((Object)("Created session: " + this.session));
        if (this.topic) {
            this.consumerDestination = this.session.createTopic(this.getConsumerSubject());
            this.producerDestination = this.session.createTopic(this.getProducerSubject());
        } else {
            this.consumerDestination = this.session.createQueue(this.getConsumerSubject());
            this.producerDestination = this.session.createQueue(this.getProducerSubject());
        }
        log.info((Object)("Created  consumer destination: " + this.consumerDestination + " of type: " + this.consumerDestination.getClass()));
        log.info((Object)("Created  producer destination: " + this.producerDestination + " of type: " + this.producerDestination.getClass()));
        this.producer = this.session.createProducer(this.producerDestination);
        this.producer.setDeliveryMode(this.deliveryMode);
        log.info((Object)("Created producer: " + this.producer + " delivery mode = " + (this.deliveryMode == 2 ? "PERSISTENT" : "NON_PERSISTENT")));
        this.connection.start();
    }

    public void tearDown() throws Exception {
        this.session.close();
        this.connection.close();
    }

    protected MessageConsumer createConsumer(String selector) throws JMSException {
        if (this.durable) {
            log.info((Object)"Creating durable consumer");
            return this.session.createDurableSubscriber((Topic)this.consumerDestination, this.getName(), selector, false);
        }
        return this.session.createConsumer(this.consumerDestination, selector);
    }

    public void sendMessages() throws Exception {
        TextMessage message = this.session.createTextMessage("1");
        message.setIntProperty("id", 1);
        message.setJMSType("a");
        message.setStringProperty("stringProperty", "a");
        message.setLongProperty("longProperty", 1L);
        message.setBooleanProperty("booleanProperty", true);
        this.producer.send((Message)message);
        message = this.session.createTextMessage("2");
        message.setIntProperty("id", 2);
        message.setJMSType("a");
        message.setStringProperty("stringProperty", "a");
        message.setLongProperty("longProperty", 1L);
        message.setBooleanProperty("booleanProperty", false);
        this.producer.send((Message)message);
        message = this.session.createTextMessage("3");
        message.setIntProperty("id", 3);
        message.setJMSType("a");
        message.setStringProperty("stringProperty", "a");
        message.setLongProperty("longProperty", 1L);
        message.setBooleanProperty("booleanProperty", true);
        this.producer.send((Message)message);
        message = this.session.createTextMessage("4");
        message.setIntProperty("id", 4);
        message.setJMSType("b");
        message.setStringProperty("stringProperty", "b");
        message.setLongProperty("longProperty", 2L);
        message.setBooleanProperty("booleanProperty", false);
        this.producer.send((Message)message);
        message = this.session.createTextMessage("5");
        message.setIntProperty("id", 5);
        message.setJMSType("c");
        message.setStringProperty("stringProperty", "c");
        message.setLongProperty("longProperty", 3L);
        message.setBooleanProperty("booleanProperty", true);
        this.producer.send((Message)message);
    }

    public void consumeMessages(int remaining) throws Exception {
        this.consumer = this.createConsumer(null);
        for (int i = 0; i < remaining; ++i) {
            this.consumer.receive(1000L);
        }
        this.consumer.close();
    }

    public void testPropertySelector() throws Exception {
        int remaining = 5;
        Message message = null;
        this.consumer = this.createConsumer("stringProperty = 'a' and longProperty = 1 and booleanProperty = true");
        this.sendMessages();
        while ((message = this.consumer.receive(1000L)) != null) {
            String text = ((TextMessage)message).getText();
            if (!text.equals("1") && !text.equals("3")) {
                JmsTopicSelectorTest.fail((String)("unexpected message: " + text));
            }
            --remaining;
        }
        JmsTopicSelectorTest.assertEquals((int)remaining, (int)3);
        this.consumer.close();
        this.consumeMessages(remaining);
    }

    public void testJMSPropertySelector() throws Exception {
        int remaining = 5;
        Message message = null;
        this.consumer = this.createConsumer("JMSType = 'a' and stringProperty = 'a'");
        this.sendMessages();
        while ((message = this.consumer.receive(1000L)) != null) {
            String text = ((TextMessage)message).getText();
            if (!(text.equals("1") || text.equals("2") || text.equals("3"))) {
                JmsTopicSelectorTest.fail((String)("unexpected message: " + text));
            }
            --remaining;
        }
        JmsTopicSelectorTest.assertEquals((int)remaining, (int)2);
        this.consumer.close();
        this.consumeMessages(remaining);
    }
}

