/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import edu.emory.mathcs.backport.java.util.concurrent.CountDownLatch;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;

public class JmsSessionRecoverTest
extends TestCase {
    private Connection connection;
    private ActiveMQConnectionFactory factory;
    private Destination dest;

    protected void setUp() throws Exception {
        this.factory = new ActiveMQConnectionFactory("vm://localhost?broker.persistent=false");
        this.connection = this.factory.createConnection();
    }

    protected void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
    }

    public void testQueueSynchRecover() throws JMSException, InterruptedException {
        this.dest = new ActiveMQQueue("Queue-" + System.currentTimeMillis());
        this.doTestSynchRecover();
    }

    public void testQueueAsynchRecover() throws JMSException, InterruptedException {
        this.dest = new ActiveMQQueue("Queue-" + System.currentTimeMillis());
        this.doTestAsynchRecover();
    }

    public void testTopicSynchRecover() throws JMSException, InterruptedException {
        this.dest = new ActiveMQTopic("Topic-" + System.currentTimeMillis());
        this.doTestSynchRecover();
    }

    public void testTopicAsynchRecover() throws JMSException, InterruptedException {
        this.dest = new ActiveMQTopic("Topic-" + System.currentTimeMillis());
        this.doTestAsynchRecover();
    }

    public void testQueueAsynchRecoverWithAutoAck() throws JMSException, InterruptedException {
        this.dest = new ActiveMQQueue("Queue-" + System.currentTimeMillis());
        this.doTestAsynchRecoverWithAutoAck();
    }

    public void testTopicAsynchRecoverWithAutoAck() throws JMSException, InterruptedException {
        this.dest = new ActiveMQTopic("Topic-" + System.currentTimeMillis());
        this.doTestAsynchRecoverWithAutoAck();
    }

    public void doTestSynchRecover() throws JMSException {
        Session session = this.connection.createSession(false, 2);
        MessageConsumer consumer = session.createConsumer(this.dest);
        this.connection.start();
        MessageProducer producer = session.createProducer(this.dest);
        producer.setDeliveryMode(1);
        producer.send((Message)session.createTextMessage("First"));
        producer.send((Message)session.createTextMessage("Second"));
        TextMessage message = (TextMessage)consumer.receive(1000L);
        JmsSessionRecoverTest.assertEquals((String)"First", (String)message.getText());
        JmsSessionRecoverTest.assertFalse((boolean)message.getJMSRedelivered());
        message.acknowledge();
        message = (TextMessage)consumer.receive(1000L);
        JmsSessionRecoverTest.assertEquals((String)"Second", (String)message.getText());
        JmsSessionRecoverTest.assertFalse((boolean)message.getJMSRedelivered());
        session.recover();
        message = (TextMessage)consumer.receive(2000L);
        JmsSessionRecoverTest.assertEquals((String)"Second", (String)message.getText());
        JmsSessionRecoverTest.assertTrue((boolean)message.getJMSRedelivered());
        message.acknowledge();
    }

    public void doTestAsynchRecover() throws JMSException, InterruptedException {
        final Session session = this.connection.createSession(false, 2);
        final String[] errorMessage = new String[]{null};
        final CountDownLatch doneCountDownLatch = new CountDownLatch(1);
        MessageConsumer consumer = session.createConsumer(this.dest);
        MessageProducer producer = session.createProducer(this.dest);
        producer.setDeliveryMode(1);
        producer.send((Message)session.createTextMessage("First"));
        producer.send((Message)session.createTextMessage("Second"));
        consumer.setMessageListener(new MessageListener(){
            int counter;

            public void onMessage(Message msg) {
                ++this.counter;
                try {
                    TextMessage message = (TextMessage)msg;
                    switch (this.counter) {
                        case 1: {
                            Assert.assertEquals((String)"First", (String)message.getText());
                            Assert.assertFalse((boolean)message.getJMSRedelivered());
                            message.acknowledge();
                            break;
                        }
                        case 2: {
                            Assert.assertEquals((String)"Second", (String)message.getText());
                            Assert.assertFalse((boolean)message.getJMSRedelivered());
                            session.recover();
                            break;
                        }
                        case 3: {
                            Assert.assertEquals((String)"Second", (String)message.getText());
                            Assert.assertTrue((boolean)message.getJMSRedelivered());
                            message.acknowledge();
                            doneCountDownLatch.countDown();
                            break;
                        }
                        default: {
                            errorMessage[0] = "Got too many messages: " + this.counter;
                            doneCountDownLatch.countDown();
                            break;
                        }
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    errorMessage[0] = "Got exception: " + e;
                    doneCountDownLatch.countDown();
                }
            }
        });
        this.connection.start();
        if (doneCountDownLatch.await(5L, TimeUnit.SECONDS)) {
            if (errorMessage[0] != null) {
                JmsSessionRecoverTest.fail((String)errorMessage[0]);
            }
        } else {
            JmsSessionRecoverTest.fail((String)"Timeout waiting for async message delivery to complete.");
        }
    }

    public void doTestAsynchRecoverWithAutoAck() throws JMSException, InterruptedException {
        final Session session = this.connection.createSession(false, 1);
        final String[] errorMessage = new String[]{null};
        final CountDownLatch doneCountDownLatch = new CountDownLatch(1);
        MessageConsumer consumer = session.createConsumer(this.dest);
        MessageProducer producer = session.createProducer(this.dest);
        producer.setDeliveryMode(1);
        producer.send((Message)session.createTextMessage("First"));
        producer.send((Message)session.createTextMessage("Second"));
        consumer.setMessageListener(new MessageListener(){
            int counter;

            public void onMessage(Message msg) {
                ++this.counter;
                try {
                    TextMessage message = (TextMessage)msg;
                    switch (this.counter) {
                        case 1: {
                            Assert.assertEquals((String)"First", (String)message.getText());
                            Assert.assertFalse((boolean)message.getJMSRedelivered());
                            break;
                        }
                        case 2: {
                            Assert.assertEquals((String)"Second", (String)message.getText());
                            Assert.assertFalse((boolean)message.getJMSRedelivered());
                            session.recover();
                            break;
                        }
                        case 3: {
                            Assert.assertEquals((String)"Second", (String)message.getText());
                            Assert.assertTrue((boolean)message.getJMSRedelivered());
                            doneCountDownLatch.countDown();
                            break;
                        }
                        default: {
                            errorMessage[0] = "Got too many messages: " + this.counter;
                            doneCountDownLatch.countDown();
                            break;
                        }
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    errorMessage[0] = "Got exception: " + e;
                    doneCountDownLatch.countDown();
                }
            }
        });
        this.connection.start();
        if (doneCountDownLatch.await(5000L, TimeUnit.SECONDS)) {
            if (errorMessage[0] != null) {
                JmsSessionRecoverTest.fail((String)errorMessage[0]);
            }
        } else {
            JmsSessionRecoverTest.fail((String)"Timeout waiting for async message delivery to complete.");
        }
    }
}

