/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.CombinationTestSupport;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.util.MessageIdList;

public class JmsMultipleClientsTestSupport
extends CombinationTestSupport {
    private AtomicInteger producerLock;
    protected Map consumers = new HashMap();
    protected int consumerCount = 1;
    protected int producerCount = 1;
    protected int messageSize = 1024;
    protected boolean useConcurrentSend = true;
    protected boolean durable = false;
    protected boolean topic = false;
    protected boolean persistent = false;
    protected BrokerService broker;
    protected Destination destination;
    protected List connections = Collections.synchronizedList(new ArrayList());
    protected MessageIdList allMessagesList = new MessageIdList();

    protected void startProducers(Destination dest, int msgCount) throws Exception {
        this.startProducers(this.createConnectionFactory(), dest, msgCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startProducers(final ConnectionFactory factory, final Destination dest, final int msgCount) throws Exception {
        if (this.useConcurrentSend) {
            this.producerLock = new AtomicInteger(this.producerCount);
            for (int i = 0; i < this.producerCount; ++i) {
                Thread t = new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            JmsMultipleClientsTestSupport.this.sendMessages(factory.createConnection(), dest, msgCount);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        AtomicInteger atomicInteger = JmsMultipleClientsTestSupport.this.producerLock;
                        synchronized (atomicInteger) {
                            JmsMultipleClientsTestSupport.this.producerLock.decrementAndGet();
                            JmsMultipleClientsTestSupport.this.producerLock.notifyAll();
                        }
                    }
                });
                t.start();
            }
            AtomicInteger i = this.producerLock;
            synchronized (i) {
                while (this.producerLock.get() != 0) {
                    this.producerLock.wait(2000L);
                }
            }
        } else {
            for (int i = 0; i < this.producerCount; ++i) {
                this.sendMessages(factory.createConnection(), dest, msgCount);
            }
        }
    }

    protected void sendMessages(Connection connection, Destination destination, int count) throws Exception {
        connection.start();
        Session session = connection.createSession(false, 1);
        MessageProducer producer = session.createProducer(destination);
        producer.setDeliveryMode(this.persistent ? 2 : 1);
        for (int i = 0; i < count; ++i) {
            TextMessage msg = this.createTextMessage(session, "" + i);
            producer.send((Message)msg);
        }
        producer.close();
        session.close();
        connection.close();
    }

    protected TextMessage createTextMessage(Session session, String initText) throws Exception {
        TextMessage msg = session.createTextMessage();
        if (initText.length() < this.messageSize) {
            char[] data = new char[this.messageSize - initText.length()];
            Arrays.fill(data, '*');
            String str = new String(data);
            msg.setText(initText + str);
        } else {
            msg.setText(initText);
        }
        return msg;
    }

    protected void startConsumers(Destination dest) throws Exception {
        this.startConsumers(this.createConnectionFactory(), dest);
    }

    protected void startConsumers(ConnectionFactory factory, Destination dest) throws Exception {
        for (int i = 0; i < this.consumerCount; ++i) {
            Object consumer = this.durable && this.topic ? this.createDurableSubscriber(factory.createConnection(), dest, "consumer" + (i + 1)) : this.createMessageConsumer(factory.createConnection(), dest);
            MessageIdList list = new MessageIdList();
            list.setParent(this.allMessagesList);
            consumer.setMessageListener((MessageListener)list);
            this.consumers.put(consumer, list);
        }
    }

    protected MessageConsumer createMessageConsumer(Connection conn, Destination dest) throws Exception {
        this.connections.add(conn);
        Session sess = conn.createSession(false, 1);
        MessageConsumer consumer = sess.createConsumer(dest);
        conn.start();
        return consumer;
    }

    protected TopicSubscriber createDurableSubscriber(Connection conn, Destination dest, String name) throws Exception {
        conn.setClientID(name);
        this.connections.add(conn);
        conn.start();
        Session sess = conn.createSession(false, 1);
        TopicSubscriber consumer = sess.createDurableSubscriber((Topic)dest, name);
        return consumer;
    }

    protected void waitForAllMessagesToBeReceived(int messageCount) throws Exception {
        this.allMessagesList.waitForMessagesToArrive(messageCount);
    }

    protected ActiveMQDestination createDestination() throws JMSException {
        if (this.topic) {
            this.destination = new ActiveMQTopic("Topic");
            return (ActiveMQDestination)this.destination;
        }
        this.destination = new ActiveMQQueue("Queue");
        return (ActiveMQDestination)this.destination;
    }

    protected ConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory("vm://localhost");
    }

    protected BrokerService createBroker() throws Exception {
        return BrokerFactory.createBroker((URI)new URI("broker://()/localhost?persistent=false&useJmx=true"));
    }

    protected void setUp() throws Exception {
        super.setAutoFail(true);
        super.setUp();
        this.broker = this.createBroker();
        this.broker.start();
    }

    protected void tearDown() throws Exception {
        Iterator iter = this.connections.iterator();
        while (iter.hasNext()) {
            Connection conn = (Connection)iter.next();
            try {
                conn.close();
            }
            catch (Throwable throwable) {}
        }
        this.broker.stop();
        this.allMessagesList.flushMessages();
        this.consumers.clear();
        super.tearDown();
    }

    protected void assertConsumerReceivedAtLeastXMessages(MessageConsumer consumer, int msgCount) {
        MessageIdList messageIdList = (MessageIdList)((Object)this.consumers.get(consumer));
        messageIdList.assertAtLeastMessagesReceived(msgCount);
    }

    protected void assertConsumerReceivedAtMostXMessages(MessageConsumer consumer, int msgCount) {
        MessageIdList messageIdList = (MessageIdList)((Object)this.consumers.get(consumer));
        messageIdList.assertAtMostMessagesReceived(msgCount);
    }

    protected void assertConsumerReceivedXMessages(MessageConsumer consumer, int msgCount) {
        MessageIdList messageIdList = (MessageIdList)((Object)this.consumers.get(consumer));
        messageIdList.assertMessagesReceivedNoWait(msgCount);
    }

    protected void assertEachConsumerReceivedAtLeastXMessages(int msgCount) {
        Iterator i = this.consumers.keySet().iterator();
        while (i.hasNext()) {
            this.assertConsumerReceivedAtLeastXMessages((MessageConsumer)i.next(), msgCount);
        }
    }

    protected void assertEachConsumerReceivedAtMostXMessages(int msgCount) {
        Iterator i = this.consumers.keySet().iterator();
        while (i.hasNext()) {
            this.assertConsumerReceivedAtMostXMessages((MessageConsumer)i.next(), msgCount);
        }
    }

    protected void assertEachConsumerReceivedXMessages(int msgCount) {
        Iterator i = this.consumers.keySet().iterator();
        while (i.hasNext()) {
            this.assertConsumerReceivedXMessages((MessageConsumer)i.next(), msgCount);
        }
    }

    protected void assertTotalMessagesReceived(int msgCount) {
        this.allMessagesList.assertMessagesReceivedNoWait(msgCount);
        int totalMsg = 0;
        Iterator i = this.consumers.keySet().iterator();
        while (i.hasNext()) {
            MessageIdList messageIdList = (MessageIdList)((Object)this.consumers.get(i.next()));
            totalMsg += messageIdList.getMessageCount();
        }
        JmsMultipleClientsTestSupport.assertEquals((String)"Total of consumers message count", (int)msgCount, (int)totalMsg);
    }
}

