/*
 * Decompiled with CFR 0.152.
 */
package soot.util;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

class TrustingMonotonicArraySet
extends AbstractSet {
    private static final int DEFAULT_SIZE = 8;
    private int numElements = 0;
    private int maxElements = 8;
    private Object[] elements = new Object[8];

    public TrustingMonotonicArraySet() {
    }

    public TrustingMonotonicArraySet(Object[] elements) {
        this();
        for (Object element : elements) {
            this.add(element);
        }
    }

    public void clear() {
        this.numElements = 0;
    }

    public boolean contains(Object obj) {
        for (int i = 0; i < this.numElements; ++i) {
            if (!this.elements[i].equals(obj)) continue;
            return true;
        }
        return false;
    }

    public boolean add(Object e) {
        if (this.numElements == this.maxElements) {
            this.doubleCapacity();
        }
        this.elements[this.numElements++] = e;
        return true;
    }

    public int size() {
        return this.numElements;
    }

    public Iterator iterator() {
        return new ArrayIterator();
    }

    private void removeElementAt(int index) {
        throw new UnsupportedOperationException();
    }

    private void doubleCapacity() {
        int newSize = this.maxElements * 2;
        Object[] newElements = new Object[newSize];
        System.arraycopy(this.elements, 0, newElements, 0, this.numElements);
        this.elements = newElements;
        this.maxElements = newSize;
    }

    public Object[] toArray() {
        Object[] array = new Object[this.numElements];
        System.arraycopy(this.elements, 0, array, 0, this.numElements);
        return array;
    }

    private class ArrayIterator
    implements Iterator {
        int nextIndex = 0;

        ArrayIterator() {
        }

        public boolean hasNext() {
            return this.nextIndex < TrustingMonotonicArraySet.this.numElements;
        }

        public Object next() throws NoSuchElementException {
            if (this.nextIndex >= TrustingMonotonicArraySet.this.numElements) {
                throw new NoSuchElementException();
            }
            return TrustingMonotonicArraySet.this.elements[this.nextIndex++];
        }

        public void remove() throws NoSuchElementException {
            if (this.nextIndex == 0) {
                throw new NoSuchElementException();
            }
            TrustingMonotonicArraySet.this.removeElementAt(this.nextIndex - 1);
            --this.nextIndex;
        }
    }
}

