/*
 * Decompiled with CFR 0.152.
 */
package soot.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import soot.SootClass;
import soot.util.HashChain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IterableSet
extends HashChain
implements Set {
    public IterableSet(Collection<SootClass> c) {
        this.addAll(c);
    }

    public IterableSet() {
    }

    @Override
    public boolean add(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("Cannot add \"null\" to an IterableSet.");
        }
        if (this.contains(o)) {
            return false;
        }
        return super.add(o);
    }

    @Override
    public boolean remove(Object o) {
        if (o == null || !this.contains(o)) {
            return false;
        }
        return super.remove(o);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof IterableSet)) {
            return false;
        }
        IterableSet other = (IterableSet)o;
        if (this.size() != other.size()) {
            return false;
        }
        Iterator it = this.iterator();
        while (it.hasNext()) {
            if (other.contains(it.next())) continue;
            return false;
        }
        return true;
    }

    public Object clone() {
        IterableSet s = new IterableSet();
        s.addAll(this);
        return s;
    }

    public boolean isSubsetOf(IterableSet other) {
        if (other == null) {
            throw new IllegalArgumentException("Cannot set compare an IterableSet with \"null\".");
        }
        if (this.size() > other.size()) {
            return false;
        }
        Iterator it = this.iterator();
        while (it.hasNext()) {
            if (other.contains(it.next())) continue;
            return false;
        }
        return true;
    }

    public boolean isSupersetOf(IterableSet other) {
        if (other == null) {
            throw new IllegalArgumentException("Cannot set compare an IterableSet with \"null\".");
        }
        if (this.size() < other.size()) {
            return false;
        }
        Iterator it = other.iterator();
        while (it.hasNext()) {
            if (this.contains(it.next())) continue;
            return false;
        }
        return true;
    }

    public boolean isStrictSubsetOf(IterableSet other) {
        if (other == null) {
            throw new IllegalArgumentException("Cannot set compare an IterableSet with \"null\".");
        }
        if (this.size() >= other.size()) {
            return false;
        }
        return this.isSubsetOf(other);
    }

    public boolean isStrictSupersetOf(IterableSet other) {
        if (other == null) {
            throw new IllegalArgumentException("Cannot set compare an IterableSet with \"null\".");
        }
        if (this.size() <= other.size()) {
            return false;
        }
        return this.isSupersetOf(other);
    }

    public boolean intersects(IterableSet other) {
        if (other == null) {
            throw new IllegalArgumentException("Cannot set intersect an IterableSet with \"null\".");
        }
        if (other.size() < this.size()) {
            Iterator it = other.iterator();
            while (it.hasNext()) {
                if (!this.contains(it.next())) continue;
                return true;
            }
        } else {
            Iterator it = this.iterator();
            while (it.hasNext()) {
                if (!other.contains(it.next())) continue;
                return true;
            }
        }
        return false;
    }

    public IterableSet intersection(IterableSet other) {
        if (other == null) {
            throw new IllegalArgumentException("Cannot set intersect an IterableSet with \"null\".");
        }
        IterableSet c = new IterableSet();
        if (other.size() < this.size()) {
            for (Object o : other) {
                if (!this.contains(o)) continue;
                c.add(o);
            }
        } else {
            for (Object o : this) {
                if (!other.contains(o)) continue;
                c.add(o);
            }
        }
        return c;
    }

    public IterableSet union(IterableSet other) {
        if (other == null) {
            throw new IllegalArgumentException("Cannot set union an IterableSet with \"null\".");
        }
        IterableSet c = new IterableSet();
        c.addAll(this);
        c.addAll(other);
        return c;
    }

    @Override
    public String toString() {
        StringBuffer b = new StringBuffer();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            b.append(it.next().toString());
            b.append("\n");
        }
        return b.toString();
    }
}

