/*
 * Decompiled with CFR 0.152.
 */
package soot.util;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

public class EscapedWriter
extends FilterWriter {
    public final String lineSeparator = System.getProperty("line.separator");
    private final int cr = this.lineSeparator.charAt(0);
    private final int lf = this.lineSeparator.length() == 2 ? (int)this.lineSeparator.charAt(1) : -1;
    private final StringBuffer mini = new StringBuffer();

    public EscapedWriter(Writer fos) {
        super(fos);
    }

    public void print(int ch) throws IOException {
        this.write(ch);
        throw new RuntimeException();
    }

    public void write(String s, int off, int len) throws IOException {
        for (int i = off; i < off + len; ++i) {
            this.write(s.charAt(i));
        }
    }

    public void write(int ch) throws IOException {
        if (ch >= 32 && ch <= 126 || ch == this.cr || ch == this.lf || ch == 32) {
            super.write(ch);
            return;
        }
        this.mini.setLength(0);
        this.mini.append(Integer.toHexString(ch));
        while (this.mini.length() < 4) {
            this.mini.insert(0, "0");
        }
        this.mini.insert(0, "\\u");
        for (int i = 0; i < this.mini.length(); ++i) {
            super.write(this.mini.charAt(i));
        }
    }
}

