/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.G;
import soot.Local;
import soot.Timers;
import soot.Unit;
import soot.ValueBox;
import soot.options.Options;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.ArrayPackedSet;
import soot.toolkits.scalar.IntPair;
import soot.toolkits.scalar.LocalDefs;
import soot.toolkits.scalar.LocalDefsFlowAnalysis;
import soot.toolkits.scalar.LocalUnitPair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleLocalDefs
implements LocalDefs {
    Map<LocalUnitPair, List> localUnitPairToDefs;

    public SimpleLocalDefs(UnitGraph g) {
        if (Options.v().time()) {
            Timers.v().defsTimer.start();
        }
        if (Options.v().verbose()) {
            G.v().out.println("[" + g.getBody().getMethod().getName() + "]     Constructing SimpleLocalDefs...");
        }
        LocalDefsFlowAnalysis analysis = new LocalDefsFlowAnalysis(g);
        if (Options.v().time()) {
            Timers.v().defsPostTimer.start();
        }
        Iterator<Unit> unitIt = g.iterator();
        this.localUnitPairToDefs = new HashMap<LocalUnitPair, List>(g.size() * 2 + 1, 0.7f);
        while (unitIt.hasNext()) {
            Unit s = unitIt.next();
            for (ValueBox box : s.getUseBoxes()) {
                Local l;
                LocalUnitPair pair;
                if (!(box.getValue() instanceof Local) || this.localUnitPairToDefs.containsKey(pair = new LocalUnitPair(l = (Local)box.getValue(), s))) continue;
                IntPair intPair = analysis.localToIntPair.get(l);
                ArrayPackedSet value = (ArrayPackedSet)analysis.getFlowBefore(s);
                List unitLocalDefs = value.toList(intPair.op1, intPair.op2);
                this.localUnitPairToDefs.put(pair, Collections.unmodifiableList(unitLocalDefs));
            }
        }
        if (Options.v().time()) {
            Timers.v().defsPostTimer.end();
        }
        if (Options.v().time()) {
            Timers.v().defsTimer.end();
        }
        if (Options.v().verbose()) {
            G.v().out.println("[" + g.getBody().getMethod().getName() + "]     SimpleLocalDefs finished.");
        }
    }

    public boolean hasDefsAt(Local l, Unit s) {
        return this.localUnitPairToDefs.containsKey(new LocalUnitPair(l, s));
    }

    @Override
    public List<Unit> getDefsOfAt(Local l, Unit s) {
        LocalUnitPair pair = new LocalUnitPair(l, s);
        List toReturn = this.localUnitPairToDefs.get(pair);
        if (toReturn == null) {
            throw new RuntimeException("Illegal LocalDefs query; local " + l + " has no definition at " + s.toString());
        }
        return toReturn;
    }
}

