/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.scalar.ArrayPackedSet;
import soot.toolkits.scalar.BoundedFlowSet;
import soot.toolkits.scalar.CollectionFlowUniverse;
import soot.toolkits.scalar.FlowSet;
import soot.toolkits.scalar.ForwardFlowAnalysis;

class SimpleDominatorsAnalysis
extends ForwardFlowAnalysis {
    FlowSet emptySet;
    Map<Object, FlowSet> nodeToGenerateSet;

    SimpleDominatorsAnalysis(DirectedGraph graph) {
        super(graph);
        ArrayList nodes = new ArrayList();
        Iterator nodesIt = graph.iterator();
        while (nodesIt.hasNext()) {
            nodes.add(nodesIt.next());
        }
        CollectionFlowUniverse nodeUniverse = new CollectionFlowUniverse(nodes);
        this.emptySet = new ArrayPackedSet(nodeUniverse);
        this.nodeToGenerateSet = new HashMap<Object, FlowSet>(graph.size() * 2 + 1, 0.7f);
        for (Object s : graph) {
            FlowSet genSet = this.emptySet.clone();
            genSet.add(s, genSet);
            this.nodeToGenerateSet.put(s, genSet);
        }
        this.doAnalysis();
    }

    protected Object newInitialFlow() {
        BoundedFlowSet initSet = (BoundedFlowSet)this.emptySet.clone();
        initSet.complement();
        return initSet;
    }

    protected Object entryInitialFlow() {
        List heads = this.graph.getHeads();
        if (heads.size() != 1) {
            throw new RuntimeException("Assertion failed:  Only one head expected.");
        }
        BoundedFlowSet initSet = (BoundedFlowSet)this.emptySet.clone();
        initSet.add(heads.get(0));
        return initSet;
    }

    protected void flowThrough(Object inValue, Object block, Object outValue) {
        FlowSet in = (FlowSet)inValue;
        FlowSet out = (FlowSet)outValue;
        in.union(this.nodeToGenerateSet.get(block), out);
    }

    protected void merge(Object in1, Object in2, Object out) {
        FlowSet inSet1 = (FlowSet)in1;
        FlowSet inSet2 = (FlowSet)in2;
        FlowSet outSet = (FlowSet)out;
        inSet1.intersection(inSet2, outSet);
    }

    protected void copy(Object source, Object dest) {
        FlowSet sourceSet = (FlowSet)source;
        FlowSet destSet = (FlowSet)dest;
        sourceSet.copy(destSet);
    }
}

