/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.graph;

import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.graph.Orderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PseudoTopologicalOrderer<N>
implements Orderer<N> {
    public static final boolean REVERSE = true;
    private Map<Object, Object> stmtToColor;
    private static final Object GRAY = new Object();
    private LinkedList<N> order;
    private boolean mIsReversed = false;
    private DirectedGraph<N> graph;
    private int[] indexStack;
    private N[] stmtStack;
    private int last;

    public PseudoTopologicalOrderer() {
    }

    @Override
    public List<N> newList(DirectedGraph<N> g, boolean reverse) {
        this.mIsReversed = reverse;
        return this.computeOrder(g);
    }

    protected List<N> computeOrder(DirectedGraph<N> g) {
        this.stmtToColor = new IdentityHashMap<Object, Object>(3 * g.size() / 2);
        this.indexStack = new int[g.size()];
        this.stmtStack = new Object[g.size()];
        this.order = new LinkedList();
        this.graph = g;
        for (N s : g) {
            if (this.stmtToColor.get(s) != null) continue;
            this.visitNode(s);
        }
        this.indexStack = null;
        this.stmtStack = null;
        this.stmtToColor = null;
        return this.order;
    }

    protected void visitNode(N startStmt) {
        this.last = 0;
        this.stmtToColor.put(startStmt, GRAY);
        this.stmtStack[this.last] = startStmt;
        this.indexStack[this.last++] = -1;
        while (this.last > 0) {
            int n = this.last - 1;
            this.indexStack[n] = this.indexStack[n] + 1;
            int toVisitIndex = this.indexStack[n];
            N toVisitNode = this.stmtStack[this.last - 1];
            List<N> succs = this.graph.getSuccsOf(toVisitNode);
            if (toVisitIndex >= succs.size()) {
                if (this.mIsReversed) {
                    this.order.addLast(toVisitNode);
                } else {
                    this.order.addFirst(toVisitNode);
                }
                --this.last;
                continue;
            }
            N childNode = succs.get(toVisitIndex);
            if (this.stmtToColor.get(childNode) != null) continue;
            this.stmtToColor.put(childNode, GRAY);
            this.stmtStack[this.last] = childNode;
            this.indexStack[this.last++] = -1;
        }
    }

    public PseudoTopologicalOrderer(boolean isReversed) {
        this.mIsReversed = isReversed;
    }

    public List<N> newList(DirectedGraph g) {
        return this.computeOrder(g);
    }

    public void setReverseOrder(boolean isReversed) {
        this.mIsReversed = isReversed;
    }

    public boolean isReverseOrder() {
        return this.mIsReversed;
    }
}

