/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.graph;

import java.util.List;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.graph.HashMutableDirectedGraph;
import soot.toolkits.graph.ReversibleGraph;

public class HashReversibleGraph
extends HashMutableDirectedGraph
implements ReversibleGraph {
    protected boolean reversed = false;

    public HashReversibleGraph(DirectedGraph dg) {
        this();
        for (Object s : dg) {
            this.addNode(s);
        }
        for (Object s : dg) {
            List succs = dg.getSuccsOf(s);
            for (Object t : succs) {
                this.addEdge(s, t);
            }
        }
        this.heads.clear();
        this.heads.addAll(dg.getHeads());
        this.tails.clear();
        this.tails.addAll(dg.getTails());
    }

    public HashReversibleGraph() {
    }

    public boolean isReversed() {
        return this.reversed;
    }

    public ReversibleGraph reverse() {
        this.reversed = !this.reversed;
        return this;
    }

    public void addEdge(Object from, Object to) {
        if (this.reversed) {
            super.addEdge(to, from);
        } else {
            super.addEdge(from, to);
        }
    }

    public void removeEdge(Object from, Object to) {
        if (this.reversed) {
            super.removeEdge(to, from);
        } else {
            super.removeEdge(from, to);
        }
    }

    public boolean containsEdge(Object from, Object to) {
        return this.reversed ? super.containsEdge(to, from) : super.containsEdge(from, to);
    }

    public List getHeads() {
        return this.reversed ? super.getTails() : super.getHeads();
    }

    public List getTails() {
        return this.reversed ? super.getHeads() : super.getTails();
    }

    public List getPredsOf(Object s) {
        return this.reversed ? super.getSuccsOf(s) : super.getPredsOf(s);
    }

    public List getSuccsOf(Object s) {
        return this.reversed ? super.getPredsOf(s) : super.getSuccsOf(s);
    }
}

