/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.Body;
import soot.Trap;
import soot.Unit;
import soot.toolkits.graph.Block;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.graph.UnitGraph;
import soot.util.Chain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BlockGraph
implements DirectedGraph<Block> {
    Body mBody;
    Chain<Unit> mUnits;
    List<Block> mBlocks;
    List<Block> mHeads = new ArrayList<Block>();
    List<Block> mTails = new ArrayList<Block>();

    protected BlockGraph(UnitGraph unitGraph) {
        this.mBody = unitGraph.getBody();
        this.mUnits = this.mBody.getUnits();
        Set<Unit> leaders = this.computeLeaders(unitGraph);
        this.buildBlocks(leaders, unitGraph);
    }

    protected Set<Unit> computeLeaders(UnitGraph unitGraph) {
        Body body = unitGraph.getBody();
        if (body != this.mBody) {
            throw new RuntimeException("BlockGraph.computeLeaders() called with a UnitGraph that doesn't match its mBody.");
        }
        HashSet<Unit> leaders = new HashSet<Unit>();
        Chain<Trap> traps = body.getTraps();
        for (Trap trap : traps) {
            leaders.add(trap.getHandlerUnit());
        }
        for (Unit u : body.getUnits()) {
            List<Unit> predecessors = unitGraph.getPredsOf(u);
            int predCount = predecessors.size();
            List<Unit> successors = unitGraph.getSuccsOf(u);
            int succCount = successors.size();
            if (predCount != 1) {
                leaders.add(u);
            }
            if (succCount <= 1 && !u.branches()) continue;
            Iterator<Unit> it = successors.iterator();
            while (it.hasNext()) {
                leaders.add(it.next());
            }
        }
        return leaders;
    }

    protected Map<Unit, Block> buildBlocks(Set<Unit> leaders, UnitGraph unitGraph) {
        ArrayList<Block> blockList = new ArrayList<Block>(leaders.size());
        HashMap<Unit, Block> unitToBlock = new HashMap<Unit, Block>();
        Unit blockHead = null;
        int blockLength = 0;
        Iterator<Unit> unitIt = this.mUnits.iterator();
        if (unitIt.hasNext()) {
            blockHead = unitIt.next();
            if (!leaders.contains(blockHead)) {
                throw new RuntimeException("BlockGraph: first unit not a leader!");
            }
            ++blockLength;
        }
        Unit blockTail = blockHead;
        int indexInMethod = 0;
        while (unitIt.hasNext()) {
            Unit u = unitIt.next();
            if (leaders.contains(u)) {
                this.addBlock(blockHead, blockTail, indexInMethod, blockLength, blockList, unitToBlock);
                ++indexInMethod;
                blockHead = u;
                blockLength = 0;
            }
            blockTail = u;
            ++blockLength;
        }
        if (blockLength > 0) {
            this.addBlock(blockHead, blockTail, indexInMethod, blockLength, blockList, unitToBlock);
        }
        for (Unit headUnit : unitGraph.getHeads()) {
            Block headBlock = (Block)unitToBlock.get(headUnit);
            if (headBlock.getHead() == headUnit) {
                this.mHeads.add(headBlock);
                continue;
            }
            throw new RuntimeException("BlockGraph(): head Unit is not the first unit in the corresponding Block!");
        }
        for (Unit tailUnit : unitGraph.getTails()) {
            Block tailBlock = (Block)unitToBlock.get(tailUnit);
            if (tailBlock.getTail() == tailUnit) {
                this.mTails.add(tailBlock);
                continue;
            }
            throw new RuntimeException("BlockGraph(): tail Unit is not the last unit in the corresponding Block!");
        }
        for (Block block : blockList) {
            List<Unit> predUnits = unitGraph.getPredsOf(block.getHead());
            ArrayList<Block> predBlocks = new ArrayList<Block>(predUnits.size());
            for (Unit predUnit : predUnits) {
                Block predBlock = (Block)unitToBlock.get(predUnit);
                if (predBlock == null) {
                    throw new RuntimeException("BlockGraph(): block head mapped to null block!");
                }
                predBlocks.add(predBlock);
            }
            if (predBlocks.size() == 0) {
                block.setPreds(Collections.<Block>emptyList());
            } else {
                block.setPreds(Collections.unmodifiableList(predBlocks));
                if (block.getHead() == this.mUnits.getFirst()) {
                    this.mHeads.add(block);
                }
            }
            List<Unit> succUnits = unitGraph.getSuccsOf(block.getTail());
            ArrayList<Block> succBlocks = new ArrayList<Block>(succUnits.size());
            for (Unit succUnit : succUnits) {
                Block succBlock = (Block)unitToBlock.get(succUnit);
                if (succBlock == null) {
                    throw new RuntimeException("BlockGraph(): block tail mapped to null block!");
                }
                succBlocks.add(succBlock);
            }
            if (succBlocks.size() == 0) {
                block.setSuccs(Collections.<Block>emptyList());
                if (this.mTails.contains(block)) continue;
                throw new RuntimeException("Block with no successors is not a tail!: " + block.toString());
            }
            block.setSuccs(Collections.unmodifiableList(succBlocks));
        }
        this.mBlocks = Collections.unmodifiableList(blockList);
        this.mHeads = Collections.unmodifiableList(this.mHeads);
        this.mTails = this.mTails.size() == 0 ? Collections.emptyList() : Collections.unmodifiableList(this.mTails);
        return unitToBlock;
    }

    private void addBlock(Unit head, Unit tail, int index, int length, List<Block> blockList, Map<Unit, Block> unitToBlock) {
        Block block = new Block(head, tail, this.mBody, index, length, this);
        blockList.add(block);
        unitToBlock.put(tail, block);
        unitToBlock.put(head, block);
    }

    public Body getBody() {
        return this.mBody;
    }

    public List<Block> getBlocks() {
        return this.mBlocks;
    }

    public String toString() {
        Iterator<Block> it = this.mBlocks.iterator();
        StringBuffer buf = new StringBuffer();
        while (it.hasNext()) {
            Block someBlock = it.next();
            buf.append(someBlock.toString() + '\n');
        }
        return buf.toString();
    }

    @Override
    public List<Block> getHeads() {
        return this.mHeads;
    }

    @Override
    public List<Block> getTails() {
        return this.mTails;
    }

    @Override
    public List<Block> getPredsOf(Block b) {
        return b.getPreds();
    }

    @Override
    public List<Block> getSuccsOf(Block b) {
        return b.getSuccs();
    }

    @Override
    public int size() {
        return this.mBlocks.size();
    }

    @Override
    public Iterator<Block> iterator() {
        return this.mBlocks.iterator();
    }
}

