/*
 * Decompiled with CFR 0.152.
 */
package soot.shimple;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.Body;
import soot.G;
import soot.Local;
import soot.PatchingChain;
import soot.PhaseOptions;
import soot.Singletons;
import soot.SootMethod;
import soot.Unit;
import soot.UnitBox;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.JimpleBody;
import soot.options.Options;
import soot.shimple.PhiExpr;
import soot.shimple.PiExpr;
import soot.shimple.ShimpleBody;
import soot.shimple.ShimpleExpr;
import soot.shimple.internal.SPhiExpr;
import soot.shimple.internal.SPiExpr;
import soot.toolkits.scalar.ValueUnitPair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Shimple {
    public static final String IFALIAS = "IfAlias";
    public static final String MAYMODIFY = "MayModify";
    public static final String PHI = "Phi";
    public static final String PI = "Pi";
    public static final String PHASE = "shimple";

    public Shimple(Singletons.Global g) {
    }

    public static Shimple v() {
        return G.v().soot_shimple_Shimple();
    }

    public ShimpleBody newBody(SootMethod m) {
        Map options = PhaseOptions.v().getPhaseOptions(PHASE);
        return new ShimpleBody(m, options);
    }

    public ShimpleBody newBody(SootMethod m, Map options) {
        return new ShimpleBody(m, options);
    }

    public ShimpleBody newBody(Body b) {
        Map options = PhaseOptions.v().getPhaseOptions(PHASE);
        return new ShimpleBody(b, options);
    }

    public ShimpleBody newBody(Body b, Map options) {
        return new ShimpleBody(b, options);
    }

    public PhiExpr newPhiExpr(Local leftLocal, List preds) {
        return new SPhiExpr(leftLocal, preds);
    }

    public PiExpr newPiExpr(Local local, Unit predicate, Object targetKey) {
        return new SPiExpr(local, predicate, targetKey);
    }

    public PhiExpr newPhiExpr(List<Value> args, List<Unit> preds) {
        return new SPhiExpr(args, preds);
    }

    public JimpleBody newJimpleBody(ShimpleBody body) {
        return body.toJimpleBody();
    }

    public static boolean isPhiExpr(Value value) {
        return value instanceof PhiExpr;
    }

    public static boolean isPhiNode(Unit unit) {
        return Shimple.getPhiExpr(unit) != null;
    }

    public static PhiExpr getPhiExpr(Unit unit) {
        if (!(unit instanceof AssignStmt)) {
            return null;
        }
        Value right = ((AssignStmt)unit).getRightOp();
        if (Shimple.isPhiExpr(right)) {
            return (PhiExpr)right;
        }
        return null;
    }

    public static boolean isPiExpr(Value value) {
        return value instanceof PiExpr;
    }

    public static boolean isPiNode(Unit unit) {
        return Shimple.getPiExpr(unit) != null;
    }

    public static PiExpr getPiExpr(Unit unit) {
        if (!(unit instanceof AssignStmt)) {
            return null;
        }
        Value right = ((AssignStmt)unit).getRightOp();
        if (Shimple.isPiExpr(right)) {
            return (PiExpr)right;
        }
        return null;
    }

    public static Local getLhsLocal(Unit unit) {
        if (!(unit instanceof AssignStmt)) {
            return null;
        }
        Value right = ((AssignStmt)unit).getRightOp();
        if (right instanceof ShimpleExpr) {
            Value left = ((AssignStmt)unit).getLeftOp();
            return (Local)left;
        }
        return null;
    }

    public static void redirectToPreds(Body body, Unit remove) {
        Unit possiblePred;
        UnitBox pointer;
        boolean debug = Options.v().debug();
        if (body instanceof ShimpleBody) {
            debug |= ((ShimpleBody)body).getOptions().debug();
        }
        PatchingChain<Unit> units = body.getUnits();
        Iterator<UnitBox> pointersIt = remove.getBoxesPointingToThis().iterator();
        if (!pointersIt.hasNext()) {
            return;
        }
        while (pointersIt.hasNext() && (pointer = pointersIt.next()).isBranchTarget()) {
            if (pointersIt.hasNext()) continue;
            return;
        }
        HashSet<Unit> preds = new HashSet<Unit>();
        HashSet<PhiExpr> phis = new HashSet<PhiExpr>();
        if (!remove.equals(units.getFirst()) && (possiblePred = units.getPredOf(remove)).fallsThrough()) {
            preds.add(possiblePred);
        }
        for (Unit unit : units) {
            for (UnitBox targetBox : unit.getUnitBoxes()) {
                if (!remove.equals(targetBox.getUnit())) continue;
                if (targetBox.isBranchTarget()) {
                    preds.add(unit);
                    continue;
                }
                PhiExpr phiExpr = Shimple.getPhiExpr(unit);
                if (phiExpr == null) continue;
                phis.add(phiExpr);
            }
        }
        if (phis.size() == 0) {
            if (debug) {
                G.v().out.println("Warning: Orphaned UnitBoxes to " + remove + "? Shimple.redirectToPreds is giving up.");
            }
            return;
        }
        if (preds.size() == 0) {
            if (debug) {
                G.v().out.println("Warning: Shimple.redirectToPreds couldn't find any predecessors for " + remove + " in " + body.getMethod() + ".");
            }
            if (!remove.equals(units.getFirst())) {
                Unit pred = units.getPredOf(remove);
                if (debug) {
                    G.v().out.println("Warning: Falling back to immediate chain predecessor: " + pred + ".");
                }
                preds.add(pred);
            } else if (!remove.equals(units.getLast())) {
                Unit succ = units.getSuccOf(remove);
                if (debug) {
                    G.v().out.println("Warning: Falling back to immediate chain successor: " + succ + ".");
                }
                preds.add(succ);
            } else {
                throw new RuntimeException("Assertion failed.");
            }
        }
        for (PhiExpr phiExpr : phis) {
            ValueUnitPair argBox = phiExpr.getArgBox(remove);
            if (argBox == null) {
                throw new RuntimeException("Assertion failed.");
            }
            Value arg = argBox.getValue();
            phiExpr.removeArg(argBox);
            for (Unit pred : preds) {
                phiExpr.addArg(arg, pred);
            }
        }
    }

    public static void redirectPointers(Unit oldLocation, Unit newLocation) {
        Object[] boxes;
        List<UnitBox> boxesPointing = oldLocation.getBoxesPointingToThis();
        for (Object element : boxes = boxesPointing.toArray()) {
            UnitBox box = (UnitBox)element;
            if (box.getUnit() != oldLocation) {
                throw new RuntimeException("Something weird's happening");
            }
            if (box.isBranchTarget()) continue;
            box.setUnit(newLocation);
        }
    }
}

