/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.thread.mhp.findobject;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import soot.jimple.toolkits.thread.mhp.pegcallgraph.PegCallGraph;
import soot.util.ArraySet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiCalledMethods {
    Set visited = new HashSet();
    Set<Object> multiCalledMethods = new HashSet<Object>();

    MultiCalledMethods(PegCallGraph pcg, Set<Object> mcm) {
        this.multiCalledMethods = mcm;
        this.propagate(pcg);
        this.finder1(pcg);
        this.finder2(pcg);
    }

    private void propagate(PegCallGraph pcg) {
        Iterator<Object> it = this.multiCalledMethods.iterator();
        ArraySet visited = new ArraySet();
        while (it.hasNext()) {
            Object obj = it.next();
            Iterator succIt = pcg.getSuccsOf(obj).iterator();
            while (succIt.hasNext()) {
                if (visited.contains(obj)) continue;
                this.dfsVisit(obj, pcg);
            }
        }
    }

    private void dfsVisit(Object obj, PegCallGraph pcg) {
        if (!this.multiCalledMethods.contains(obj)) {
            this.multiCalledMethods.add(obj);
        }
        Iterator succIt = pcg.getSuccsOf(obj).iterator();
        while (succIt.hasNext()) {
            if (this.visited.contains(obj)) continue;
            this.dfsVisit(obj, pcg);
        }
    }

    private void finder1(PegCallGraph pcg) {
        Set clinitMethods = pcg.getClinitMethods();
        for (Object head : pcg) {
            HashSet gray = new HashSet();
            LinkedList queue = new LinkedList();
            queue.add(head);
            while (queue.size() > 0) {
                Object root = queue.getFirst();
                for (Object succ : pcg.getSuccsOf(root)) {
                    if (!gray.contains(succ)) {
                        gray.add(succ);
                        queue.addLast(succ);
                        continue;
                    }
                    if (clinitMethods.contains(succ)) continue;
                    this.multiCalledMethods.add(succ);
                }
                queue.remove(root);
            }
        }
    }

    private void finder2(PegCallGraph pcg) {
        pcg.trim();
        HashSet<Object> first = new HashSet<Object>();
        HashSet<Object> second = new HashSet<Object>();
        for (Object s : pcg) {
            if (second.contains(s)) continue;
            this.visitNode(s, pcg, first, second);
        }
    }

    private void visitNode(Object node, PegCallGraph pcg, Set<Object> first, Set<Object> second) {
        if (first.contains(node)) {
            second.add(node);
            if (!this.multiCalledMethods.contains(node)) {
                this.multiCalledMethods.add(node);
            }
        } else {
            first.add(node);
        }
        for (Object succ : pcg.getTrimSuccsOf(node)) {
            if (second.contains(succ)) continue;
            this.visitNode(succ, pcg, first, second);
        }
    }

    public Set<Object> getMultiCalledMethods() {
        return this.multiCalledMethods;
    }
}

