/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.thread.mhp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.Hierarchy;
import soot.Local;
import soot.MethodOrMethodContext;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Value;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.sets.P2SetVisitor;
import soot.jimple.spark.sets.PointsToSetInternal;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Filter;
import soot.jimple.toolkits.callgraph.TransitiveTargets;
import soot.jimple.toolkits.scalar.EqualUsesAnalysis;
import soot.jimple.toolkits.thread.mhp.RunMethodsPred;
import soot.toolkits.graph.BriefUnitGraph;
import soot.toolkits.graph.MHGPostDominatorsFinder;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.ArraySparseSet;
import soot.toolkits.scalar.FlowSet;
import soot.toolkits.scalar.ForwardFlowAnalysis;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartJoinAnalysis
extends ForwardFlowAnalysis {
    Set<Stmt> startStatements = new HashSet<Stmt>();
    Set<Stmt> joinStatements = new HashSet<Stmt>();
    Hierarchy hierarchy = Scene.v().getActiveHierarchy();
    Map<Stmt, List<SootMethod>> startToRunMethods = new HashMap<Stmt, List<SootMethod>>();
    Map<Stmt, List<AllocNode>> startToAllocNodes = new HashMap<Stmt, List<AllocNode>>();
    Map<Stmt, Stmt> startToJoin = new HashMap<Stmt, Stmt>();

    public StartJoinAnalysis(UnitGraph g, SootMethod sm, CallGraph callGraph, PAG pag) {
        super(g);
        this.doFlowInsensitiveSingleIterationAnalysis();
        if (!this.startStatements.isEmpty()) {
            MHGPostDominatorsFinder pd = new MHGPostDominatorsFinder(new BriefUnitGraph(sm.getActiveBody()));
            EqualUsesAnalysis lif = new EqualUsesAnalysis(g);
            TransitiveTargets runMethodTargets = new TransitiveTargets(callGraph, new Filter(new RunMethodsPred()));
            for (Stmt start : this.startStatements) {
                ArrayList<SootMethod> runMethodsList = new ArrayList<SootMethod>();
                ArrayList<AllocNode> allocNodesList = new ArrayList<AllocNode>();
                Value startObject = ((InstanceInvokeExpr)start.getInvokeExpr()).getBase();
                PointsToSetInternal pts = (PointsToSetInternal)pag.reachingObjects((Local)startObject);
                List<AllocNode> mayAlias = this.getMayAliasList(pts);
                if (mayAlias.size() < 1) continue;
                Iterator<MethodOrMethodContext> mayRunIt = runMethodTargets.iterator(start);
                while (mayRunIt.hasNext()) {
                    SootMethod runMethod = (SootMethod)mayRunIt.next();
                    if (!runMethod.getSubSignature().equals("void run()")) continue;
                    runMethodsList.add(runMethod);
                }
                if (runMethodsList.isEmpty() && ((RefType)startObject.getType()).getSootClass().isApplicationClass()) {
                    List<SootClass> threadClasses = this.hierarchy.getSubclassesOfIncluding(((RefType)startObject.getType()).getSootClass());
                    for (SootClass currentClass : threadClasses) {
                        if (!currentClass.declaresMethod("void run()")) continue;
                        runMethodsList.add(currentClass.getMethod("void run()"));
                    }
                }
                for (AllocNode allocNode : mayAlias) {
                    allocNodesList.add(allocNode);
                    if (!runMethodsList.isEmpty()) continue;
                    throw new RuntimeException("Can't find run method for: " + startObject);
                }
                this.startToRunMethods.put(start, runMethodsList);
                this.startToAllocNodes.put(start, allocNodesList);
                for (Stmt join : this.joinStatements) {
                    Value joinObject;
                    if (!lif.areEqualUses(start, (Local)startObject, join, (Local)(joinObject = ((InstanceInvokeExpr)join.getInvokeExpr()).getBase())) || !pd.getDominators(start).contains(join)) continue;
                    this.startToJoin.put(start, join);
                }
            }
        }
    }

    private List<AllocNode> getMayAliasList(PointsToSetInternal pts) {
        ArrayList<AllocNode> list = new ArrayList<AllocNode>();
        final HashSet ret = new HashSet();
        pts.forall(new P2SetVisitor(){

            public void visit(Node n) {
                ret.add((AllocNode)n);
            }
        });
        Iterator it = ret.iterator();
        while (it.hasNext()) {
            list.add((AllocNode)it.next());
        }
        return list;
    }

    public Set<Stmt> getStartStatements() {
        return this.startStatements;
    }

    public Set<Stmt> getJoinStatements() {
        return this.joinStatements;
    }

    public Map<Stmt, List<SootMethod>> getStartToRunMethods() {
        return this.startToRunMethods;
    }

    public Map<Stmt, List<AllocNode>> getStartToAllocNodes() {
        return this.startToAllocNodes;
    }

    public Map<Stmt, Stmt> getStartToJoin() {
        return this.startToJoin;
    }

    public void doFlowInsensitiveSingleIterationAnalysis() {
        FlowSet fs = (FlowSet)this.newInitialFlow();
        for (Stmt s : this.graph) {
            this.flowThrough(fs, s, fs);
        }
    }

    @Override
    protected void merge(Object in1, Object in2, Object out) {
        FlowSet inSet1 = (FlowSet)in1;
        FlowSet inSet2 = (FlowSet)in2;
        FlowSet outSet = (FlowSet)out;
        inSet1.intersection(inSet2, outSet);
    }

    @Override
    protected void flowThrough(Object inValue, Object unit, Object outValue) {
        InvokeExpr ie;
        Stmt stmt = (Stmt)unit;
        if (stmt.containsInvokeExpr() && (ie = stmt.getInvokeExpr()) instanceof InstanceInvokeExpr) {
            Iterator<SootClass> it;
            List<SootClass> superClasses;
            RefType baseType;
            InstanceInvokeExpr iie = (InstanceInvokeExpr)ie;
            SootMethod invokeMethod = ie.getMethod();
            if (invokeMethod.getName().equals("start") && !(baseType = (RefType)iie.getBase().getType()).getSootClass().isInterface()) {
                superClasses = this.hierarchy.getSuperclassesOfIncluding(baseType.getSootClass());
                it = superClasses.iterator();
                while (it.hasNext()) {
                    if (!it.next().getName().equals("java.lang.Thread") || this.startStatements.contains(stmt)) continue;
                    this.startStatements.add(stmt);
                }
            }
            if (invokeMethod.getName().equals("join") && !(baseType = (RefType)iie.getBase().getType()).getSootClass().isInterface()) {
                superClasses = this.hierarchy.getSuperclassesOfIncluding(baseType.getSootClass());
                it = superClasses.iterator();
                while (it.hasNext()) {
                    if (!it.next().getName().equals("java.lang.Thread") || this.joinStatements.contains(stmt)) continue;
                    this.joinStatements.add(stmt);
                }
            }
        }
    }

    @Override
    protected void copy(Object source, Object dest) {
        FlowSet sourceSet = (FlowSet)source;
        FlowSet destSet = (FlowSet)dest;
        sourceSet.copy(destSet);
    }

    @Override
    protected Object entryInitialFlow() {
        return new ArraySparseSet();
    }

    @Override
    protected Object newInitialFlow() {
        return new ArraySparseSet();
    }
}

