/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar;

import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.ErroneousType;
import soot.FloatType;
import soot.G;
import soot.IntType;
import soot.Local;
import soot.LongType;
import soot.NullType;
import soot.PhaseOptions;
import soot.ShortType;
import soot.Singletons;
import soot.StmtAddressType;
import soot.UnknownType;

public class LocalNameStandardizer
extends BodyTransformer {
    public LocalNameStandardizer(Singletons.Global g) {
    }

    public static LocalNameStandardizer v() {
        return G.v().soot_jimple_toolkits_scalar_LocalNameStandardizer();
    }

    protected void internalTransform(Body body, String phaseName, Map options) {
        boolean onlyStackName = PhaseOptions.getBoolean(options, "only-stack-locals");
        int objectCount = 0;
        int intCount = 0;
        int longCount = 0;
        int floatCount = 0;
        int doubleCount = 0;
        int addressCount = 0;
        int errorCount = 0;
        int nullCount = 0;
        for (Local l : body.getLocals()) {
            String prefix = "";
            if (l.getName().startsWith("$")) {
                prefix = "$";
            } else if (onlyStackName) continue;
            if (l.getType().equals(BooleanType.v())) {
                l.setName(prefix + "z" + intCount++);
                continue;
            }
            if (l.getType().equals(ByteType.v())) {
                l.setName(prefix + "b" + longCount++);
                continue;
            }
            if (l.getType().equals(ShortType.v())) {
                l.setName(prefix + "s" + longCount++);
                continue;
            }
            if (l.getType().equals(CharType.v())) {
                l.setName(prefix + "c" + longCount++);
                continue;
            }
            if (l.getType().equals(IntType.v())) {
                l.setName(prefix + "i" + longCount++);
                continue;
            }
            if (l.getType().equals(LongType.v())) {
                l.setName(prefix + "l" + longCount++);
                continue;
            }
            if (l.getType().equals(DoubleType.v())) {
                l.setName(prefix + "d" + doubleCount++);
                continue;
            }
            if (l.getType().equals(FloatType.v())) {
                l.setName(prefix + "f" + floatCount++);
                continue;
            }
            if (l.getType().equals(StmtAddressType.v())) {
                l.setName(prefix + "a" + addressCount++);
                continue;
            }
            if (l.getType().equals(ErroneousType.v()) || l.getType().equals(UnknownType.v())) {
                l.setName(prefix + "e" + errorCount++);
                continue;
            }
            if (l.getType().equals(NullType.v())) {
                l.setName(prefix + "n" + nullCount++);
                continue;
            }
            l.setName(prefix + "r" + objectCount++);
        }
    }
}

