/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar;

import java.util.ArrayList;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.PatchingChain;
import soot.Singletons;
import soot.Unit;
import soot.Value;
import soot.jimple.GotoStmt;
import soot.jimple.IfStmt;
import soot.jimple.IntConstant;
import soot.jimple.Jimple;
import soot.jimple.Stmt;
import soot.jimple.StmtBody;
import soot.jimple.toolkits.scalar.Evaluator;
import soot.options.Options;

public class ConditionalBranchFolder
extends BodyTransformer {
    public ConditionalBranchFolder(Singletons.Global g) {
    }

    public static ConditionalBranchFolder v() {
        return G.v().soot_jimple_toolkits_scalar_ConditionalBranchFolder();
    }

    protected void internalTransform(Body body, String phaseName, Map options) {
        StmtBody stmtBody = (StmtBody)body;
        int numTrue = 0;
        int numFalse = 0;
        if (Options.v().verbose()) {
            G.v().out.println("[" + stmtBody.getMethod().getName() + "] Folding conditional branches...");
        }
        PatchingChain<Unit> units = stmtBody.getUnits();
        ArrayList<Unit> unitList = new ArrayList<Unit>();
        unitList.addAll(units);
        for (Stmt stmt : unitList) {
            Value cond;
            if (!(stmt instanceof IfStmt) || !Evaluator.isValueConstantValued(cond = ((IfStmt)stmt).getCondition())) continue;
            cond = Evaluator.getConstantValueOf(cond);
            if (((IntConstant)cond).value == 1) {
                GotoStmt newStmt = Jimple.v().newGotoStmt(((IfStmt)stmt).getTarget());
                units.insertAfter(newStmt, (Unit)stmt);
                ++numTrue;
            } else {
                ++numFalse;
            }
            units.remove(stmt);
        }
        if (Options.v().verbose()) {
            G.v().out.println("[" + stmtBody.getMethod().getName() + "]     Folded " + numTrue + " true, " + numFalse + " conditional branches");
        }
    }
}

