/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.annotation.purity;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.G;
import soot.SootMethod;
import soot.jimple.toolkits.annotation.purity.SootMethodFilter;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Edge;
import soot.toolkits.graph.DirectedGraph;
import soot.util.HashMultiMap;

public class DirectedCallGraph
implements DirectedGraph {
    protected Set nodes;
    protected Map<Object, List> succ;
    protected Map<Object, List> pred;
    protected List heads;
    protected List tails;
    protected int size;

    public DirectedCallGraph(CallGraph cg, SootMethodFilter filter, Iterator heads, boolean verbose) {
        LinkedList<SootMethod> filteredHeads = new LinkedList<SootMethod>();
        while (heads.hasNext()) {
            SootMethod m = (SootMethod)heads.next();
            if (!m.isConcrete() || !filter.want(m)) continue;
            filteredHeads.add(m);
        }
        this.nodes = new HashSet(filteredHeads);
        HashMultiMap s = new HashMultiMap();
        HashMultiMap p = new HashMultiMap();
        HashSet remain = new HashSet(filteredHeads);
        int nb = 0;
        if (verbose) {
            G.v().out.println("[AM] dumping method dependencies");
        }
        while (!remain.isEmpty()) {
            HashSet<SootMethod> newRemain = new HashSet<SootMethod>();
            for (SootMethod m : remain) {
                Iterator<Edge> itt = cg.edgesOutOf(m);
                if (verbose) {
                    G.v().out.println(" |- " + m.toString() + " calls");
                }
                while (itt.hasNext()) {
                    boolean keep;
                    Edge edge = itt.next();
                    SootMethod mm = edge.tgt();
                    boolean bl = keep = mm.isConcrete() && filter.want(mm);
                    if (verbose) {
                        G.v().out.println(" |  |- " + mm.toString() + (keep ? "" : " (filtered out)"));
                    }
                    if (!keep) continue;
                    if (this.nodes.add(mm)) {
                        newRemain.add(mm);
                    }
                    s.put(m, mm);
                    p.put(mm, m);
                }
                ++nb;
            }
            remain = newRemain;
        }
        G.v().out.println("[AM] number of methods to be analysed: " + nb);
        this.succ = new HashMap<Object, List>();
        this.pred = new HashMap<Object, List>();
        this.tails = new LinkedList();
        this.heads = new LinkedList();
        for (Object x : this.nodes) {
            Set ss = s.get(x);
            Set pp = p.get(x);
            this.succ.put(x, new LinkedList(ss));
            this.pred.put(x, new LinkedList(pp));
            if (ss.isEmpty()) {
                this.tails.add(x);
            }
            if (!pp.isEmpty()) continue;
            this.heads.add(x);
        }
        this.size = this.nodes.size();
    }

    public List getHeads() {
        return this.heads;
    }

    public List getTails() {
        return this.tails;
    }

    public Iterator iterator() {
        return this.nodes.iterator();
    }

    public int size() {
        return this.size;
    }

    public List getSuccsOf(Object s) {
        return this.succ.get(s);
    }

    public List getPredsOf(Object s) {
        return this.pred.get(s);
    }
}

