/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.ondemand.pautil;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import soot.G;
import soot.SootMethod;
import soot.jimple.InvokeExpr;
import soot.jimple.spark.ondemand.genericutil.ArraySet;
import soot.jimple.spark.ondemand.genericutil.ArraySetMultiMap;
import soot.jimple.spark.ondemand.pautil.AssignEdge;
import soot.jimple.spark.ondemand.pautil.SootUtil;
import soot.jimple.spark.pag.GlobalVarNode;
import soot.jimple.spark.pag.LocalVarNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.pag.VarNode;
import soot.toolkits.scalar.Pair;
import soot.util.HashMultiMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextSensitiveInfo {
    private static final boolean SKIP_STRING_NODES = false;
    private static final boolean SKIP_EXCEPTION_NODES = false;
    private static final boolean SKIP_THREAD_GLOBALS = false;
    private static final boolean PRINT_CALL_SITE_INFO = false;
    private final ArraySetMultiMap<VarNode, AssignEdge> contextSensitiveAssignEdges = new ArraySetMultiMap();
    private final ArraySetMultiMap<VarNode, AssignEdge> contextSensitiveAssignBarEdges = new ArraySetMultiMap();
    private final ArraySetMultiMap<SootMethod, VarNode> methodToNodes = new ArraySetMultiMap();
    private final ArraySetMultiMap<SootMethod, VarNode> methodToOutPorts = new ArraySetMultiMap();
    private final ArraySetMultiMap<SootMethod, VarNode> methodToInPorts = new ArraySetMultiMap();
    private final ArraySetMultiMap<SootMethod, Integer> callSitesInMethod = new ArraySetMultiMap();
    private final ArraySetMultiMap<SootMethod, Integer> callSitesInvokingMethod = new ArraySetMultiMap();
    private final ArraySetMultiMap<Integer, SootMethod> callSiteToTargets = new ArraySetMultiMap();
    private final ArraySetMultiMap<Integer, AssignEdge> callSiteToEdges = new ArraySetMultiMap();
    private final Map<Integer, LocalVarNode> virtCallSiteToReceiver = new HashMap<Integer, LocalVarNode>();
    private final Map<Integer, SootMethod> callSiteToInvokedMethod = new HashMap<Integer, SootMethod>();
    private final Map<Integer, SootMethod> callSiteToInvokingMethod = new HashMap<Integer, SootMethod>();
    private final ArraySetMultiMap<LocalVarNode, Integer> receiverToVirtCallSites = new ArraySetMultiMap();

    public ContextSensitiveInfo(PAG pag) {
        Iterator iter = pag.getVarNodeNumberer().iterator();
        while (iter.hasNext()) {
            VarNode varNode = (VarNode)iter.next();
            if (!(varNode instanceof LocalVarNode)) continue;
            LocalVarNode local = (LocalVarNode)varNode;
            SootMethod sootMethod = local.getMethod();
            assert (sootMethod != null) : local;
            this.methodToNodes.put(sootMethod, local);
            if (SootUtil.isRetNode(local)) {
                this.methodToOutPorts.put(sootMethod, local);
            }
            if (!SootUtil.isParamNode(local)) continue;
            this.methodToInPorts.put(sootMethod, local);
        }
        int callSiteNum = 0;
        Set<Object> assignSources = pag.simpleSources();
        for (VarNode varNode : assignSources) {
            if (this.skipNode(varNode)) continue;
            boolean sourceGlobal = varNode instanceof GlobalVarNode;
            Node[] assignTargets = pag.simpleLookup(varNode);
            for (int i = 0; i < assignTargets.length; ++i) {
                SootMethod method;
                LocalVarNode local;
                SootMethod method2;
                VarNode assignTarget = (VarNode)assignTargets[i];
                if (this.skipNode(assignTarget)) continue;
                boolean isFinalizerNode = false;
                if (assignTarget instanceof LocalVarNode && (method2 = (local = (LocalVarNode)assignTarget).getMethod()).toString().indexOf("finalize()") != -1 && SootUtil.isThisNode(local)) {
                    isFinalizerNode = true;
                }
                boolean targetGlobal = assignTarget instanceof GlobalVarNode;
                AssignEdge assignEdge = new AssignEdge(varNode, assignTarget);
                if (isFinalizerNode) {
                    assignEdge.setParamEdge();
                    Integer callSite = new Integer(callSiteNum++);
                    assignEdge.setCallSite(callSite);
                }
                this.addAssignEdge(assignEdge);
                if (sourceGlobal) {
                    if (targetGlobal || ((ArraySet)this.methodToInPorts.get((Object)(method = ((LocalVarNode)assignTarget).getMethod()))).contains(assignTarget)) continue;
                    this.methodToInPorts.put(method, varNode);
                    continue;
                }
                if (!targetGlobal || ((ArraySet)this.methodToOutPorts.get((Object)(method = ((LocalVarNode)varNode).getMethod()))).contains(varNode)) continue;
                this.methodToOutPorts.put(method, assignTarget);
            }
        }
        HashMultiMap callAssigns = pag.callAssigns;
        Object var5_9 = null;
        for (InvokeExpr ie : callAssigns.keySet()) {
            Integer callSite = new Integer(callSiteNum++);
            this.callSiteToInvokedMethod.put(callSite, ie.getMethod());
            SootMethod invokingMethod = pag.callToMethod.get(ie);
            this.callSiteToInvokingMethod.put(callSite, invokingMethod);
            if (pag.virtualCallsToReceivers.containsKey(ie)) {
                LocalVarNode receiver = (LocalVarNode)pag.virtualCallsToReceivers.get(ie);
                assert (receiver != null);
                this.virtCallSiteToReceiver.put(callSite, receiver);
                this.receiverToVirtCallSites.put(receiver, callSite);
            }
            Set curEdges = callAssigns.get(ie);
            for (Pair callAssign : curEdges) {
                SootMethod invokedMethod;
                VarNode src = (VarNode)callAssign.getO1();
                VarNode dst = (VarNode)callAssign.getO2();
                if (this.skipNode(src)) continue;
                ArraySet<AssignEdge> edges = this.getAssignBarEdges(src);
                AssignEdge edge = null;
                for (int i = 0; i < edges.size() && edge == null; ++i) {
                    AssignEdge curEdge = edges.get(i);
                    if (curEdge.getDst() != dst) continue;
                    edge = curEdge;
                }
                assert (edge != null) : "no edge from " + src + " to " + dst;
                boolean edgeFromOtherCallSite = edge.isCallEdge();
                if (edgeFromOtherCallSite) {
                    edge = new AssignEdge(src, dst);
                }
                edge.setCallSite(callSite);
                this.callSiteToEdges.put(callSite, edge);
                if (SootUtil.isParamNode(dst)) {
                    edge.setParamEdge();
                    invokedMethod = ((LocalVarNode)dst).getMethod();
                    this.callSiteToTargets.put(callSite, invokedMethod);
                    this.callSitesInvokingMethod.put(invokedMethod, callSite);
                    if (src instanceof LocalVarNode) {
                        this.callSitesInMethod.put(((LocalVarNode)src).getMethod(), callSite);
                    }
                } else if (SootUtil.isRetNode(src)) {
                    edge.setReturnEdge();
                    invokedMethod = ((LocalVarNode)src).getMethod();
                    this.callSiteToTargets.put(callSite, invokedMethod);
                    this.callSitesInvokingMethod.put(invokedMethod, callSite);
                    if (dst instanceof LocalVarNode) {
                        this.callSitesInMethod.put(((LocalVarNode)dst).getMethod(), callSite);
                    }
                } else assert (false) : "weird call edge " + callAssign;
                if (!edgeFromOtherCallSite) continue;
                this.addAssignEdge(edge);
            }
        }
        assert (this.callEdgesReasonable());
    }

    private boolean callEdgesReasonable() {
        Set vars = this.contextSensitiveAssignEdges.keySet();
        for (VarNode node : vars) {
            Set assigns = this.contextSensitiveAssignEdges.get((Object)node);
            for (AssignEdge edge : assigns) {
                if (!edge.isCallEdge() || edge.getCallSite() != null) continue;
                G.v().out.println(edge + " is weird!!");
                return false;
            }
        }
        return true;
    }

    private String assignEdgesWellFormed(PAG pag) {
        Iterator iter = pag.getVarNodeNumberer().iterator();
        while (iter.hasNext()) {
            VarNode v = (VarNode)iter.next();
            ArraySet<AssignEdge> outgoingAssigns = this.getAssignBarEdges(v);
            for (AssignEdge edge : outgoingAssigns) {
                if (edge.getSrc() == v) continue;
                return edge + " src should be " + v;
            }
            ArraySet<AssignEdge> incomingAssigns = this.getAssignEdges(v);
            for (AssignEdge edge : incomingAssigns) {
                if (edge.getDst() == v) continue;
                return edge + " dst should be " + v;
            }
        }
        return null;
    }

    private boolean skipNode(VarNode node) {
        return false;
    }

    private void addAssignEdge(AssignEdge assignEdge) {
        this.contextSensitiveAssignEdges.put(assignEdge.getSrc(), assignEdge);
        this.contextSensitiveAssignBarEdges.put(assignEdge.getDst(), assignEdge);
    }

    public ArraySet<AssignEdge> getAssignBarEdges(VarNode node) {
        return this.contextSensitiveAssignEdges.get((Object)node);
    }

    public ArraySet<AssignEdge> getAssignEdges(VarNode node) {
        return this.contextSensitiveAssignBarEdges.get((Object)node);
    }

    public Set<SootMethod> methods() {
        return this.methodToNodes.keySet();
    }

    public ArraySet<VarNode> getNodesForMethod(SootMethod method) {
        return this.methodToNodes.get((Object)method);
    }

    public ArraySet<VarNode> getInPortsForMethod(SootMethod method) {
        return this.methodToInPorts.get((Object)method);
    }

    public ArraySet<VarNode> getOutPortsForMethod(SootMethod method) {
        return this.methodToOutPorts.get((Object)method);
    }

    public ArraySet<Integer> getCallSitesInMethod(SootMethod method) {
        return this.callSitesInMethod.get((Object)method);
    }

    public Set<Integer> getCallSitesInvokingMethod(SootMethod method) {
        return this.callSitesInvokingMethod.get((Object)method);
    }

    public ArraySet<AssignEdge> getCallSiteEdges(Integer callSite) {
        return this.callSiteToEdges.get((Object)callSite);
    }

    public ArraySet<SootMethod> getCallSiteTargets(Integer callSite) {
        return this.callSiteToTargets.get((Object)callSite);
    }

    public LocalVarNode getReceiverForVirtCallSite(Integer callSite) {
        LocalVarNode ret = this.virtCallSiteToReceiver.get(callSite);
        assert (ret != null);
        return ret;
    }

    public Set<Integer> getVirtCallSitesForReceiver(LocalVarNode receiver) {
        return this.receiverToVirtCallSites.get((Object)receiver);
    }

    public SootMethod getInvokedMethod(Integer callSite) {
        return this.callSiteToInvokedMethod.get(callSite);
    }

    public SootMethod getInvokingMethod(Integer callSite) {
        return this.callSiteToInvokingMethod.get(callSite);
    }

    public boolean isVirtCall(Integer callSite) {
        return this.virtCallSiteToReceiver.containsKey(callSite);
    }
}

