/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.parser;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.util.HashMap;
import soot.G;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.jimple.JimpleBody;
import soot.jimple.parser.BodyExtractorWalker;
import soot.jimple.parser.Walker;
import soot.jimple.parser.lexer.Lexer;
import soot.jimple.parser.lexer.LexerException;
import soot.jimple.parser.node.Start;
import soot.jimple.parser.parser.Parser;
import soot.jimple.parser.parser.ParserException;
import soot.util.EscapedReader;

public class Parse {
    private static final String EXT = ".jimple";
    private static final String USAGE = "usage: java Parse [options] jimple_file [jimple_file ...]";

    public static SootClass parse(InputStream istream, SootClass sc) {
        Start tree = null;
        Parser p = new Parser(new Lexer(new PushbackReader(new EscapedReader(new BufferedReader(new InputStreamReader(istream))), 1024)));
        try {
            tree = p.parse();
        }
        catch (ParserException e) {
            throw new RuntimeException("Parser exception occurred: " + e);
        }
        catch (LexerException e) {
            throw new RuntimeException("Lexer exception occurred: " + e);
        }
        catch (IOException e) {
            throw new RuntimeException("IOException occurred: " + e);
        }
        Walker w = sc == null ? new Walker(null) : new BodyExtractorWalker(sc, null, new HashMap<SootMethod, JimpleBody>());
        tree.apply(w);
        return w.getSootClass();
    }

    public static void main(String[] args) throws Exception {
        boolean verbose = false;
        if (args.length < 1) {
            G.v().out.println(USAGE);
            System.exit(0);
        }
        Scene.v().setPhantomRefs(true);
        for (String arg : args) {
            InputStream inFile;
            if (arg.startsWith("-")) {
                if ((arg = arg.substring(1)).equals("d") || !arg.equals("v")) continue;
                verbose = true;
                continue;
            }
            try {
                if (verbose) {
                    G.v().out.println(" ... looking for " + arg);
                }
                inFile = new FileInputStream(arg);
            }
            catch (FileNotFoundException e) {
                if (arg.endsWith(EXT)) {
                    G.v().out.println(" *** can't find " + arg);
                    continue;
                }
                arg = arg + EXT;
                try {
                    if (verbose) {
                        G.v().out.println(" ... looking for " + arg);
                    }
                    inFile = new BufferedInputStream(new FileInputStream(arg));
                }
                catch (FileNotFoundException ee) {
                    G.v().out.println(" *** can't find " + arg);
                    continue;
                }
            }
            Parser p = new Parser(new Lexer(new PushbackReader(new InputStreamReader(inFile), 1024)));
            Start tree = p.parse();
            tree.apply(new Walker(null));
        }
    }
}

