/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import soot.Unit;
import soot.UnitBox;
import soot.UnitPrinter;
import soot.Value;
import soot.ValueBox;
import soot.baf.Baf;
import soot.baf.PlaceholderInst;
import soot.baf.TableSwitchInst;
import soot.jimple.ConvertToBaf;
import soot.jimple.Jimple;
import soot.jimple.JimpleToBafContext;
import soot.jimple.Stmt;
import soot.jimple.StmtSwitch;
import soot.jimple.TableSwitchStmt;
import soot.jimple.internal.AbstractStmt;
import soot.tagkit.Tag;
import soot.util.Switch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTableSwitchStmt
extends AbstractStmt
implements TableSwitchStmt {
    UnitBox defaultTargetBox;
    ValueBox keyBox;
    int lowIndex;
    int highIndex;
    UnitBox[] targetBoxes;
    List stmtBoxes;

    @Override
    public Object clone() {
        return new JTableSwitchStmt(Jimple.v().newImmediateBox(Jimple.cloneIfNecessary(this.getKey())), this.lowIndex, this.highIndex, JTableSwitchStmt.getTargetBoxesArray(this.getTargets()), Jimple.v().newStmtBox(this.getDefaultTarget()));
    }

    private static UnitBox[] getTargetBoxesArray(List targets) {
        UnitBox[] targetBoxes = new UnitBox[targets.size()];
        for (int i = 0; i < targetBoxes.length; ++i) {
            targetBoxes[i] = Jimple.v().newStmtBox((Stmt)targets.get(i));
        }
        return targetBoxes;
    }

    public JTableSwitchStmt(Value key, int lowIndex, int highIndex, List targets, Unit defaultTarget) {
        this(Jimple.v().newImmediateBox(key), lowIndex, highIndex, JTableSwitchStmt.getTargetBoxesArray(targets), Jimple.v().newStmtBox(defaultTarget));
    }

    public JTableSwitchStmt(Value key, int lowIndex, int highIndex, List<Object> targets, UnitBox defaultTarget) {
        this(Jimple.v().newImmediateBox(key), lowIndex, highIndex, JTableSwitchStmt.unitBoxListToArray(targets), defaultTarget);
    }

    private static UnitBox[] unitBoxListToArray(List<Object> targets) {
        UnitBox[] targetBoxes = new UnitBox[targets.size()];
        for (int i = 0; i < targetBoxes.length; ++i) {
            targetBoxes[i] = (UnitBox)targets.get(i);
        }
        return targetBoxes;
    }

    protected JTableSwitchStmt(ValueBox keyBox, int lowIndex, int highIndex, UnitBox[] targetBoxes, UnitBox defaultTargetBox) {
        this.keyBox = keyBox;
        this.defaultTargetBox = defaultTargetBox;
        if (lowIndex > highIndex) {
            throw new RuntimeException("Error creating tableswitch: lowIndex(" + lowIndex + ") can't be greater than highIndex(" + highIndex + ").");
        }
        this.lowIndex = lowIndex;
        this.highIndex = highIndex;
        this.targetBoxes = targetBoxes;
        this.stmtBoxes = new ArrayList();
        for (UnitBox element : targetBoxes) {
            this.stmtBoxes.add(element);
        }
        this.stmtBoxes.add(defaultTargetBox);
        this.stmtBoxes = Collections.unmodifiableList(this.stmtBoxes);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        String endOfLine = " ";
        buffer.append("tableswitch(" + this.keyBox.getValue().toString() + ")" + endOfLine);
        buffer.append("{" + endOfLine);
        for (int i = this.lowIndex; i <= this.highIndex; ++i) {
            buffer.append("    case " + i + ": " + "goto" + " " + this.getTarget(i - this.lowIndex) + ";" + endOfLine);
        }
        buffer.append("    default: goto " + this.getDefaultTarget() + ";" + endOfLine);
        buffer.append("}");
        return buffer.toString();
    }

    @Override
    public void toString(UnitPrinter up) {
        up.literal("tableswitch");
        up.literal("(");
        this.keyBox.toString(up);
        up.literal(")");
        up.newline();
        up.literal("{");
        up.newline();
        for (int i = this.lowIndex; i <= this.highIndex; ++i) {
            up.literal("    ");
            up.literal("case");
            up.literal(" ");
            up.literal(new Integer(i).toString());
            up.literal(": ");
            up.literal("goto");
            up.literal(" ");
            this.targetBoxes[i - this.lowIndex].toString(up);
            up.literal(";");
            up.newline();
        }
        up.literal("    ");
        up.literal("default");
        up.literal(": ");
        up.literal("goto");
        up.literal(" ");
        this.defaultTargetBox.toString(up);
        up.literal(";");
        up.newline();
        up.literal("}");
    }

    @Override
    public Unit getDefaultTarget() {
        return this.defaultTargetBox.getUnit();
    }

    @Override
    public void setDefaultTarget(Unit defaultTarget) {
        this.defaultTargetBox.setUnit(defaultTarget);
    }

    @Override
    public UnitBox getDefaultTargetBox() {
        return this.defaultTargetBox;
    }

    @Override
    public Value getKey() {
        return this.keyBox.getValue();
    }

    @Override
    public void setKey(Value key) {
        this.keyBox.setValue(key);
    }

    @Override
    public ValueBox getKeyBox() {
        return this.keyBox;
    }

    @Override
    public void setLowIndex(int lowIndex) {
        this.lowIndex = lowIndex;
    }

    @Override
    public void setHighIndex(int highIndex) {
        this.highIndex = highIndex;
    }

    @Override
    public int getLowIndex() {
        return this.lowIndex;
    }

    @Override
    public int getHighIndex() {
        return this.highIndex;
    }

    @Override
    public List getTargets() {
        ArrayList<Unit> targets = new ArrayList<Unit>();
        for (UnitBox element : this.targetBoxes) {
            targets.add(element.getUnit());
        }
        return targets;
    }

    @Override
    public Unit getTarget(int index) {
        return this.targetBoxes[index].getUnit();
    }

    @Override
    public void setTarget(int index, Unit target) {
        this.targetBoxes[index].setUnit(target);
    }

    @Override
    public void setTargets(List<Unit> targets) {
        for (int i = 0; i < targets.size(); ++i) {
            this.targetBoxes[i].setUnit(targets.get(i));
        }
    }

    @Override
    public UnitBox getTargetBox(int index) {
        return this.targetBoxes[index];
    }

    @Override
    public List getUseBoxes() {
        ArrayList<ValueBox> list = new ArrayList<ValueBox>();
        list.addAll(this.keyBox.getValue().getUseBoxes());
        list.add(this.keyBox);
        return list;
    }

    @Override
    public List getUnitBoxes() {
        return this.stmtBoxes;
    }

    @Override
    public void apply(Switch sw) {
        ((StmtSwitch)sw).caseTableSwitchStmt(this);
    }

    @Override
    public void convertToBaf(JimpleToBafContext context, List<Unit> out) {
        ArrayList<PlaceholderInst> targetPlaceholders = new ArrayList<PlaceholderInst>();
        ((ConvertToBaf)((Object)this.getKey())).convertToBaf(context, out);
        for (int i = 0; i < this.targetBoxes.length; ++i) {
            targetPlaceholders.add(Baf.v().newPlaceholderInst(this.getTarget(i)));
        }
        TableSwitchInst u = Baf.v().newTableSwitchInst(Baf.v().newPlaceholderInst(this.getDefaultTarget()), this.lowIndex, this.highIndex, targetPlaceholders);
        out.add(u);
        JTableSwitchStmt currentUnit = this;
        Iterator<Tag> it = currentUnit.getTags().iterator();
        while (it.hasNext()) {
            u.addTag(it.next());
        }
    }

    @Override
    public boolean fallsThrough() {
        return false;
    }

    @Override
    public boolean branches() {
        return true;
    }
}

